/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.xsd;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.DeleteWSDLAndXSDAction;
import org.eclipse.wst.wsdl.ui.internal.extension.IMenuActionContributor;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLComponentViewer;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLGroupObject;
import org.eclipse.wst.wsdl.ui.internal.xsd.actions.AddSchemaAction;
import org.eclipse.wst.wsdl.ui.internal.xsd.actions.BackAction;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDMenuListener;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateGroupAction;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.gef.util.editparts.AbstractComponentViewerRootEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.TopLevelComponentEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDMenuActionContributor
implements IMenuActionContributor {
    Element currElement;
    Document currDocument;
    XSDSchema xsdSchema;
    WSDLEditor wsdlEditor;

    public XSDMenuActionContributor(WSDLEditor wsdlEditor) {
        this.wsdlEditor = wsdlEditor;
    }

    public void contributeMenuActions(IMenuManager manager, Node node, Object object) {
        XSDMenuExtensionListener xsdMenuListener = new XSDMenuExtensionListener(this.wsdlEditor.getSelectionManager());
        xsdMenuListener.contributeMenuActions(manager, node, object);
    }

    class XSDMenuExtensionListener
    extends XSDMenuListener {
        public XSDMenuExtensionListener(ISelectionProvider selectionProvider) {
            super(selectionProvider);
        }

        public void contributeMenuActions(IMenuManager manager, Node node, Object object) {
            BackAction backAction;
            this.updateXSDSchema();
            AbstractComponentViewerRootEditPart editPart = (AbstractComponentViewerRootEditPart)XSDMenuActionContributor.this.wsdlEditor.getGraphViewer().getComponentViewer().getRootEditPart().getContents();
            EditPart focusEditPart = XSDMenuActionContributor.this.wsdlEditor.getGraphViewer().getComponentViewer().getFocusEditPart();
            if (object instanceof WSDLGroupObject) {
                WSDLGroupObject group = (WSDLGroupObject)object;
                if (group.getType() == 6) {
                    boolean typesExist = group.getParent().getTypes() != null;
                    Element typesElement = null;
                    if (typesExist) {
                        Types types = group.getParent().getETypes();
                        typesElement = types.getElement();
                    }
                    if (manager != null) {
                        Document document = null;
                        if (editPart.getViewer() instanceof WSDLComponentViewer) {
                            WSDLComponentViewer wsdlComponentViewer = (WSDLComponentViewer)editPart.getViewer();
                            document = wsdlComponentViewer.getWSDLEditor().getXMLDocument();
                        }
                        manager.add((IAction)new AddSchemaAction(group.getDefinition(), (Element)node, typesElement, document));
                    }
                }
            } else if (object instanceof Types && manager != null) {
                Types types = (Types)object;
                manager.add((IAction)new AddSchemaAction(types.getEnclosingDefinition(), (Element)node));
            }
            if (this.xsdSchema == null) {
                return;
            }
            ArrayList<DOMAttribute> attributes = null;
            Node relativeNode = null;
            if (object instanceof XSDSchema || focusEditPart instanceof TopLevelComponentEditPart || object instanceof Category) {
                backAction = new BackAction(WSDLEditorPlugin.getWSDLString("_UI_BACK_TO", "Definition"));
                backAction.setDefinition(XSDMenuActionContributor.this.wsdlEditor.getDefinition());
                backAction.setSelectionProvider(this.selectionProvider);
                backAction.setRootEditPart(editPart);
                backAction.setGraphViewer(XSDMenuActionContributor.this.wsdlEditor.getGraphViewer());
                manager.add((IAction)backAction);
                manager.add((IContributionItem)new Separator());
            } else if (object instanceof XSDConcreteComponent) {
                backAction = new BackAction(XSDEditorPlugin.getXSDString((String)"_UI_ACTION_BACK_TO_SCHEMA_VIEW"));
                backAction.setXSDSchema(this.xsdSchema);
                backAction.setSelectionProvider(this.selectionProvider);
                backAction.setRootEditPart(editPart);
                backAction.setGraphViewer(XSDMenuActionContributor.this.wsdlEditor.getGraphViewer());
                manager.add((IAction)backAction);
                manager.add((IContributionItem)new Separator());
            }
            if (object instanceof XSDConcreteComponent || object instanceof XSDSchemaExtensibilityElement) {
                Element parent;
                if (object instanceof XSDConcreteComponent) {
                    parent = ((XSDConcreteComponent)object).getElement();
                    this.xsdSchema = ((XSDConcreteComponent)object).getSchema();
                } else if (object instanceof Element) {
                    manager.add((IContributionItem)new Separator());
                    parent = (Element)object;
                } else if (object instanceof XSDSchemaExtensibilityElement) {
                    XSDSchemaExtensibilityElement schema = (XSDSchemaExtensibilityElement)object;
                    this.xsdSchema = schema.getSchema();
                    manager.add((IContributionItem)new Separator());
                    parent = this.xsdSchema.getElement();
                } else {
                    return;
                }
                XSDMenuActionContributor.this.currElement = parent;
                XSDMenuActionContributor.this.currDocument = parent.getOwnerDocument();
                this.addContextItems(manager, XSDMenuActionContributor.this.currElement, null);
                if (!(object instanceof XSDSchema) || object instanceof XSDSchema && !(XSDMenuActionContributor.this.wsdlEditor.getGraphViewer().getComponentViewer().getInput() instanceof XSDSchema)) {
                    IStructuredSelection selections = (IStructuredSelection)XSDMenuActionContributor.this.wsdlEditor.getSelectionManager().getSelection();
                    manager.add((IContributionItem)new Separator());
                    DeleteWSDLAndXSDAction deleteWSDLAndXSDAction = new DeleteWSDLAndXSDAction(selections.toList(), XSDMenuActionContributor.this.currElement, XSDMenuActionContributor.this.wsdlEditor);
                    deleteWSDLAndXSDAction.setEnabled(!this.isReadOnly);
                    manager.add((IAction)deleteWSDLAndXSDAction);
                }
            } else if (object instanceof Category || object instanceof CategoryAdapter) {
                Element parent;
                int groupType = -1;
                if (object instanceof Category) {
                    Category cg = (Category)object;
                    this.xsdSchema = cg.getXSDSchema();
                    groupType = cg.getGroupType();
                } else {
                    CategoryAdapter category = (CategoryAdapter)object;
                    groupType = category.getGroupType();
                    this.xsdSchema = category.getXSDSchema();
                }
                XSDMenuActionContributor.this.currElement = parent = this.xsdSchema.getElement();
                XSDMenuActionContributor.this.currDocument = parent.getOwnerDocument();
                switch (groupType) {
                    case 3: {
                        attributes = new ArrayList<DOMAttribute>();
                        attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("ComplexType")));
                        Action action = this.addCreateElementAction(manager, "complexType", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_COMPLEX_TYPE"), attributes, parent, relativeNode);
                        ((CreateElementAction)action).setIsGlobal(true);
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("SimpleType")));
                        Action action2 = this.addCreateSimpleTypeAction(manager, "simpleType", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_SIMPLE_TYPE"), attributes, parent, relativeNode);
                        ((CreateElementAction)action2).setIsGlobal(true);
                        break;
                    }
                    case 2: {
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("name", this.getNewGlobalName("element", "GlobalElement")));
                        attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                        Action action = this.addCreateElementAction(manager, "element", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_ELEMENT"), attributes, parent, relativeNode);
                        ((CreateElementAction)action).setIsGlobal(true);
                        break;
                    }
                    case 5: {
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("name", this.getNewGlobalName("group", "Group")));
                        CreateGroupAction groupAction = this.addCreateGroupAction(manager, "group", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_GROUP"), attributes, parent, relativeNode);
                        groupAction.setIsGlobal(true);
                        break;
                    }
                    case 1: {
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("name", this.getNewGlobalName("attribute", "GlobalAttribute")));
                        attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                        Action action = this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_GLOBAL_ATTRIBUTE"), attributes, parent, relativeNode);
                        ((CreateElementAction)action).setIsGlobal(true);
                        break;
                    }
                    case 8: {
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("name", this.getNewGlobalName("attributeGroup", "AttributeGroup")));
                        Action action = this.addCreateElementAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_ATTRIBUTE_GROUP"), attributes, parent, relativeNode);
                        ((CreateElementAction)action).setIsGlobal(true);
                        break;
                    }
                    case 7: {
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("name", this.getNewGlobalName("notation", "Notation")));
                        attributes.add(new DOMAttribute("public", ""));
                        Action action = this.addCreateElementAction(manager, "notation", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_NOTATION"), attributes, parent, relativeNode);
                        ((CreateElementAction)action).setIsGlobal(true);
                        break;
                    }
                    case 6: {
                        boolean b = true;
                        NodeList children = parent.getChildNodes();
                        Node effectiveRelativeNode = parent.getFirstChild();
                        int i = 0;
                        while (i < children.getLength() && b) {
                            Node child = children.item(i);
                            if (child != null && child instanceof Element) {
                                if (XSDDOMHelper.inputEquals((Object)((Element)child), (String)"include", (boolean)false) || XSDDOMHelper.inputEquals((Object)((Element)child), (String)"import", (boolean)false) || XSDDOMHelper.inputEquals((Object)((Element)child), (String)"redefine", (boolean)false) || XSDDOMHelper.inputEquals((Object)((Element)child), (String)"annotation", (boolean)false)) {
                                    effectiveRelativeNode = child;
                                } else {
                                    b = false;
                                }
                            }
                            ++i;
                        }
                        relativeNode = effectiveRelativeNode != null ? effectiveRelativeNode.getNextSibling() : null;
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("schemaLocation", ""));
                        this.addCreateElementAction(manager, "include", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_INCLUDE"), attributes, parent, relativeNode);
                        this.addCreateElementAction(manager, "import", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_IMPORT"), null, parent, relativeNode);
                        this.addCreateElementAction(manager, "redefine", XSDEditorPlugin.getXSDString((String)"_UI_ACTION_ADD_REDEFINE"), attributes, parent, relativeNode);
                    }
                }
            }
        }

        protected IFile getFileResource() {
            return null;
        }

        protected XSDSchema getXSDSchema() {
            return this.xsdSchema;
        }

        protected IDOMModel getXMLModel() {
            Document obj;
            if (XSDMenuActionContributor.this.currElement != null && (obj = XSDMenuActionContributor.this.currElement.getOwnerDocument()) instanceof DocumentImpl) {
                DocumentImpl xmlDoc = (DocumentImpl)XSDMenuActionContributor.this.currElement.getOwnerDocument();
                return xmlDoc.getModel();
            }
            return null;
        }
    }
}

