/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.locator;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.web.locator.AbstractWebTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.taglib.DirTaglibInfo;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibInfo;
import org.eclipse.jst.j2ee.internal.web.taglib.TLDDigester;
import org.eclipse.jst.j2ee.internal.web.taglib.TaglibInfo;

public class WebProjectTaglibLocator
extends AbstractWebTaglibLocator {
    public WebProjectTaglibLocator(IProject project) {
        super(project);
    }

    protected ITaglibInfo[] searchFile(IFile file) {
        if (this.isTaglibJar(file)) {
            return this.searchJarFile(file);
        }
        if (this.isTLDFile(file)) {
            return this.searchTLDFile(file);
        }
        return EMPTY_TAGLIBINFO_ARRAY;
    }

    protected ITaglibInfo[] searchDir(IContainer container) {
        ITaglibInfo taglib;
        File[] tagFiles = container.getLocation().toFile().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.isDirectory() && new Path(pathname.getName()).getFileExtension().equalsIgnoreCase("tag");
            }
        });
        if (tagFiles != null && tagFiles.length > 0 && (taglib = this.createTaglibForDir(container, tagFiles)) != null) {
            return new ITaglibInfo[]{taglib};
        }
        return EMPTY_TAGLIBINFO_ARRAY;
    }

    private ITaglibInfo createTaglibForDir(IContainer container, File[] tagFiles) {
        String uri = this.calculateURIForFile(container.getProjectRelativePath());
        DirTaglibInfo dirTaglibInfo = new DirTaglibInfo(container, uri, container.getProjectRelativePath());
        dirTaglibInfo.setPrefix(this.calculateShortNameForTaglib(uri));
        return dirTaglibInfo;
    }

    private String calculateShortNameForTaglib(String uri) {
        if ((uri = uri.replace('\\', '/')).equalsIgnoreCase("/WEB-INF/tags")) {
            return "tags";
        }
        String suffixOfURI = uri.substring("/WEB-INF/tags/".length());
        suffixOfURI = suffixOfURI.replace('/', '-');
        suffixOfURI = suffixOfURI.replace('\\', '-');
        return suffixOfURI;
    }

    protected ITaglibInfo[] searchTLDFile(IFile file) {
        ArrayList<ITaglibInfo> results = new ArrayList<ITaglibInfo>(2);
        boolean canAddTaglibTLD = true;
        TLDDigester digester = this.getTLDDigester(file);
        if (!this.isValidTLD(digester)) {
            canAddTaglibTLD = false;
        }
        if (canAddTaglibTLD) {
            ITaglibInfo taglib = this.createTaglibForTLD(this.calculateURIForFile(file.getProjectRelativePath()), file.getProjectRelativePath());
            ((TaglibInfo)taglib).setPrefix(digester);
            if (taglib != null) {
                results.add(taglib);
            }
        }
        if (digester != null) {
            digester.close();
        }
        return results.toArray(new ITaglibInfo[results.size()]);
    }

    public ITaglibInfo[] search(IResource resource) {
        final ArrayList results = new ArrayList();
        try {
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource aresource) throws CoreException {
                    int JSPVersion = WebProjectTaglibLocator.this.getJSPVersion();
                    if (aresource.getType() != 1) {
                        if (aresource.getType() != 8 && WebProjectTaglibLocator.this.project != aresource.getProject()) {
                            return false;
                        }
                        if (JSPVersion == 20) {
                            ITaglibInfo[] taglibs = WebProjectTaglibLocator.this.searchDir((IContainer)aresource);
                            if (taglibs != null) {
                                results.addAll(Arrays.asList(taglibs));
                            }
                            return true;
                        }
                        return false;
                    }
                    if (WebProjectTaglibLocator.this.hasTagExtension(aresource.getName())) {
                        ITaglibInfo[] taglibs;
                        if (JSPVersion == 20 && (taglibs = WebProjectTaglibLocator.this.searchDir(aresource.getParent())) != null) {
                            results.addAll(Arrays.asList(taglibs));
                        }
                    } else {
                        ITaglibInfo[] taglibs = WebProjectTaglibLocator.this.searchFile((IFile)aresource);
                        if (taglibs != null) {
                            results.addAll(Arrays.asList(taglibs));
                        }
                    }
                    return false;
                }
            });
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return results.toArray(new ITaglibInfo[results.size()]);
    }
}

