/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.operations.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.internal.web.operations.WebProjectInfo;
import org.eclipse.jst.j2ee.internal.web.operations.WebPropertiesUtil;

public class LibDirBuilder
extends IncrementalProjectBuilder
implements IResourceDeltaVisitor {
    public static boolean TRACING = false;
    protected IProgressMonitor pMonitor = null;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = this.getDelta(this.getProject());
        boolean isFullBuild = kind == 6 || delta == null;
        try {
            if (isFullBuild) {
                LibDirBuilder.synch(this.getProject(), monitor);
            } else {
                this.pMonitor = monitor;
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException ex) {
            Logger.getLogger().log((Throwable)ex);
        }
        return null;
    }

    protected static boolean createLibEntry(IJavaProject javaProject, IPath library_path) {
        boolean added = false;
        try {
            WebProjectInfo projectInfo = new WebProjectInfo();
            projectInfo.setProjectName(javaProject.getProject().getName());
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)library_path, null, null);
            boolean addEntry = true;
            int i = 0;
            while (i < cp.length) {
                if (cp[i].equals(entry)) {
                    addEntry = false;
                }
                ++i;
            }
            if (addEntry) {
                IClasspathEntry[] newPath = new IClasspathEntry[cp.length + 1];
                int i2 = 0;
                i2 = 0;
                while (i2 < cp.length) {
                    if (i2 < cp.length) {
                        newPath[i2] = cp[i2];
                    }
                    ++i2;
                }
                newPath[i2] = entry;
                javaProject.setRawClasspath(newPath, null);
            }
            added = true;
        }
        catch (JavaModelException ex) {
            Logger.getLogger().log((Throwable)ex);
        }
        return added;
    }

    protected static boolean removeLibEntry(IJavaProject javaProject, IPath library_path) {
        boolean added = false;
        try {
            WebProjectInfo projectInfo = new WebProjectInfo();
            projectInfo.setProjectName(javaProject.getProject().getName());
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)library_path, null, null);
            int found = -1;
            int i = 0;
            while (i < cp.length) {
                if (cp[i].getPath().equals((Object)entry.getPath())) {
                    found = i;
                }
                ++i;
            }
            if (found != -1) {
                IClasspathEntry[] newPath = new IClasspathEntry[cp.length - 1];
                int i2 = 0;
                int pos = 0;
                i2 = 0;
                while (i2 <= newPath.length) {
                    if (i2 != found) {
                        newPath[pos++] = cp[i2];
                    }
                    ++i2;
                }
                javaProject.setRawClasspath(newPath, null);
            }
            added = true;
        }
        catch (JavaModelException ex) {
            Logger.getLogger().log((Throwable)ex);
        }
        return added;
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        if (TRACING) {
            Logger.getLogger().log((Object)(String.valueOf(((Object)((Object)this)).getClass().getName()) + ProjectSupportResourceHandler.getString("24concat_INFO_", new Object[]{this.getProject()})));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void synch(IProject project, IProgressMonitor monitor) {
        try {
            try {
                IFolder lib_folder;
                block27: {
                    block26: {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask(ProjectSupportResourceHandler.getString("Sychronize_Class_Path_UI_"), 4);
                        lib_folder = WebPropertiesUtil.getWebLibFolder(project);
                        if (lib_folder == null) break block26;
                        if (lib_folder.isAccessible()) break block27;
                    }
                    Object var14_5 = null;
                    monitor.done();
                    return;
                }
                IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
                IPath lib_path = lib_folder.getProjectRelativePath();
                IPath lib_full_path = lib_folder.getFullPath();
                IClasspathEntry[] cp = javaProject.getRawClasspath();
                boolean needsToBeModified = false;
                Hashtable<IPath, IResource> lib_jars = new Hashtable<IPath, IResource>();
                IResource[] children = lib_folder.members();
                monitor.subTask(ProjectSupportResourceHandler.getString("Catalog_Lib_Directory__UI_"));
                int j = 0;
                while (j < children.length) {
                    IResource child = children[j];
                    if (child.getType() == 1 && (child.getFullPath().toString().toLowerCase().endsWith(".jar") || child.getFullPath().toString().toLowerCase().endsWith(".zip"))) {
                        lib_jars.put(child.getFullPath(), child);
                    }
                    ++j;
                }
                monitor.worked(1);
                monitor.subTask(ProjectSupportResourceHandler.getString("Update_ClassPath__UI_"));
                Vector<IClasspathEntry> newClassPathVector = new Vector<IClasspathEntry>();
                int j2 = 0;
                while (j2 < cp.length) {
                    if (cp[j2].getPath().toString().startsWith(lib_path.toString()) || cp[j2].getPath().toString().startsWith(lib_full_path.toString())) {
                        if (lib_jars.get(cp[j2].getPath()) != null) {
                            newClassPathVector.add(cp[j2]);
                            lib_jars.remove(cp[j2].getPath());
                        } else {
                            needsToBeModified = true;
                        }
                    } else {
                        monitor.subTask(String.valueOf(ProjectSupportResourceHandler.getString("Catalog_Lib_Directory__UI_")) + cp[j2].getPath());
                        newClassPathVector.add(cp[j2]);
                    }
                    ++j2;
                }
                monitor.worked(1);
                monitor.subTask(ProjectSupportResourceHandler.getString("Update_ClassPath__UI_"));
                Enumeration aenum = lib_jars.keys();
                while (aenum.hasMoreElements()) {
                    IPath path = (IPath)aenum.nextElement();
                    newClassPathVector.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                    needsToBeModified = true;
                }
                monitor.worked(1);
                monitor.subTask(ProjectSupportResourceHandler.getString("Set_ClassPath__UI_"));
                IClasspathEntry[] newClassPathArray = new IClasspathEntry[newClassPathVector.size()];
                int j3 = 0;
                while (j3 < newClassPathArray.length) {
                    newClassPathArray[j3] = (IClasspathEntry)newClassPathVector.get(j3);
                    ++j3;
                }
                if (needsToBeModified) {
                    try {
                        javaProject.setRawClasspath(newClassPathArray, monitor);
                    }
                    catch (Exception e) {
                        Logger.getLogger().log((Throwable)e);
                    }
                }
            }
            catch (ClassCastException ex) {
                Logger.getLogger().log((Throwable)ex);
            }
            catch (CoreException ex) {
                Logger.getLogger().log((Throwable)ex);
            }
            Object var14_7 = null;
        }
        catch (Throwable throwable) {
            Object var14_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public boolean visit(IResourceDelta subdelta) throws CoreException {
        try {
            IResource resource = subdelta.getResource();
            if (resource.getType() == 1) {
                String filePath = subdelta.getFullPath().toString();
                if (filePath.toLowerCase().endsWith(".jar") || filePath.toLowerCase().endsWith(".zip")) {
                    IProject project = resource.getProject();
                    IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
                    IPath lib_path = project.getFullPath().append(WebPropertiesUtil.getWebLibFolder(project).getProjectRelativePath());
                    int file_seg_count = subdelta.getFullPath().segmentCount();
                    int lib_path_seg_count = lib_path.segmentCount();
                    if (filePath.startsWith(lib_path.toString()) && file_seg_count == lib_path_seg_count + 1) {
                        int kind = subdelta.getKind();
                        switch (kind) {
                            case 1: {
                                LibDirBuilder.createLibEntry(javaProject, (IPath)new Path(filePath));
                                break;
                            }
                            case 2: {
                                LibDirBuilder.removeLibEntry(javaProject, (IPath)new Path(filePath));
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 16: {
                                break;
                            }
                        }
                    }
                }
            } else if (resource.getType() == 4) {
                LibDirBuilder.synch((IProject)resource, this.pMonitor);
            }
        }
        catch (ClassCastException classCastException) {}
        return true;
    }
}

