/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;

public class MultiPageEditorSite
implements IEditorSite {
    private IEditorPart editor;
    private MultiPageEditorPart multiPageEditor;
    private ISelectionProvider selectionProvider = null;
    private ISelectionChangedListener selectionChangedListener = null;
    private IKeyBindingService service = null;

    public MultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
        Assert.isNotNull((Object)multiPageEditor);
        Assert.isNotNull((Object)editor);
        this.multiPageEditor = multiPageEditor;
        this.editor = editor;
    }

    public void dispose() {
        if (this.service != null) {
            IKeyBindingService parentService = this.getEditor().getSite().getKeyBindingService();
            if (parentService instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableParent = (INestableKeyBindingService)parentService;
                nestableParent.removeKeyBindingService(this);
            }
            this.service = null;
        }
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return null;
    }

    public IActionBars getActionBars() {
        return this.multiPageEditor.getEditorSite().getActionBars();
    }

    public ILabelDecorator getDecoratorManager() {
        return this.getWorkbenchWindow().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public String getId() {
        return "";
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.service == null) {
            this.service = this.getMultiPageEditor().getEditorSite().getKeyBindingService();
            if (this.service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)this.service;
                this.service = nestableService.getKeyBindingService(this);
            } else {
                WorkbenchPlugin.log("MultiPageEditorSite.getKeyBindingService()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + this.service.getClass().getName() + " instead.");
            }
        }
        return this.service;
    }

    public MultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public IWorkbenchPage getPage() {
        return this.getMultiPageEditor().getSite().getPage();
    }

    public String getPluginId() {
        return "";
    }

    public String getRegisteredName() {
        return "";
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MultiPageEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.selectionChangedListener;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        return this.getMultiPageEditor().getSite().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getMultiPageEditor().getSite().getWorkbenchWindow();
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((MultiPageSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        this.getMultiPageEditor().getSite().registerContextMenu(menuID, menuMgr, selProvider);
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
        this.getMultiPageEditor().getSite().registerContextMenu(menuManager, selProvider);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        this.selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
        }
    }

    public void progressEnd(Job job) {
    }

    public void progressStart(Job job) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IWorkbenchPart getPart() {
        return this.editor;
    }

    public final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        this.getMultiPageEditor().getEditorSite().registerContextMenu(menuId, menuManager, selectionProvider, includeEditorInput);
    }

    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        this.getMultiPageEditor().getEditorSite().registerContextMenu(menuManager, selectionProvider, includeEditorInput);
    }
}

