/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.common.navigator.internal.actions.OpenAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.wst.common.frameworks.internal.AdaptabilityUtility;

public class OpenEditorActionGroup
extends ActionGroup {
    public static final String OPENWITH_MENU_ID = "org.eclipse.wst.common.frameworks.internal.navigator.openWith.menu";
    private IWorkbenchSite fSite;
    private OpenAction fOpen;
    static /* synthetic */ Class class$0;

    public OpenEditorActionGroup(IViewPart part) {
        this.fSite = part.getSite();
        this.fOpen = new OpenAction(this.fSite);
        this.initialize(this.fSite.getSelectionProvider());
    }

    public IAction getOpenAction() {
        return this.fOpen;
    }

    private void initialize(ISelectionProvider provider) {
        ISelection selection = provider.getSelection();
        this.fOpen.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpen);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.fOpen.selectionChanged(this.getSelection());
        this.appendToGroup(menu, (IAction)this.fOpen);
        if (this.fOpen.isEnabled()) {
            this.addOpenWithMenu(menu);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)this.fOpen);
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IStructuredSelection ss = this.getSelection();
        if (ss == null || ss.size() != 1) {
            return;
        }
        Object o = ss.getFirstElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource resource = (IResource)AdaptabilityUtility.getAdapter((Object)o, (Class)clazz);
        MenuManager submenu = new MenuManager(ActionMessages.OpenWithMenu_label, OPENWITH_MENU_ID);
        submenu.add((IContributionItem)new GroupMarker("group.new"));
        if (resource != null && !(resource instanceof IProject) && !(resource instanceof IFolder)) {
            submenu.add((IContributionItem)new OpenWithMenu(this.fSite.getPage(), (IAdaptable)resource));
        }
        this.addCustomOpenWith((IMenuManager)submenu);
        submenu.add((IContributionItem)new GroupMarker("additions"));
        if (submenu.getItems().length > 2 && submenu.isEnabled()) {
            menu.appendToGroup("group.open", (IContributionItem)submenu);
        }
    }

    protected void addCustomOpenWith(IMenuManager submenu) {
    }

    public IStructuredSelection getSelection() {
        ISelection selection = this.getContext().getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return StructuredSelection.EMPTY;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        return ss;
    }
}

