/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.navigator.internal.provisional.views.ILinkHelper;

public class JavaElementLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput input) {
        IClassFile javaElement = null;
        if (input instanceof IClassFileEditorInput) {
            javaElement = ((IClassFileEditorInput)input).getClassFile();
        } else if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            javaElement = JavaCore.create((IFile)file);
        } else if (input instanceof JarEntryEditorInput) {
            javaElement = ((JarEntryEditorInput)input).getStorage();
        }
        return javaElement != null ? new StructuredSelection((Object)javaElement) : StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        Object element = aSelection.getFirstElement();
        IEditorPart part = EditorUtility.isOpenInEditor((Object)element);
        if (part != null) {
            aPage.bringToTop((IWorkbenchPart)part);
            if (element instanceof IJavaElement) {
                EditorUtility.revealInEditor((IEditorPart)part, (IJavaElement)((IJavaElement)element));
            }
        }
    }
}

