/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;

public class FileResourceOutputStream
extends OutputStream {
    IPath fFilePath;
    ResourceContext fResourceContext;
    ProgressMonitor fMonitor;
    StatusHandler fStatusHandler;
    ByteArrayOutputStream fByteArrayOutputStream;
    boolean fOpen;

    public FileResourceOutputStream(ResourceContext resourceContext, IPath filePath, ProgressMonitor monitor, StatusHandler statusHandler) {
        this.fFilePath = filePath;
        this.fResourceContext = resourceContext;
        this.fMonitor = monitor;
        this.fStatusHandler = statusHandler;
        this.fByteArrayOutputStream = new ByteArrayOutputStream();
        this.fOpen = true;
    }

    public void close() throws IOException {
        if (!this.fOpen) {
            return;
        }
        this.fOpen = false;
        this.fByteArrayOutputStream.close();
        byte[] buffer = this.fByteArrayOutputStream.toByteArray();
        ByteArrayInputStream tempInputStream = new ByteArrayInputStream(buffer);
        try {
            FileResourceUtils.createFile(this.fResourceContext, this.fFilePath, tempInputStream, this.fMonitor, this.fStatusHandler);
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void flush() throws IOException {
        this.fByteArrayOutputStream.flush();
    }

    public void write(byte[] b) throws IOException {
        this.fByteArrayOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) {
        this.fByteArrayOutputStream.write(b, off, len);
    }

    public void write(int b) {
        this.fByteArrayOutputStream.write(b);
    }
}

