/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;

public class ValidationInfo
implements ValidationReport {
    private boolean WRAPPER_ERROR_SUPPORT_ENABLED = true;
    public static int SEV_ERROR = 0;
    public static int SEV_WARNING = 1;
    private static String _UI_REF_FILE_ERROR_MESSAGE = "_UI_REF_FILE_ERROR_MESSAGE";
    private String validating_file_uri = null;
    private URL validating_file_url = null;
    private boolean valid = true;
    private List messages = new ArrayList();
    private HashMap nestedMessages = new HashMap();
    protected ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.wst.xml.core.internal.validation.xmlvalidation");

    public ValidationInfo(String uri) {
        if (uri != null) {
            this.validating_file_uri = uri;
            try {
                this.validating_file_url = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public String getFileURI() {
        return this.validating_file_uri;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addError(String message, int line, int column, String uri) {
        this.addError(message, line, column, uri, null, null);
    }

    public void addError(String message, int line, int column, String uri, String key, Object[] messageArguments) {
        if (this.addMessage(message, line, column, uri, SEV_ERROR, key, messageArguments)) {
            this.valid = false;
        }
    }

    public void addWarning(String message, int line, int column, String uri) {
        this.addWarning(message, line, column, uri, null, null);
    }

    public void addWarning(String message, int line, int column, String uri, String key, Object[] messageArguments) {
        this.addMessage(message, line, column, uri, SEV_WARNING, key, messageArguments);
    }

    private boolean addMessage(String message, int line, int column, String uri, int severity, String key, Object[] messageArguments) {
        boolean successfullyAdded = false;
        if (message == null) {
            return successfullyAdded;
        }
        String errorURI = this.normalize(uri);
        URL errorURL = null;
        if (errorURI != null) {
            try {
                errorURL = new URL(errorURI);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (errorURL != null) {
            successfullyAdded = true;
            if (!this.WRAPPER_ERROR_SUPPORT_ENABLED || this.validating_file_url.sameFile(errorURL)) {
                ValidationMessage valmes = new ValidationMessage(message, line, column, this.validating_file_uri, key, messageArguments);
                if (severity == SEV_ERROR) {
                    valmes.setSeverity(ValidationMessage.SEV_NORMAL);
                } else if (severity == SEV_WARNING) {
                    valmes.setSeverity(ValidationMessage.SEV_LOW);
                }
                this.messages.add(valmes);
            } else if (this.WRAPPER_ERROR_SUPPORT_ENABLED) {
                String nesteduri = errorURL.toExternalForm();
                ValidationMessage nestedmess = new ValidationMessage(message, line, column, nesteduri, key, messageArguments);
                if (severity == SEV_WARNING) {
                    nestedmess.setSeverity(ValidationMessage.SEV_LOW);
                } else {
                    nestedmess.setSeverity(ValidationMessage.SEV_NORMAL);
                }
                ValidationMessage container = (ValidationMessage)this.nestedMessages.get(nesteduri);
                if (container == null) {
                    container = new ValidationMessage(MessageFormat.format(this.resourceBundle.getString(_UI_REF_FILE_ERROR_MESSAGE), nesteduri), 1, 0, nesteduri);
                    container.setSeverity(ValidationMessage.SEV_LOW);
                    this.nestedMessages.put(nesteduri, container);
                    this.messages.add(container);
                }
                container.addNestedMessage(nestedmess);
            }
        }
        return successfullyAdded;
    }

    public ValidationMessage[] getValidationMessages() {
        return this.messages.toArray(new ValidationMessage[this.messages.size()]);
    }

    public HashMap getNestedMessages() {
        return this.nestedMessages;
    }

    private String normalize(String uri) {
        uri = uri.replaceAll("%20", " ");
        uri = uri.replaceAll("%5E", "^");
        uri = uri.replace('\\', '/');
        return uri;
    }
}

