/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.widgets;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentEngine;
import org.eclipse.wst.command.internal.env.core.fragment.FragmentListener;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.CommandManager;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class SimpleCommandEngineManager {
    protected CommandFragmentEngine engine_;
    protected DataFlowManager dataManager_;
    private EclipseEnvironment environment_;
    private boolean foundStop_;
    private boolean doNotRunInTransaction_;

    public SimpleCommandEngineManager(EclipseEnvironment environment, DataFlowManager dataManager) {
        this.environment_ = environment;
        this.dataManager_ = dataManager;
    }

    public void setRootFragment(CommandFragment root) {
        this.engine_ = new CommandFragmentEngine(root, this.dataManager_, (Environment)this.environment_);
        this.environment_.setCommandManager((CommandManager)this.engine_);
        this.engine_.setPeekFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return SimpleCommandEngineManager.this.peekFragment(fragment);
            }
        });
        this.engine_.setNextFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return SimpleCommandEngineManager.this.nextFragment(fragment);
            }
        });
        this.engine_.setUndoFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return SimpleCommandEngineManager.this.undoFragment(fragment);
            }
        });
    }

    protected boolean peekFragment(CommandFragment fragment) {
        return true;
    }

    protected boolean nextFragment(CommandFragment fragment) {
        if (fragment.doNotRunInTransaction() != this.doNotRunInTransaction_) {
            this.doNotRunInTransaction_ = fragment.doNotRunInTransaction();
            this.foundStop_ = false;
        }
        return this.foundStop_;
    }

    protected boolean undoFragment(CommandFragment fragment) {
        return true;
    }

    public Status runForwardToNextStop(IRunnableContext context) {
        IRunnableWithProgress operation = null;
        this.doNotRunInTransaction_ = false;
        do {
            this.foundStop_ = true;
            operation = this.doNotRunInTransaction_ ? this.getNoTransactionOperation() : this.getTransactionOperation();
            try {
                if (context == null) {
                    operation.run(null);
                    continue;
                }
                context.run(false, false, operation);
            }
            catch (InterruptedException exc) {
                exc.printStackTrace();
            }
            catch (InvocationTargetException exc) {
                exc.printStackTrace();
            }
        } while (!this.foundStop_);
        return this.engine_.getLastStatus();
    }

    private IRunnableWithProgress getTransactionOperation() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EclipseProgressMonitor eclipseMonitor = (EclipseProgressMonitor)SimpleCommandEngineManager.this.environment_.getProgressMonitor();
                eclipseMonitor.setMonitor(monitor);
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5002, (Object)this, "getTransactionOperation", (Object)"Start of transaction");
                SimpleCommandEngineManager.this.engine_.moveForwardToNextStop();
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5003, (Object)this, "getTransactionOperation", (Object)"End of transaction");
            }
        };
        return operation;
    }

    private IRunnableWithProgress getNoTransactionOperation() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EclipseProgressMonitor eclipseMonitor = (EclipseProgressMonitor)SimpleCommandEngineManager.this.environment_.getProgressMonitor();
                eclipseMonitor.setMonitor(monitor);
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5085, (Object)this, "getNoTransactionOperation", (Object)"Start of NON transaction");
                SimpleCommandEngineManager.this.engine_.moveForwardToNextStop();
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5086, (Object)this, "getNoTransactionOperation", (Object)"End of NON transaction");
            }
        };
        return operation;
    }
}

