/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class ValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IValidationPage _pageImpl = null;

    protected Control createContents(Composite parent) {
        try {
            GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
            if (gp.numberOfValidators() == 0) {
                this._pageImpl = new NoValidatorsPage(parent);
            } else {
                try {
                    this._pageImpl = new ValidatorListPage(parent);
                }
                catch (InvocationTargetException exc) {
                    this._pageImpl = new InvalidPage(parent);
                    this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                }
                catch (Throwable exc) {
                    this._pageImpl = new InvalidPage(parent);
                    this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                }
            }
        }
        catch (InvocationTargetException exc) {
            this._pageImpl = new InvalidPage(parent);
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        catch (Throwable exc) {
            this._pageImpl = new InvalidPage(parent);
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        return this._pageImpl.getControl();
    }

    public void init(IWorkbench workbench) {
    }

    protected void noDefaultAndApplyButton() {
        super.noDefaultAndApplyButton();
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this._pageImpl.performDefaults();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
    }

    public boolean performOk() {
        try {
            return this._pageImpl.performOk();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
    }

    public void dispose() {
        super.dispose();
        try {
            if (this._pageImpl != null) {
                this._pageImpl.dispose();
            }
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
    }

    private void logError(Throwable exc) {
        Logger logger = WTPUIPlugin.getLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationUIPlugin.getLogEntry();
            entry.setSourceIdentifier("ValidationPreferencePage.displayAndLogError");
            entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL_PAGE");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc instanceof InvocationTargetException && ((InvocationTargetException)exc).getTargetException() != null) {
                entry.setTargetException(((InvocationTargetException)exc).getTargetException());
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    void displayAndLogError(String title, String message, Throwable exc) {
        this.logError(exc);
        this.displayMessage(title, message, 1);
    }

    private void displayMessage(String title, String message, int iIconType) {
        MessageBox messageBox = new MessageBox(this.getShell(), 0x20 | iIconType | 0x10000);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._pageImpl == null) {
            return;
        }
        if (visible) {
            this._pageImpl.gainFocus();
        } else {
            this._pageImpl.loseFocus();
        }
    }

    protected Button getDefaultsButton() {
        return super.getDefaultsButton();
    }

    public static interface IValidationPage {
        public Composite createPage(Composite var1) throws InvocationTargetException;

        public boolean performOk() throws InvocationTargetException;

        public boolean performDefaults() throws InvocationTargetException;

        public Composite getControl();

        public void dispose();

        public void loseFocus();

        public void gainFocus();
    }

    public class InvalidPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private Label messageLabel = null;

        public InvalidPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPreferencePage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_EXC_INVALID_REGISTER"));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }
    }

    private class NoValidatorsPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private GridData data = null;
        private Label messageLabel = null;

        public NoValidatorsPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPreferencePage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            this.data = new GridData(272);
            this.composite.setLayoutData((Object)this.data);
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_NO_VALIDATORS_INSTALLED"));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performOk() {
            return true;
        }

        public boolean performDefaults() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }
    }

    private class ValidatorListPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        CheckboxTableViewer validatorList = null;
        private Button selectAllButton = null;
        private Button deselectAllButton = null;
        private Label emptyRowPlaceholder = null;
        Button valWhenBuildButton = null;
        Button valWhenAutoBuildButton = null;
        private Text maxValProblemsField = null;
        private Label maxValProblemsFieldLabel = null;
        Button overrideButton = null;
        private Label listLabel = null;
        GlobalConfiguration pagePreferences = null;
        private boolean _isAutoBuildEnabled = ValidatorManager.getManager().isGlobalAutoBuildEnabled();
        private ValidatorMetaData[] _oldVmd = null;
        private boolean _allow = false;

        public ValidatorListPage(Composite parent) throws InvocationTargetException {
            this.pagePreferences = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
            this._oldVmd = this.pagePreferences.getEnabledValidators();
            this._allow = this.pagePreferences.canProjectsOverride();
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) throws InvocationTargetException {
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.composite.setLayout((Layout)new GridLayout());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            Composite validatorGroup = new Composite(this.composite, 0);
            GridLayout validatorGroupLayout = new GridLayout();
            validatorGroupLayout.numColumns = 2;
            validatorGroup.setLayout((Layout)validatorGroupLayout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)validatorGroup, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            GridData overrideData = new GridData(768);
            overrideData.horizontalSpan = 2;
            this.overrideButton = new Button(validatorGroup, 32);
            this.overrideButton.setLayoutData((Object)overrideData);
            this.overrideButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_OVERRIDE"));
            this.overrideButton.setEnabled(true);
            this.overrideButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setCanProjectsOverride(this.this$1.overrideButton.getSelection());
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideButton, "org.eclipse.wst.common.frameworks.ui.jvgp0005");
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData valWhenBuildData = new GridData(768);
            valWhenBuildData.horizontalSpan = 2;
            this.valWhenBuildButton = new Button(validatorGroup, 32);
            this.valWhenBuildButton.setLayoutData((Object)valWhenBuildData);
            this.valWhenBuildButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_FULL"));
            this.valWhenBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setBuildValidate(this.this$1.valWhenBuildButton.getSelection());
                    this.this$1.valWhenBuildButton.setFocus();
                }
            });
            GridData valWhenAutoBuildData = new GridData(768);
            valWhenAutoBuildData.horizontalSpan = 2;
            this.valWhenAutoBuildButton = new Button(validatorGroup, 32);
            this.valWhenAutoBuildButton.setLayoutData((Object)valWhenAutoBuildData);
            this.valWhenAutoBuildButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_AUTO"));
            this.valWhenAutoBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setAutoValidate(this.this$1.valWhenAutoBuildButton.getSelection());
                    this.this$1.valWhenAutoBuildButton.setFocus();
                }
            });
            this.listLabel = new Label(validatorGroup, 0);
            GridData listLabelData = new GridData(768);
            listLabelData.horizontalSpan = 2;
            this.listLabel.setLayoutData((Object)listLabelData);
            this.listLabel.setText(ResourceHandler.getExternalizedMessage("PREF_VALLIST_TITLE"));
            GridData validatorListData = new GridData(768);
            validatorListData.horizontalSpan = 2;
            this.validatorList = CheckboxTableViewer.newCheckList((Composite)validatorGroup, (int)2048);
            this.validatorList.getTable().setLayoutData((Object)validatorListData);
            this.validatorList.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
            this.validatorList.setContentProvider((IContentProvider)new ValidationContentProvider());
            this.validatorList.setSorter((ViewerSorter)new ValidationViewerSorter());
            this.validatorList.setInput((Object)this.pagePreferences.getValidators());
            this.validatorList.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.this$1.validatorList.getCheckedElements()));
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    try {
                        this.this$1.performDefaults();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            this.selectAllButton = new Button(validatorGroup, 8);
            this.selectAllButton.setLayoutData((Object)new GridData());
            this.selectAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_SELECTALL"));
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performSelectAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.selectAllButton, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            this.deselectAllButton = new Button(validatorGroup, 8);
            this.deselectAllButton.setLayoutData((Object)new GridData());
            this.deselectAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_DESELECTALL"));
            this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performDeselectAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.deselectAllButton, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            Composite buttonGroup = new Composite(this.composite, 0);
            GridLayout buttonGroupLayout = new GridLayout();
            buttonGroupLayout.numColumns = 2;
            buttonGroup.setLayout((Layout)buttonGroupLayout);
            buttonGroup.setLayoutData((Object)new GridData(256));
            this.maxValProblemsFieldLabel = new Label(buttonGroup, 0);
            this.maxValProblemsFieldLabel.setLayoutData((Object)new GridData());
            this.maxValProblemsFieldLabel.setText(ResourceHandler.getExternalizedMessage("PREF_LBL_MAXMSGS"));
            this.maxValProblemsField = new Text(buttonGroup, 2052);
            this.maxValProblemsField.setLayoutData((Object)new GridData(768));
            this.maxValProblemsField.addKeyListener(new KeyListener(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    try {
                        this.this$1.pagePreferences.setMaximumNumberOfMessages(this.this$1.checkInteger());
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.maxValProblemsField, "org.eclipse.wst.common.frameworks.ui.jvgp0030");
            validatorGroup.setTabList(new Control[]{this.overrideButton, this.valWhenBuildButton, this.valWhenAutoBuildButton, this.validatorList.getTable(), this.selectAllButton, this.deselectAllButton});
            this.updateWidgets();
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        protected int checkInteger() throws InvocationTargetException {
            GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
            String text = this.maxValProblemsField.getText();
            if (text == null) {
                ValidationPreferencePage.this.setErrorMessage(ResourceHandler.getExternalizedMessage("PREF_ERROR_INT"));
                return gp.getMaximumNumberOfMessages();
            }
            try {
                Integer tempInt = new Integer(text.trim());
                if (tempInt <= 0) {
                    ValidationPreferencePage.this.setErrorMessage(ResourceHandler.getExternalizedMessage("PREF_ERROR_INT"));
                    return gp.getMaximumNumberOfMessages();
                }
                ValidationPreferencePage.this.setErrorMessage(null);
                return Integer.valueOf(this.maxValProblemsField.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                ValidationPreferencePage.this.setErrorMessage(ResourceHandler.getExternalizedMessage("PREF_ERROR_INT"));
                return gp.getMaximumNumberOfMessages();
            }
        }

        protected void updateWidgets() throws InvocationTargetException {
            this.overrideButton.setSelection(this.pagePreferences.canProjectsOverride());
            this.maxValProblemsField.setText(String.valueOf(this.pagePreferences.getMaximumNumberOfMessages()));
            this.updateTable();
            boolean valEnabled = this.pagePreferences.numberOfEnabledValidators() > 0;
            this.valWhenBuildButton.setEnabled(valEnabled);
            this.valWhenBuildButton.setSelection(this.pagePreferences.isBuildValidate() && valEnabled);
            boolean incValEnabled = this.pagePreferences.numberOfEnabledIncrementalValidators() > 0;
            this.valWhenAutoBuildButton.setEnabled(this._isAutoBuildEnabled && incValEnabled);
            this.valWhenAutoBuildButton.setSelection(this.pagePreferences.isAutoValidate() && incValEnabled && this._isAutoBuildEnabled);
            this.updateHelp();
        }

        protected void updateTable() throws InvocationTargetException {
            TableItem[] items = this.validatorList.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                this.validatorList.setChecked((Object)vmd, this.pagePreferences.isEnabled(vmd));
                ++i;
            }
        }

        public boolean performOk() throws InvocationTargetException {
            this.storeValues();
            this.updateTaskList();
            return true;
        }

        public boolean performDefaults() throws InvocationTargetException {
            this.pagePreferences.resetToDefault();
            this.updateWidgets();
            this.checkInteger();
            ValidationPreferencePage.this.getDefaultsButton().setFocus();
            return true;
        }

        public boolean performSelectAll() throws InvocationTargetException {
            this.validatorList.setAllChecked(true);
            this.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.validatorList.getCheckedElements()));
            this.updateWidgets();
            this.selectAllButton.setFocus();
            return true;
        }

        public boolean performDeselectAll() throws InvocationTargetException {
            this.validatorList.setAllChecked(false);
            this.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.validatorList.getCheckedElements()));
            this.updateWidgets();
            this.deselectAllButton.setFocus();
            return true;
        }

        protected void updateHelp() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.valWhenBuildButton, "org.eclipse.wst.common.frameworks.ui.jvgp0010");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.valWhenAutoBuildButton, "org.eclipse.wst.common.frameworks.ui.jvgp0020");
        }

        private void storeValues() throws InvocationTargetException {
            this.pagePreferences.setCanProjectsOverride(this.overrideButton.getSelection());
            if (this.valWhenBuildButton.isEnabled()) {
                this.pagePreferences.setBuildValidate(this.valWhenBuildButton.getSelection());
            }
            if (this.valWhenAutoBuildButton.isEnabled()) {
                this.pagePreferences.setAutoValidate(this.valWhenAutoBuildButton.getSelection());
            }
            this.pagePreferences.setMaximumNumberOfMessages(this.checkInteger());
            this.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.validatorList.getCheckedElements()));
            this.pagePreferences.passivate();
            this.pagePreferences.store();
            if (!this.pagePreferences.canProjectsOverride()) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i];
                    try {
                        if (project.isOpen() && ConfigurationManager.getManager().isMigrated(project)) {
                            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                            prjp.setDoesProjectOverride(false);
                            prjp.passivate();
                            prjp.store();
                        }
                    }
                    catch (InvocationTargetException exc) {
                        ValidationPreferencePage.this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                    ++i;
                }
            }
        }

        private void updateTaskList() {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] projects = workspace.getRoot().getProjects();
            boolean allowChanged = this.pagePreferences.canProjectsOverride() != this._allow;
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                try {
                    ProjectConfiguration prjp;
                    if (project.isOpen() && !(prjp = ConfigurationManager.getManager().getProjectConfiguration(project)).doesProjectOverride() && (prjp.hasEnabledValidatorsChanged(this._oldVmd, allowChanged) || ValidatorManager.getManager().isMessageLimitExceeded((IResource)project))) {
                        ValidatorManager.getManager().updateTaskList(project);
                    }
                }
                catch (InvocationTargetException exc) {
                    ValidationPreferencePage.this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                }
                ++i;
            }
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.listLabel.dispose();
            this.overrideButton.dispose();
            this.maxValProblemsField.dispose();
            this.maxValProblemsFieldLabel.dispose();
            this.valWhenAutoBuildButton.dispose();
            this.valWhenBuildButton.dispose();
            this.emptyRowPlaceholder.dispose();
            this.deselectAllButton.dispose();
            this.selectAllButton.dispose();
            this.validatorList.getTable().dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
            try {
                this._isAutoBuildEnabled = ValidatorManager.getManager().isGlobalAutoBuildEnabled();
                this.updateWidgets();
            }
            catch (InvocationTargetException exc) {
                ValidationPreferencePage.this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            }
        }

        static /* synthetic */ ValidationPreferencePage access$0(ValidatorListPage validatorListPage) {
            return validatorListPage.ValidationPreferencePage.this;
        }

        public class ValidationContentProvider
        implements IStructuredContentProvider {
            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ValidatorMetaData[]) {
                    return (ValidatorMetaData[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ValidationLabelProvider
        extends LabelProvider {
            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ValidatorMetaData) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return super.getText(element);
            }
        }

        public class ValidationViewerSorter
        extends ViewerSorter {
            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        }
    }
}

