/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Import;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2101
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    boolean importFound = false;

    public BP2101(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(Import im, Object parent, WSDLTraversalContext ctx) {
        this.importFound = true;
        if (im.getDefinition() == null) {
            this.errors.add(String.valueOf(im.getNamespaceURI()) + ":" + im.getLocationURI() + "\nImport element does not reference a WSDL definition.");
        } else {
            try {
                this.validator.parseXMLDocumentURL(im.getLocationURI(), ((Definition)parent).getDocumentBaseURI(), TestUtils.getWSDLSchemaLocation());
            }
            catch (Throwable t) {
                this.errors.add(String.valueOf(im.getNamespaceURI()) + ":" + im.getLocationURI() + "\n" + Utils.getExceptionDetails(t));
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitImport(true);
        traversal.ignoreReferences();
        traversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.importFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

