/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;

public class ElementCollector
extends FeatureBuildScriptGenerator {
    public ElementCollector(String featureId, AssemblyInformation assemblageInformation) throws CoreException {
        super(featureId, null, assemblageInformation);
    }

    protected void generateIncludedFeatureBuildFile() throws CoreException {
        IIncludedFeatureReference[] referencedFeatures = this.feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < referencedFeatures.length) {
            block3: {
                String featureId = ((IncludedFeatureReferenceModel)referencedFeatures[i]).getFeatureIdentifier();
                ElementCollector generator = new ElementCollector(featureId, this.assemblyData);
                generator.setGenerateIncludedFeatures(true);
                generator.setAnalyseChildren(true);
                generator.setSourceFeatureGeneration(false);
                generator.setBinaryFeatureGeneration(true);
                generator.setScriptGeneration(false);
                generator.setPluginPath(this.pluginPath);
                generator.setBuildSiteFactory(this.siteFactory);
                generator.setDevEntries(this.devEntries);
                generator.setCompiledElements(this.getCompiledElements());
                generator.setBuildingOSGi(ElementCollector.isBuildingOSGi());
                generator.includePlatformIndependent(this.isPlatformIndependentIncluded());
                generator.setIgnoreMissingPropertiesFile(this.isIgnoreMissingPropertiesFile());
                try {
                    generator.generate();
                }
                catch (CoreException exception) {
                    if (exception.getStatus().getCode() == 1 && (exception.getStatus().getCode() != 1 || referencedFeatures[i].isOptional())) break block3;
                    throw exception;
                }
            }
            ++i;
        }
    }

    protected void collectElementToAssemble(IFeature featureToCollect) {
        if (this.assemblyData == null) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)featureToCollect);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            this.assemblyData.addFeature(config, this.feature);
        }
    }
}

