/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.FileUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;

public class UpdateAxisWSDDFileTask
extends SimpleCommand {
    private final String LABEL = "TASK_LABEL_UPDATE_AXIS_WSDD";
    private final String DESCRIPTION = "TASK_DESC_UPDATE_AXIS_WSDD";
    private final String DEPLOY_XSL = "deploy.xsl";
    private final String DEPLOY_BAK = "deploy.wsdd.bak";
    private final String CLASSNAME_PARAM = "newClassName";
    private MessageUtils msgUtils_;
    private MessageUtils coreMsgUtils_;
    private JavaWSDLParameter javaWSDLParam_;
    private IProject serviceProject_;
    private String moduleName_;

    public UpdateAxisWSDDFileTask(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setDescription(this.msgUtils_.getMessage("TASK_DESC_UPDATE_AXIS_WSDD"));
        this.setName(this.msgUtils_.getMessage("TASK_LABEL_UPDATE_AXIS_WSDD"));
        this.moduleName_ = moduleName;
    }

    public UpdateAxisWSDDFileTask(JavaWSDLParameter javaWSDLParam) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setDescription(this.msgUtils_.getMessage("TASK_DESC_UPDATE_AXIS_WSDD"));
        this.setName(this.msgUtils_.getMessage("TASK_LABEL_UPDATE_AXIS_WSDD"));
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public org.eclipse.wst.command.internal.provisional.env.core.common.Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        if (this.javaWSDLParam_ == null) {
            status = new SimpleStatus("", this.coreMsgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
            env.getStatusHandler().reportError((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status);
            return status;
        }
        IProject project = this.serviceProject_;
        String projectURL = ServerUtils.getEncodedWebComponentURL((IProject)project, (String)this.moduleName_);
        if (projectURL == null) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_PROJECT_URL", (Object[])new String[]{project.toString()}), 4);
            env.getStatusHandler().reportError((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status);
            return status;
        }
        this.javaWSDLParam_.setProjectURL(projectURL);
        String outputLocation = this.javaWSDLParam_.getJavaOutput();
        if (outputLocation == null) {
            return status;
        }
        this.javaWSDLParam_.getJavaFiles();
        this.javaWSDLParam_.getJavaOutput();
        this.javaWSDLParam_.getOutput();
        String webContentPath = J2EEUtils.getWebContentContainer((IProject)project, (String)this.moduleName_).getLocation().toString();
        try {
            if (this.javaWSDLParam_.getDeploymentFiles() != null && this.javaWSDLParam_.getDeploymentFiles().length > 0) {
                String wsdd_deploy = this.javaWSDLParam_.getDeploymentFiles()[0];
                Path deployPath = new Path(wsdd_deploy);
                String deployBackup = deployPath.removeLastSegments(1).append("deploy.wsdd.bak").toString();
                FileUtil.createTargetFile((String)wsdd_deploy, (String)deployBackup, (boolean)true);
                String deployXSL = this.getPluginFilePath("deploy.xsl").toString();
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(new StreamSource(deployXSL));
                transformer.setParameter("newClassName", this.javaWSDLParam_.getBeanName());
                transformer.transform(new StreamSource(deployBackup), new StreamResult(new FileOutputStream(wsdd_deploy)));
            }
        }
        catch (Exception e) {
            Object[] errorMsgStrings = new String[]{project.toString(), outputLocation.toString(), webContentPath.toString()};
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_UPDATE_AXIS_WSDD", errorMsgStrings), 4, (Throwable)e);
            env.getStatusHandler().reportError((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status);
            return status;
        }
        return status;
    }

    private IPath getPluginFilePath(String pluginfileName) throws CoreException {
        try {
            IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
            IPluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor("org.eclipse.jst.ws.axis.creation.ui");
            URL localURL = Platform.asLocalURL((URL)new URL(pluginDescriptor.getInstallURL(), pluginfileName));
            return new Path(localURL.getFile());
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.ws.axis.creation.ui", 0, this.msgUtils_.getMessage("MSG_PLUGIN_FILE_URL"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.ws.axis.creation.ui", 0, this.msgUtils_.getMessage("MSG_PLUGIN_FILE_URL"), (Throwable)e));
        }
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }
}

