/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaLineBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class JavaMethodBreakpointTypeChange
extends JavaLineBreakpointTypeChange {
    private String fMethodName;
    private String fMethodSignature;
    private boolean fIsEntry;
    private boolean fIsExit;
    private boolean fIsNativeOnly;
    private boolean fIsEnable;

    public JavaMethodBreakpointTypeChange(IJavaMethodBreakpoint methodBreakpoint, Object changedElement, Object argument, int changeType) throws CoreException {
        super((IJavaLineBreakpoint)methodBreakpoint, changedElement, argument, changeType);
        this.fMethodName = methodBreakpoint.getMethodName();
        this.fMethodSignature = methodBreakpoint.getMethodSignature();
        this.fIsEntry = methodBreakpoint.isEntry();
        this.fIsExit = methodBreakpoint.isExit();
        this.fIsNativeOnly = methodBreakpoint.isNativeOnly();
        this.fIsEnable = methodBreakpoint.isEnabled();
    }

    public String getErrorMessageNoMoreExists() {
        return MessageFormat.format(RefactoringMessages.JavaMethodBreakpointTypeChange_0, this.getDeclaringType().getElementName(), this.fMethodName);
    }

    public String getName() {
        return MessageFormat.format(RefactoringMessages.JavaMethodBreakpointTypeChange_1, this.getDeclaringType().getElementName(), this.fMethodName);
    }

    public Change performChange(IType newType, Object undoChangedElement, Object undoArgument, int changeType) throws CoreException {
        ISourceRange range;
        String[] parameterTypes = Signature.getParameterTypes((String)this.fMethodSignature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = parameterTypes[i].replace('/', '.');
            ++i;
        }
        IMethod method = newType.getMethod(this.fMethodName, parameterTypes);
        IMethod[] methods = newType.findMethods(method);
        int lineNumber = this.getLineNumber();
        int start = this.getCharStart();
        int end = this.getCharEnd();
        if (methods.length == 1 && (range = (method = methods[0]).getNameRange()) != null) {
            start = range.getOffset();
            end = start + range.getLength();
            lineNumber = -1;
        }
        Map attributes = this.getAttributes();
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)method);
        IJavaMethodBreakpoint newMethodBreakpoint = JDIDebugModel.createMethodBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)newType), (String)newType.getFullyQualifiedName(), (String)this.fMethodName, (String)this.fMethodSignature, (boolean)this.fIsEntry, (boolean)this.fIsExit, (boolean)this.fIsNativeOnly, (int)lineNumber, (int)start, (int)end, (int)this.getHitCount(), (boolean)true, (Map)attributes);
        newMethodBreakpoint.setEnabled(this.fIsEnable);
        this.getBreakpoint().delete();
        return new JavaMethodBreakpointTypeChange(newMethodBreakpoint, undoChangedElement, undoArgument, changeType);
    }
}

