/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class JavaDebugImages {
    private static URL ICON_BASE_URL = null;
    private static ImageRegistry fgImageRegistry;
    public static final String IMG_OBJS_EXCEPTION = "IMG_OBJS_EXCEPTION";
    public static final String IMG_OBJS_EXCEPTION_DISABLED = "IMG_OBJS_EXCEPTION_DISABLED";
    public static final String IMG_OBJS_ERROR = "IMG_OBJS_ERROR";
    public static final String IMG_OVR_BREAKPOINT_INSTALLED = "IMG_OBJS_BREAKPOINT_INSTALLED";
    public static final String IMG_OVR_BREAKPOINT_INSTALLED_DISABLED = "IMG_OBJS_BREAKPOINT_INSTALLED_DISABLED";
    public static final String IMG_OBJS_LOCAL_VARIABLE = "IMG_OBJS_LOCAL_VARIABLE";
    public static final String IMG_OVR_METHOD_BREAKPOINT_ENTRY = "IMG_OBJS_METHOD_BREAKPOINT_ENTRY";
    public static final String IMG_OVR_METHOD_BREAKPOINT_ENTRY_DISABLED = "IMG_OBJS_METHOD_BREAKPOINT_ENTRY_DISABLED";
    public static final String IMG_OVR_METHOD_BREAKPOINT_EXIT = "IMG_OBJS_METHOD_BREAKPOINT_EXIT";
    public static final String IMG_OVR_METHOD_BREAKPOINT_EXIT_DISABLED = "IMG_OBJS_METHOD_BREAKPOINT_EXIT_DISABLED";
    public static final String IMG_OVR_CONDITIONAL_BREAKPOINT = "IMG_OBJS_CONDITIONAL_BREAKPOINT";
    public static final String IMG_OVR_CONDITIONAL_BREAKPOINT_DISABLED = "IMG_OBJS_CONDITIONAL_BREAKPOINT_DISABLED";
    public static final String IMG_OVR_SCOPED_BREAKPOINT = "IMG_OBJS_SCOPED_BREAKPOINT";
    public static final String IMG_OVR_SCOPED_BREAKPOINT_DISABLED = "IMG_OBJS_SCOPED_BREAKPOINT_DISABLED";
    public static final String IMG_OVR_UNCAUGHT_BREAKPOINT = "IMG_OBJS_UNCAUGHT_BREAKPOINT";
    public static final String IMG_OVR_UNCAUGHT_BREAKPOINT_DISABLED = "IMG_OBJS_UNCAUGHT_BREAKPOINT_DISABLED";
    public static final String IMG_OVR_CAUGHT_BREAKPOINT = "IMG_OBJS_CAUGHT_BREAKPOINT";
    public static final String IMG_OVR_CAUGHT_BREAKPOINT_DISABLED = "IMG_OBJS_CAUGHT_BREAKPOINT_DISABLED";
    public static final String IMG_OBJS_SNIPPET_EVALUATING = "IMG_OBJS_SNIPPET_EVALUATING";
    public static final String IMG_VIEW_ARGUMENTS_TAB = "IMG_VIEW_ARGUMENTS_TAB";
    public static final String IMG_OBJS_MONITOR = "IMG_OBJS_MONITOR";
    public static final String IMG_OBJS_CONTENDED_MONITOR = "IMG_OBJS_CONTENDED_MONITOR";
    public static final String IMG_OBJS_OWNED_MONITOR = "IMG_OBJS_OWNED_MONITOR";
    public static final String IMG_OVR_OWNED = "IMG_OVR_OWNED";
    public static final String IMG_OVR_OWNS_MONITOR = "IMG_OVR_OWNS_MONITOR";
    public static final String IMG_OVR_IN_CONTENTION = "IMG_OVR_IN_CONTENTION";
    public static final String IMG_OVR_IN_CONTENTION_FOR_MONITOR = "IMG_OVR_IN_CONTENTION_FOR_MONITOR";
    public static final String IMG_OVR_IN_DEADLOCK = "IMG_OVR_IN_DEADLOCK";
    public static final String IMG_OBJS_EXCEPTION_BRKPT_TYPE = "IMG_OBJS_EXCEPTION_BRKPT_TYPE";
    public static final String IMG_OBJS_LINE_BRKPT_TYPE = "IMG_OBJS_LINE_BRKPT_TYPE";
    public static final String IMG_OBJS_CLASSLOAD_BRKPT_TYPE = "IMG_OBJS_CLASSLOAD_BRKPT_TYPE";
    public static final String IMG_OBJS_WATCHPOINT_TYPE = "IMG_OBJS_WATCHPOINT_TYPE";
    public static final String IMG_OBJS_JSP_BRKPT_TYPE = "IMG_OBJS_JSP_BRKPT_TYPE";
    public static final String IMG_OBJS_METHOD_BRKPT_TYPE = "IMG_OBJS_METHOD_BRKPT_TYPE";
    public static final String IMG_OBJS_CLASSPATH = "IMG_OBJS_CLASSPATH";
    public static final String IMG_OVR_OUT_OF_SYNCH = "IMG_OVR_OUT_OF_SYNCH";
    public static final String IMG_OVR_MAY_BE_OUT_OF_SYNCH = "IMG_OVR_MAY_BE_OUT_OF_SYNCH";
    public static final String IMG_OVR_SYNCHRONIZED = "IMG_OVR_SYNCHRONIZED";
    public static final String IMG_WIZBAN_NEWSCRAPPAGE = "IMG_WIZBAN_NEWSCRAPPAGE";
    public static final String IMG_WIZBAN_LIBRARY = "IMG_WIZBAN_LIBRARY";
    public static final String IMG_TOOL_TERMSNIPPET = "IMG_TOOL_TERMSNIPPET";
    public static final String IMG_TOOL_TERMSNIPPET_HOVER = "IMG_TOOL_TERMSNIPPET_HOVER";
    public static final String IMG_TOOL_TERMSNIPPET_DISABLED = "IMG_TOOL_TERMSNIPPET_DISABLED";
    public static final String IMG_OBJ_JAVA_INSPECT_EXPRESSION = "IMG_OBJ_JAVA_INSPECT_EXPRESSION";
    private static final String T_OBJ = "obj16/";
    private static final String T_OVR = "ovr16/";
    private static final String T_WIZBAN = "wizban/";
    private static final String T_EVIEW = "eview16/";
    private static final String T_DLCL = "dtool16/";
    private static final String T_ELCL = "etool16/";

    static {
        String pathSuffix = "icons/full/";
        ICON_BASE_URL = JDIDebugUIPlugin.getDefault().getBundle().getEntry(pathSuffix);
        fgImageRegistry = null;
    }

    public static Image get(String key) {
        return JavaDebugImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return JavaDebugImages.getImageRegistry().getDescriptor(key);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            JavaDebugImages.initializeImageRegistry();
        }
        return fgImageRegistry;
    }

    private static void initializeImageRegistry() {
        fgImageRegistry = new ImageRegistry(JDIDebugUIPlugin.getStandardDisplay());
        JavaDebugImages.declareImages();
    }

    private static void declareImages() {
        JavaDebugImages.declareRegistryImage(IMG_OBJS_EXCEPTION, "obj16/jexception_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_EXCEPTION_DISABLED, "obj16/jexceptiond_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_BREAKPOINT_INSTALLED, "ovr16/installed_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_BREAKPOINT_INSTALLED_DISABLED, "ovr16/installed_ovr_disabled.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_LOCAL_VARIABLE, "obj16/localvariable_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_METHOD_BREAKPOINT_ENTRY, "ovr16/entry_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_METHOD_BREAKPOINT_ENTRY_DISABLED, "ovr16/entry_ovr_disabled.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_METHOD_BREAKPOINT_EXIT, "ovr16/exit_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_METHOD_BREAKPOINT_EXIT_DISABLED, "ovr16/exit_ovr_disabled.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_CONDITIONAL_BREAKPOINT, "ovr16/conditional_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_CONDITIONAL_BREAKPOINT_DISABLED, "ovr16/conditional_ovr_disabled.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_SCOPED_BREAKPOINT, "ovr16/scoped_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_SCOPED_BREAKPOINT_DISABLED, "ovr16/scoped_ovr_disabled.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_UNCAUGHT_BREAKPOINT, "ovr16/uncaught_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_UNCAUGHT_BREAKPOINT_DISABLED, "ovr16/uncaught_ovr_disabled.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_CAUGHT_BREAKPOINT, "ovr16/caught_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_CAUGHT_BREAKPOINT_DISABLED, "ovr16/caught_ovr_disabled.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_ERROR, "obj16/jrtexception_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_SNIPPET_EVALUATING, "obj16/jsbook_run_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_VIEW_ARGUMENTS_TAB, "eview16/variable_tab.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_OUT_OF_SYNCH, "ovr16/error_co.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_MAY_BE_OUT_OF_SYNCH, "ovr16/warning_co.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_SYNCHRONIZED, "ovr16/sync_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_MONITOR, "obj16/monitor_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_OWNED, "ovr16/owned_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_OWNS_MONITOR, "ovr16/ownsmonitor_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_IN_CONTENTION, "ovr16/contention_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_IN_CONTENTION_FOR_MONITOR, "ovr16/contentionformonitor_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OVR_IN_DEADLOCK, "ovr16/deadlock_ovr.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_CONTENDED_MONITOR, "obj16/contended_monitor_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_OWNED_MONITOR, "obj16/owned_monitor_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_WIZBAN_NEWSCRAPPAGE, "wizban/newsbook_wiz.gif");
        JavaDebugImages.declareRegistryImage(IMG_WIZBAN_LIBRARY, "wizban/library_wiz.gif");
        JavaDebugImages.declareRegistryImage(IMG_TOOL_TERMSNIPPET, "etool16/term_sbook.gif");
        JavaDebugImages.declareRegistryImage(IMG_TOOL_TERMSNIPPET_HOVER, "etool16/term_sbook.gif");
        JavaDebugImages.declareRegistryImage(IMG_TOOL_TERMSNIPPET_DISABLED, "dtool16/term_sbook.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJ_JAVA_INSPECT_EXPRESSION, "obj16/insp_sbook.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_CLASSPATH, "obj16/classpath_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_EXCEPTION_BRKPT_TYPE, "obj16/jexcept_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_LINE_BRKPT_TYPE, "obj16/jline_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_CLASSLOAD_BRKPT_TYPE, "obj16/jload_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_METHOD_BRKPT_TYPE, "obj16/jmeth_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_JSP_BRKPT_TYPE, "obj16/jspbrkpt_obj.gif");
        JavaDebugImages.declareRegistryImage(IMG_OBJS_WATCHPOINT_TYPE, "obj16/jwatch_obj.gif");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)JavaDebugImages.makeIconFileURL(path));
        }
        catch (MalformedURLException me) {
            JDIDebugUIPlugin.log(me);
        }
        fgImageRegistry.put(key, desc);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }
}

