/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructures;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.EditLogicalStructureDialog;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JavaLogicalStructuresPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionChangedListener,
Listener {
    private TableViewer fLogicalStructuresViewer;
    private Button fAddLogicalStructureButton;
    private Button fEditLogicalStructureButton;
    private Button fRemoveLogicalStructureButton;
    private LogicalStructuresListViewerContentProvider fLogicalStructuresContentProvider;
    protected static String[] fTableColumnProperties = new String[]{"type", "showAs"};
    protected String[] fTableColumnHeaders = new String[]{DebugUIMessages.JavaLogicalStructuresPreferencePage_9, DebugUIMessages.JavaLogicalStructuresPreferencePage_10};
    protected ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(70), new ColumnWeightData(30)};
    private SourceViewer fCodeViewer;

    public JavaLogicalStructuresPreferencePage() {
        super(DebugUIMessages.JavaLogicalStructuresPreferencePage_0);
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.JavaLogicalStructuresPreferencePage_11);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFont(parent.getFont());
        this.createTable(container);
        this.createTableButtons(container);
        this.createSourceViewer(container);
        return container;
    }

    public void createSourceViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(DebugUIMessages.JavaLogicalStructuresPreferencePage_12);
        label.setFont(parent.getFont());
        this.fCodeViewer = new SourceViewer(parent, null, 2816);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this.fCodeViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(tools.getColorManager(), JavaPlugin.getDefault().getPreferenceStore(), null, null));
        this.fCodeViewer.setEditable(false);
        this.fCodeViewer.setDocument((IDocument)document);
        this.fCodeViewer.getTextWidget().setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.fCodeViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fCodeViewer.getControl();
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)gd);
    }

    private void createTableButtons(Composite container) {
        Font font = container.getFont();
        Composite buttonContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        GridData gd = new GridData(2);
        buttonContainer.setLayoutData((Object)gd);
        buttonContainer.setFont(font);
        this.fAddLogicalStructureButton = new Button(buttonContainer, 8);
        this.fAddLogicalStructureButton.setText(DebugUIMessages.JavaLogicalStructuresPreferencePage_2);
        this.fAddLogicalStructureButton.setToolTipText(DebugUIMessages.JavaLogicalStructuresPreferencePage_3);
        this.fAddLogicalStructureButton.setFont(font);
        this.setButtonLayoutData(this.fAddLogicalStructureButton);
        this.fAddLogicalStructureButton.addListener(13, (Listener)this);
        this.fEditLogicalStructureButton = new Button(buttonContainer, 8);
        this.fEditLogicalStructureButton.setText(DebugUIMessages.JavaLogicalStructuresPreferencePage_4);
        this.fEditLogicalStructureButton.setToolTipText(DebugUIMessages.JavaLogicalStructuresPreferencePage_5);
        this.fEditLogicalStructureButton.setFont(font);
        this.setButtonLayoutData(this.fEditLogicalStructureButton);
        this.fEditLogicalStructureButton.addListener(13, (Listener)this);
        this.fRemoveLogicalStructureButton = new Button(buttonContainer, 8);
        this.fRemoveLogicalStructureButton.setText(DebugUIMessages.JavaLogicalStructuresPreferencePage_6);
        this.fRemoveLogicalStructureButton.setToolTipText(DebugUIMessages.JavaLogicalStructuresPreferencePage_7);
        this.fRemoveLogicalStructureButton.setFont(font);
        this.setButtonLayoutData(this.fRemoveLogicalStructureButton);
        this.fRemoveLogicalStructureButton.addListener(13, (Listener)this);
        this.selectionChanged((IStructuredSelection)this.fLogicalStructuresViewer.getSelection());
    }

    private void createTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(DebugUIMessages.JavaLogicalStructuresPreferencePage_1);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(parent.getFont());
        this.fLogicalStructuresViewer = new TableViewer(parent, 68354);
        Table table = (Table)this.fLogicalStructuresViewer.getControl();
        gd = new GridData(768);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gd);
        table.setFont(parent.getFont());
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fLogicalStructuresViewer.setColumnProperties(fTableColumnProperties);
        int i = 0;
        while (i < this.fTableColumnHeaders.length) {
            tableLayout.addColumnData(this.fTableColumnLayouts[i]);
            TableColumn column = new TableColumn(table, 0, i);
            column.setResizable(this.fTableColumnLayouts[i].resizable);
            column.setText(this.fTableColumnHeaders[i]);
            ++i;
        }
        this.fLogicalStructuresContentProvider = new LogicalStructuresListViewerContentProvider();
        this.fLogicalStructuresViewer.setContentProvider((IContentProvider)this.fLogicalStructuresContentProvider);
        this.fLogicalStructuresViewer.setLabelProvider((IBaseLabelProvider)new LogicalStructuresListViewerLabelProvider());
        this.fLogicalStructuresViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLogicalStructuresViewer.setInput((Object)this);
        this.fLogicalStructuresViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)JavaLogicalStructuresPreferencePage.this.fLogicalStructuresViewer.getSelection();
                if (selection.size() == 1 && !((JavaLogicalStructure)selection.getFirstElement()).isContributed()) {
                    JavaLogicalStructuresPreferencePage.this.editLogicalStructure();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && JavaLogicalStructuresPreferencePage.this.fRemoveLogicalStructureButton.isEnabled()) {
                    JavaLogicalStructuresPreferencePage.this.removeLogicalStrutures();
                }
            }
        });
        this.fLogicalStructuresViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer iViewer, Object e1, Object e2) {
                String type2;
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                String type1 = ((JavaLogicalStructure)e1).getQualifiedTypeName();
                int index = type1.lastIndexOf(46) + 1;
                if (index > 0) {
                    type1 = type1.substring(index);
                }
                if ((index = (type2 = ((JavaLogicalStructure)e2).getQualifiedTypeName()).lastIndexOf(46) + 1) > 0) {
                    type2 = type2.substring(index);
                }
                return type1.compareToIgnoreCase(type2);
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        }
    }

    private void selectionChanged(IStructuredSelection structuredSelection) {
        int size = structuredSelection.size();
        StringBuffer buffer = new StringBuffer();
        if (size == 0) {
            this.fEditLogicalStructureButton.setEnabled(false);
            this.fRemoveLogicalStructureButton.setEnabled(false);
        } else {
            JavaLogicalStructure structure = (JavaLogicalStructure)structuredSelection.getFirstElement();
            this.fEditLogicalStructureButton.setEnabled(size == 1 && !structure.isContributed());
            boolean removeEnabled = true;
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                if (!((JavaLogicalStructure)iter.next()).isContributed()) continue;
                removeEnabled = false;
            }
            this.fRemoveLogicalStructureButton.setEnabled(removeEnabled);
            String snippet = structure.getValue();
            if (snippet != null) {
                buffer.append(snippet);
            } else {
                String[][] variables = structure.getVariables();
                int i = 0;
                while (i < variables.length) {
                    buffer.append(variables[i][0]);
                    buffer.append(" = ");
                    buffer.append(variables[i][1]);
                    if (buffer.charAt(buffer.length() - 1) != '\n') {
                        buffer.append('\n');
                    }
                    ++i;
                }
            }
        }
        if (this.fCodeViewer != null) {
            this.fCodeViewer.getDocument().set(buffer.toString());
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.fAddLogicalStructureButton) {
            this.addLogicalStructure();
        } else if (source == this.fEditLogicalStructureButton) {
            this.editLogicalStructure();
        } else if (source == this.fRemoveLogicalStructureButton) {
            this.removeLogicalStrutures();
        }
    }

    protected void addLogicalStructure() {
        JavaLogicalStructure logicalStructure = new JavaLogicalStructure("", true, "", "", new String[0][]);
        if (new EditLogicalStructureDialog(this.fLogicalStructuresViewer.getControl().getShell(), logicalStructure).open() == 0) {
            this.fLogicalStructuresContentProvider.add(logicalStructure);
            this.fLogicalStructuresViewer.refresh();
            this.fLogicalStructuresViewer.setSelection((ISelection)new StructuredSelection((Object)logicalStructure));
        }
    }

    protected void editLogicalStructure() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.fLogicalStructuresViewer.getSelection();
        if (structuredSelection.size() == 1) {
            JavaLogicalStructure logicalStructure = (JavaLogicalStructure)structuredSelection.getFirstElement();
            new EditLogicalStructureDialog(this.fLogicalStructuresViewer.getControl().getShell(), logicalStructure).open();
            this.fLogicalStructuresContentProvider.refresh(logicalStructure);
            this.fLogicalStructuresViewer.refresh();
        }
    }

    protected void removeLogicalStrutures() {
        IStructuredSelection selection = (IStructuredSelection)this.fLogicalStructuresViewer.getSelection();
        if (selection.size() > 0) {
            List selectedElements = selection.toList();
            Object[] elements = this.fLogicalStructuresContentProvider.getElements(null);
            Object newSelectedElement = null;
            int i = 0;
            while (i < elements.length) {
                if (selectedElements.contains(elements[i])) break;
                newSelectedElement = elements[i];
                ++i;
            }
            this.fLogicalStructuresContentProvider.remove(((IStructuredSelection)this.fLogicalStructuresViewer.getSelection()).toList());
            this.fLogicalStructuresViewer.refresh();
            if (newSelectedElement == null) {
                Object[] newElements = this.fLogicalStructuresContentProvider.getElements(null);
                if (newElements.length > 0) {
                    this.fLogicalStructuresViewer.setSelection((ISelection)new StructuredSelection(newElements[0]));
                }
            } else {
                this.fLogicalStructuresViewer.setSelection((ISelection)new StructuredSelection(newSelectedElement));
            }
        }
    }

    public boolean performOk() {
        this.fLogicalStructuresContentProvider.saveUserDefinedJavaLogicalStructures();
        return super.performOk();
    }

    public class LogicalStructuresListViewerLabelProvider
    extends LabelProvider
    implements IColorProvider,
    ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            JavaLogicalStructure logicalStructure = (JavaLogicalStructure)element;
            StringBuffer buffer = new StringBuffer();
            if (columnIndex == 0) {
                String qualifiedName = logicalStructure.getQualifiedTypeName();
                int index = qualifiedName.lastIndexOf(46) + 1;
                String simpleName = qualifiedName.substring(index);
                buffer.append(simpleName);
                if (index > 0) {
                    buffer.append(" (").append(logicalStructure.getQualifiedTypeName()).append(')');
                }
            } else if (columnIndex == 1) {
                buffer.append(logicalStructure.getDescription());
                String pluginId = logicalStructure.getContributingPluginId();
                if (pluginId != null) {
                    buffer.append(MessageFormat.format(DebugUIMessages.JavaLogicalStructuresPreferencePage_8, pluginId));
                }
            }
            return buffer.toString();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            if (element instanceof JavaLogicalStructure && ((JavaLogicalStructure)element).isContributed()) {
                return Display.getCurrent().getSystemColor(29);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public class LogicalStructuresListViewerContentProvider
    implements IStructuredContentProvider {
        private List fLogicalStructures = new ArrayList();

        LogicalStructuresListViewerContentProvider() {
            JavaLogicalStructure[] logicalStructures = JavaLogicalStructures.getJavaLogicalStructures();
            int i = 0;
            while (i < logicalStructures.length) {
                this.add(logicalStructures[i]);
                ++i;
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.fLogicalStructures.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void add(JavaLogicalStructure logicalStructure) {
            int i = 0;
            int length = this.fLogicalStructures.size();
            while (i < length) {
                if (!this.greaterThan(logicalStructure, (JavaLogicalStructure)this.fLogicalStructures.get(i))) {
                    this.fLogicalStructures.add(i, logicalStructure);
                    return;
                }
                ++i;
            }
            this.fLogicalStructures.add(logicalStructure);
        }

        private boolean greaterThan(JavaLogicalStructure logicalStructure1, JavaLogicalStructure logicalStructure2) {
            int res = logicalStructure1.getQualifiedTypeName().compareToIgnoreCase(logicalStructure2.getQualifiedTypeName());
            if (res != 0) {
                return res > 0;
            }
            res = logicalStructure1.getDescription().compareToIgnoreCase(logicalStructure2.getDescription());
            if (res != 0) {
                return res > 0;
            }
            return logicalStructure1.hashCode() > logicalStructure2.hashCode();
        }

        public void remove(List list) {
            this.fLogicalStructures.removeAll(list);
        }

        public void refresh(JavaLogicalStructure logicalStructure) {
            this.fLogicalStructures.remove(logicalStructure);
            this.add(logicalStructure);
        }

        public void saveUserDefinedJavaLogicalStructures() {
            ArrayList<JavaLogicalStructure> logicalStructures = new ArrayList<JavaLogicalStructure>();
            Iterator iter = this.fLogicalStructures.iterator();
            while (iter.hasNext()) {
                JavaLogicalStructure logicalStructure = (JavaLogicalStructure)iter.next();
                if (logicalStructure.isContributed()) continue;
                logicalStructures.add(logicalStructure);
            }
            JavaLogicalStructures.setUserDefinedJavaLogicalStructures((JavaLogicalStructure[])logicalStructures.toArray(new JavaLogicalStructure[logicalStructures.size()]));
        }
    }
}

