/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileOperation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GenerateDiffFileWizard
extends Wizard {
    private LocationPage locationPage;
    private OptionsPage optionsPage;
    private final IResource resource;
    private final DefaultValuesStore defaultValuesStore;

    public GenerateDiffFileWizard(IResource resource) {
        this.resource = resource;
        this.setWindowTitle(CVSUIMessages.GenerateCVSDiff_title);
        this.initializeDefaultPageImageDescriptor();
        this.defaultValuesStore = new DefaultValuesStore();
    }

    public void addPages() {
        String pageTitle = CVSUIMessages.GenerateCVSDiff_pageTitle;
        String pageDescription = CVSUIMessages.GenerateCVSDiff_pageDescription;
        this.locationPage = new LocationPage(pageTitle, pageTitle, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"), this.defaultValuesStore);
        this.locationPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.locationPage);
        pageTitle = CVSUIMessages.Advanced_options_19;
        pageDescription = CVSUIMessages.Configure_the_options_used_for_the_CVS_diff_command_20;
        this.optionsPage = new OptionsPage(pageTitle, pageTitle, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"));
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.optionsPage);
    }

    protected void initializeDefaultPageImageDescriptor() {
        try {
            URL installURL = CVSUIPlugin.getPlugin().getBundle().getEntry("/");
            URL url = new URL(installURL, "icons/full/wizards/newconnect_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        File file;
        int location = this.locationPage.getSelectedLocation();
        File file2 = file = location != 1 ? this.locationPage.getFile() : null;
        if (file != null && !this.validateFile(file)) {
            return false;
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new GenerateDiffFileOperation(this.resource, file, this.optionsPage.getOptions(), this.getShell()));
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (InvocationTargetException e2) {
            CVSUIPlugin.openError(this.getShell(), null, null, e2);
            return false;
        }
        switch (location) {
            case 3: {
                this.defaultValuesStore.storeRadioSelection(3);
                IResource workspaceResource = this.locationPage.getResource();
                this.defaultValuesStore.storeWorkspacePath(workspaceResource.getParent().getFullPath().toString());
                this.defaultValuesStore.storeWorkspaceFilename(workspaceResource.getName());
                try {
                    workspaceResource.getParent().refreshLocal(1, null);
                    break;
                }
                catch (CoreException e) {
                    CVSUIPlugin.openError(this.getShell(), CVSUIMessages.GenerateCVSDiff_error, null, e);
                    return false;
                }
            }
            case 2: {
                this.defaultValuesStore.storeFilesystemPath(file.getPath());
                this.defaultValuesStore.storeRadioSelection(2);
                break;
            }
            case 1: {
                this.defaultValuesStore.storeRadioSelection(1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean validateFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.canWrite()) {
            String title = CVSUIMessages.GenerateCVSDiff_1;
            String msg = CVSUIMessages.GenerateCVSDiff_2;
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return false;
        }
        String title = CVSUIMessages.GenerateCVSDiff_overwriteTitle;
        String msg = CVSUIMessages.GenerateCVSDiff_overwriteMsg;
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    private class LocationPage
    extends WizardPage {
        public static final int CLIPBOARD = 1;
        public static final int FILESYSTEM = 2;
        public static final int WORKSPACE = 3;
        private Button cpRadio;
        private Button fsRadio;
        protected Text fsPathText;
        private Button fsBrowseButton;
        private Button wsRadio;
        protected TreeViewer wsTreeViewer;
        private Text wsFilenameText;
        protected boolean pageValid;
        protected IContainer wsSelectedContainer;
        protected int selectedLocation;
        private final DefaultValuesStore store;

        LocationPage(String pageName, String title, ImageDescriptor image, DefaultValuesStore store) {
            super(pageName, title, image);
            this.setPageComplete(false);
            this.store = store;
        }

        protected boolean validatePage() {
            switch (this.selectedLocation) {
                case 3: {
                    this.pageValid = this.validateWorkspaceLocation();
                    break;
                }
                case 2: {
                    this.pageValid = this.validateFilesystemLocation();
                    break;
                }
                case 1: {
                    this.pageValid = true;
                }
            }
            if (this.pageValid) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
            this.setPageComplete(this.pageValid);
            return this.pageValid;
        }

        private boolean validateFilesystemLocation() {
            String pathString = this.fsPathText.getText().trim();
            if (pathString.length() == 0 || !new Path("").isValidPath(pathString)) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_0);
                return false;
            }
            File file = new File(pathString);
            if (!file.isAbsolute()) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_0);
                return false;
            }
            if (file.isDirectory()) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_2);
                return false;
            }
            if (pathString.endsWith("/") || pathString.endsWith("\\")) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_3);
                return false;
            }
            File parent = file.getParentFile();
            if (!parent.exists() || !parent.isDirectory()) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_3);
                return false;
            }
            return true;
        }

        private boolean validateWorkspaceLocation() {
            if (this.wsSelectedContainer == null) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_4);
                return false;
            }
            String filename = this.wsFilenameText.getText().trim();
            if (!new Path("").isValidSegment(filename)) {
                this.setErrorMessage(CVSUIMessages.GenerateDiffFileWizard_5);
                return false;
            }
            return true;
        }

        public File getFile() {
            if (this.pageValid && this.selectedLocation == 2) {
                return new File(this.fsPathText.getText().trim());
            }
            if (this.pageValid && this.selectedLocation == 3) {
                String filename = this.wsFilenameText.getText().trim();
                IFile file = this.wsSelectedContainer.getFile((IPath)new Path(filename));
                return file.getLocation().toFile();
            }
            return null;
        }

        public IResource getResource() {
            if (this.pageValid && this.selectedLocation == 3) {
                String filename = this.wsFilenameText.getText().trim();
                return this.wsSelectedContainer.getFile((IPath)new Path(null, filename));
            }
            return null;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.setControl((Control)composite);
            this.initializeDialogUnits((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.patch_selection_page_context");
            this.setupClipboardControls(composite);
            this.setupFilesystemControls(composite);
            this.setupWorkspaceControls(composite);
            Dialog.applyDialogFont((Control)parent);
            this.initializeDefaultValues();
            if (!this.validatePage()) {
                this.store.storeRadioSelection(1);
                this.initializeDefaultValues();
                this.validatePage();
            }
            this.pageValid = true;
            this.updateEnablements();
            this.setupListeners();
        }

        private void setupWorkspaceControls(Composite composite) {
            this.wsRadio = new Button(composite, 16);
            this.wsRadio.setText(CVSUIMessages.Save_In_Workspace_7);
            new Label(composite, 16384).setText(CVSUIMessages.Select_a_folder_then_type_in_the_file_name__8);
            this.wsTreeViewer = new TreeViewer(composite, 2048);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 0;
            gd.heightHint = 0;
            this.wsTreeViewer.getTree().setLayoutData((Object)gd);
            ContainerContentProvider cp = new ContainerContentProvider();
            cp.showClosedProjects(false);
            this.wsTreeViewer.setContentProvider((IContentProvider)cp);
            this.wsTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.wsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
            Composite group = new Composite(composite, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            Label label = new Label(group, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(CVSUIMessages.Fi_le_name__9);
            this.wsFilenameText = new Text(group, 2048);
            this.wsFilenameText.setLayoutData((Object)new GridData(4, 128, true, false));
        }

        private void setupFilesystemControls(Composite composite) {
            this.fsRadio = new Button(composite, 16);
            this.fsRadio.setText(CVSUIMessages.Save_In_File_System_3);
            Composite nameGroup = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            nameGroup.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, false, false);
            nameGroup.setLayoutData((Object)data);
            this.fsPathText = new Text(nameGroup, 2048);
            GridData gd = new GridData(768);
            this.fsPathText.setLayoutData((Object)gd);
            this.fsBrowseButton = new Button(nameGroup, 0);
            this.fsBrowseButton.setText(CVSUIMessages.Browse____4);
        }

        private void setupClipboardControls(Composite composite) {
            this.cpRadio = new Button(composite, 16);
            this.cpRadio.setText(CVSUIMessages.Save_To_Clipboard_2);
        }

        private void initializeDefaultValues() {
            this.selectedLocation = this.store.getRadioSelection();
            this.wsSelectedContainer = this.store.getWorkspaceSelection();
            this.cpRadio.setSelection(this.selectedLocation == 1);
            this.fsRadio.setSelection(this.selectedLocation == 2);
            this.wsRadio.setSelection(this.selectedLocation == 3);
            this.fsPathText.setText(this.store.getFilesystemPath());
            this.wsFilenameText.setText(this.store.getWorkspaceFilename());
            if (this.wsSelectedContainer != null) {
                StructuredSelection selection = new StructuredSelection((Object)this.wsSelectedContainer);
                this.wsTreeViewer.setSelection((ISelection)selection, true);
            }
        }

        private void setupListeners() {
            this.cpRadio.addListener(13, new Listener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void handleEvent(Event event) {
                    this.this$1.selectedLocation = 1;
                    this.this$1.validatePage();
                    this.this$1.updateEnablements();
                }
            });
            this.fsRadio.addListener(13, new Listener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void handleEvent(Event event) {
                    this.this$1.selectedLocation = 2;
                    this.this$1.validatePage();
                    this.this$1.updateEnablements();
                }
            });
            this.wsRadio.addListener(13, new Listener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void handleEvent(Event event) {
                    this.this$1.selectedLocation = 3;
                    this.this$1.validatePage();
                    this.this$1.updateEnablements();
                }
            });
            this.fsPathText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validatePage();
                }
            });
            this.fsBrowseButton.addListener(13, new Listener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(this.this$1.getShell(), 40960);
                    if (this.this$1.pageValid) {
                        File file = new File(this.this$1.fsPathText.getText());
                        dialog.setFilterPath(file.getParent());
                    }
                    dialog.setText(CVSUIMessages.Save_Patch_As_5);
                    dialog.setFileName(CVSUIMessages.patch_txt_6);
                    String path = dialog.open();
                    if (path != null) {
                        this.this$1.fsPathText.setText(new Path(path).toOSString());
                    }
                }
            });
            this.wsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    this.this$1.wsSelectedContainer = (IContainer)s.getFirstElement();
                    this.this$1.validatePage();
                }
            });
            this.wsTreeViewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void doubleClick(DoubleClickEvent event) {
                    ISelection s = event.getSelection();
                    if (s instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)s).getFirstElement();
                        if (this.this$1.wsTreeViewer.getExpandedState(item)) {
                            this.this$1.wsTreeViewer.collapseToLevel(item, 1);
                        } else {
                            this.this$1.wsTreeViewer.expandToLevel(item, 1);
                        }
                    }
                }
            });
            this.wsFilenameText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ LocationPage this$1;
                {
                    this.this$1 = locationPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validatePage();
                }
            });
        }

        protected void updateEnablements() {
            this.fsBrowseButton.setEnabled(this.selectedLocation == 2);
            this.fsPathText.setEnabled(this.selectedLocation == 2);
            this.wsTreeViewer.getTree().setEnabled(this.selectedLocation == 3);
            this.wsFilenameText.setEnabled(this.selectedLocation == 3);
        }

        public int getSelectedLocation() {
            return this.selectedLocation;
        }
    }

    private class OptionsPage
    extends WizardPage {
        private Button recurseOption;
        private Button contextDiffOption;
        private Button unifiedDiffOption;
        private Button regularDiffOption;
        private Button includeNewFilesOptions;

        protected OptionsPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData());
            this.setControl((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.patch_options_page_context");
            this.recurseOption = new Button(composite, 32);
            this.recurseOption.setText(CVSUIMessages.Do_not_recurse_into_sub_folders_10);
            this.recurseOption.setSelection(true);
            this.includeNewFilesOptions = new Button(composite, 32);
            this.includeNewFilesOptions.setText(CVSUIMessages.Do_not_include_new_files_in_patch_11);
            this.includeNewFilesOptions.setSelection(true);
            Group diffTypeGroup = new Group(composite, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            diffTypeGroup.setLayout((Layout)layout);
            GridData data = new GridData(768);
            diffTypeGroup.setLayoutData((Object)data);
            diffTypeGroup.setText(CVSUIMessages.Diff_output_format_12);
            this.unifiedDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.unifiedDiffOption.setText(CVSUIMessages.Unified__format_required_by_Compare_With_Patch_feature__13);
            this.unifiedDiffOption.setSelection(true);
            this.contextDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.contextDiffOption.setText(CVSUIMessages.Context_14);
            this.regularDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.regularDiffOption.setText(CVSUIMessages.Standard_15);
            Dialog.applyDialogFont((Control)parent);
        }

        public Command.LocalOption[] getOptions() {
            ArrayList<Command.LocalOption> options = new ArrayList<Command.LocalOption>(5);
            if (this.includeNewFilesOptions.getSelection()) {
                options.add(Diff.INCLUDE_NEWFILES);
            }
            if (!this.recurseOption.getSelection()) {
                options.add(Command.DO_NOT_RECURSE);
            }
            if (this.unifiedDiffOption.getSelection()) {
                options.add(Diff.UNIFIED_FORMAT);
            } else if (this.contextDiffOption.getSelection()) {
                options.add(Diff.CONTEXT_FORMAT);
            }
            return options.toArray(new Command.LocalOption[options.size()]);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.recurseOption.setFocus();
            }
        }
    }

    private final class DefaultValuesStore {
        private static final String PREF_LAST_SELECTION = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.PatchFileSelectionPage.selection";
        private static final String PREF_LAST_FS_PATH = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.PatchFileSelectionPage.fs.path";
        private static final String PREF_LAST_WS_FILENAME = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.PatchFileSelectionPage.ws.filename";
        private static final String PREF_LAST_WS_PATH = "org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard.PatchFileSelectionPage.ws.path";
        private final IDialogSettings dialogSettings = CVSUIPlugin.getPlugin().getDialogSettings();

        public int getRadioSelection() {
            int value = 1;
            try {
                value = this.dialogSettings.getInt(PREF_LAST_SELECTION);
            }
            catch (NumberFormatException numberFormatException) {}
            switch (value) {
                case 1: 
                case 2: 
                case 3: {
                    return value;
                }
            }
            return 1;
        }

        public String getFilesystemPath() {
            String path = this.dialogSettings.get(PREF_LAST_FS_PATH);
            return path != null ? path : "";
        }

        public String getWorkspaceFilename() {
            String filename = this.dialogSettings.get(PREF_LAST_WS_FILENAME);
            return filename != null ? filename : "";
        }

        public IContainer getWorkspaceSelection() {
            String value = this.dialogSettings.get(PREF_LAST_WS_PATH);
            if (value != null) {
                Path path = new Path(value);
                IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (container instanceof IContainer) {
                    return (IContainer)container;
                }
            }
            return null;
        }

        public void storeRadioSelection(int defaultSelection) {
            this.dialogSettings.put(PREF_LAST_SELECTION, defaultSelection);
        }

        public void storeFilesystemPath(String path) {
            this.dialogSettings.put(PREF_LAST_FS_PATH, path);
        }

        public void storeWorkspacePath(String path) {
            this.dialogSettings.put(PREF_LAST_WS_PATH, path);
        }

        public void storeWorkspaceFilename(String filename) {
            this.dialogSettings.put(PREF_LAST_WS_FILENAME, filename);
        }
    }
}

