/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.filter;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.rdb.connection.internal.ui.filter.FilterWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ISchemaNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ISequenceNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IStoredProcedureNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ITableNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IUDFNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IUDTNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IViewNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;

public class FilterWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private FilterWizardPage page;

    public FilterWizard(ISelection sel) {
        this.selection = sel;
    }

    public void addPages() {
        super.addPages();
        this.page = new FilterWizardPage("org.eclipse.wst.rdb.server.internal.ui.explorer.filter", ResourceLoader.INSTANCE.queryString("_UI_TITLE_FILTER"), ImageDescription.getFilterWizardDescriptor(), this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        Object sel = ((StructuredSelection)this.selection).getFirstElement();
        ConnectionInfo connInfo = null;
        if (sel instanceof ISchemaNode) {
            connInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo((SQLObject)((IVirtualNode)sel).getParent());
            if (!this.page.isFilterSpecified()) {
                connInfo.removeFilter("DatatoolsSchemaFilterPredicate");
                ((ICatalogObject)((IVirtualNode)sel).getParent()).refresh();
            } else {
                ConnectionFilterImpl connFilter = new ConnectionFilterImpl();
                connFilter.setPredicate(this.page.getPredicate());
                connInfo.addFilter("DatatoolsSchemaFilterPredicate", (ConnectionFilter)connFilter);
                ((ICatalogObject)((IVirtualNode)sel).getParent()).refresh();
            }
        } else if (sel instanceof IVirtualNode) {
            Schema schema = (Schema)((IVirtualNode)sel).getParent();
            connInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo((SQLObject)schema.getDatabase());
            String connectionFilterType = "DatatoolsTableFilterPredicate";
            if (sel instanceof ITableNode) {
                connectionFilterType = "DatatoolsTableFilterPredicate";
            } else if (sel instanceof IViewNode) {
                connectionFilterType = "DatatoolsViewFilterPredicate";
            } else if (sel instanceof IStoredProcedureNode) {
                connectionFilterType = "DatatoolsSPFilterPredicate";
            } else if (sel instanceof IUDFNode) {
                connectionFilterType = "DatatoolsUDFFilterPredicate";
            } else if (sel instanceof ISequenceNode) {
                connectionFilterType = "DatatoolsSequenceFilterPredicate";
            } else if (sel instanceof IUDTNode) {
                connectionFilterType = "DatatoolsUDTFilterPredicate";
            }
            if (!this.page.isFilterSpecified()) {
                connInfo.removeFilter(String.valueOf(schema.getName()) + "::" + connectionFilterType);
                ((ICatalogObject)schema).refresh();
            } else {
                ConnectionFilterImpl connFilter = new ConnectionFilterImpl();
                connFilter.setPredicate(this.page.getPredicate());
                connInfo.addFilter(String.valueOf(schema.getName()) + "::" + connectionFilterType, (ConnectionFilter)connFilter);
                ((ICatalogObject)schema).refresh();
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }
}

