/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RestoreAction
extends QuickDiffRestoreAction {
    private static final String PREFIX = "RestoreAction.";
    private static final String SINGLE_KEY = "RestoreAction.label";
    private static final String MULTIPLE_KEY = "RestoreAction.multiple.label";
    private int fLine;

    public RestoreAction(ITextEditor editor, boolean isRulerAction) {
        super(QuickDiffMessages.getResourceBundle(), PREFIX, editor, isRulerAction);
    }

    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        this.fLine = this.getLastLine();
        if (this.fLine == -1) {
            return false;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ == null) {
            return false;
        }
        ILineDiffInfo info = differ.getLineInfo(this.fLine);
        if (info == null || info.getRemovedLinesAbove() <= 0 && info.getRemovedLinesBelow() <= 0) {
            return false;
        }
        if (info.getRemovedLinesBelow() == 0) {
            --this.fLine;
        } else {
            info.getRemovedLinesAbove();
        }
        info = differ.getLineInfo(this.fLine);
        if (info.getRemovedLinesBelow() == 1) {
            this.setText(QuickDiffMessages.getString(SINGLE_KEY));
        } else {
            this.setText(QuickDiffMessages.getFormattedString(MULTIPLE_KEY, String.valueOf(info.getRemovedLinesBelow())));
        }
        return true;
    }

    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ != null) {
            try {
                differ.restoreAfterLine(this.fLine);
            }
            catch (BadLocationException e) {
                this.setStatus(e.getMessage());
            }
        }
    }
}

