/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.PixelConverter;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

class AnnotationsConfigurationBlock
implements IPreferenceConfigurationBlock {
    public static final String ERROR_SYSTEM_IMAGE = "error";
    public static final String WARNING_SYSTEM_IMAGE = "warning";
    public static final String INFO_SYSTEM_IMAGE = "info";
    public static final String TASK_SYSTEM_IMAGE = "task";
    public static final String BOOKMARK_SYSTEM_IMAGE = "bookmark";
    private static final Map MAPPING = new HashMap();
    static final String[] HIGHLIGHT;
    static final String[] UNDERLINE;
    static final String[] BOX;
    static final String[] IBEAM;
    static final String[] SQUIGGLES;
    private OverlayPreferenceStore fStore;
    private ColorSelector fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;
    private Button fShowInVerticalRulerCheckBox;
    private StructuredViewer fAnnotationTypeViewer;
    private final ListItem[] fListModel;
    private ComboViewer fDecorationViewer;
    private final Set fImageKeys = new HashSet();

    static {
        MAPPING.put(ERROR_SYSTEM_IMAGE, "IMG_OBJS_ERROR_TSK");
        MAPPING.put(WARNING_SYSTEM_IMAGE, "IMG_OBJS_WARN_TSK");
        MAPPING.put(INFO_SYSTEM_IMAGE, "IMG_OBJS_INFO_TSK");
        MAPPING.put(TASK_SYSTEM_IMAGE, "IMG_OBJS_TASK_TSK");
        MAPPING.put(BOOKMARK_SYSTEM_IMAGE, "IMG_OBJS_BKMRK_TSK");
        HIGHLIGHT = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_HIGHLIGHT, "not used"};
        UNDERLINE = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_UNDERLINE, "UNDERLINE"};
        BOX = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_BOX, "BOX"};
        IBEAM = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_IBEAM, "IBEAM"};
        SQUIGGLES = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_SQUIGGLES, "SQUIGGLES"};
    }

    public AnnotationsConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        MarkerAnnotationPreferences markerAnnotationPreferences = new MarkerAnnotationPreferences();
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys(markerAnnotationPreferences));
        this.fListModel = this.createAnnotationTypeListModel(markerAnnotationPreferences);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            if (info.getHighlightPreferenceKey() != null) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getHighlightPreferenceKey()));
            }
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
            if (info.getVerticalRulerPreferenceKey() != null) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getVerticalRulerPreferenceKey()));
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getTextStylePreferenceKey()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(TextEditorMessages.AnnotationsConfigurationBlock_annotationPresentationOptions);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationTypeViewer = new TableViewer(editorComposite, 68100);
        this.fAnnotationTypeViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.fAnnotationTypeViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        gd = new GridData(1, 1, false, false);
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        this.fAnnotationTypeViewer.getControl().setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(optionsComposite, 16384);
        label.setText(TextEditorMessages.AnnotationsConfigurationBlock_labels_showIn);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText(TextEditorMessages.AnnotationsConfigurationBlock_showInText);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 20;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fDecorationViewer = new ComboViewer(optionsComposite, 8);
        this.fDecorationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fDecorationViewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fDecorationViewer.getControl().setLayoutData((Object)gd);
        this.fDecorationViewer.setInput((Object)new Object[]{HIGHLIGHT, SQUIGGLES, BOX, UNDERLINE, IBEAM});
        this.fShowInOverviewRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInOverviewRulerCheckBox.setText(TextEditorMessages.AnnotationsConfigurationBlock_showInOverviewRuler);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gd);
        this.fShowInVerticalRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInVerticalRulerCheckBox.setText(TextEditorMessages.AnnotationsConfigurationBlock_showInVerticalRuler);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        this.fShowInVerticalRulerCheckBox.setLayoutData((Object)gd);
        label = new Label(optionsComposite, 16384);
        label.setText(TextEditorMessages.AnnotationsConfigurationBlock_color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorSelector(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAnnotationTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AnnotationsConfigurationBlock.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = AnnotationsConfigurationBlock.this.getSelectedItem();
                boolean value = AnnotationsConfigurationBlock.this.fShowInTextCheckBox.getSelection();
                if (value) {
                    String[] decoration = (String[])((IStructuredSelection)AnnotationsConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                    if (HIGHLIGHT.equals(decoration)) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(item.highlightKey, true);
                    } else {
                        AnnotationsConfigurationBlock.this.fStore.setValue(item.textKey, true);
                    }
                } else {
                    if (item.textKey != null) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(item.textKey, false);
                    }
                    if (item.highlightKey != null) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(item.highlightKey, false);
                    }
                }
                AnnotationsConfigurationBlock.this.fStore.setValue(item.textKey, value);
                AnnotationsConfigurationBlock.this.updateDecorationViewer(item, false);
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)item);
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = AnnotationsConfigurationBlock.this.getSelectedItem();
                AnnotationsConfigurationBlock.this.fStore.setValue(item.overviewRulerKey, AnnotationsConfigurationBlock.this.fShowInOverviewRulerCheckBox.getSelection());
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)item);
            }
        });
        this.fShowInVerticalRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = AnnotationsConfigurationBlock.this.getSelectedItem();
                AnnotationsConfigurationBlock.this.fStore.setValue(item.verticalRulerKey, AnnotationsConfigurationBlock.this.fShowInVerticalRulerCheckBox.getSelection());
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)item);
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = AnnotationsConfigurationBlock.this.getSelectedItem();
                PreferenceConverter.setValue((IPreferenceStore)AnnotationsConfigurationBlock.this.fStore, (String)item.colorKey, (RGB)AnnotationsConfigurationBlock.this.fAnnotationForegroundColorEditor.getColorValue());
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)item);
            }
        });
        this.fDecorationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String[] decoration = (String[])((IStructuredSelection)AnnotationsConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                ListItem item = AnnotationsConfigurationBlock.this.getSelectedItem();
                if (AnnotationsConfigurationBlock.this.fShowInTextCheckBox.getSelection()) {
                    if (HIGHLIGHT.equals(decoration)) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(item.highlightKey, true);
                        if (item.textKey != null) {
                            AnnotationsConfigurationBlock.this.fStore.setValue(item.textKey, false);
                            if (item.textStyleKey != null) {
                                AnnotationsConfigurationBlock.this.fStore.setValue(item.textStyleKey, "NONE");
                            }
                        }
                    } else {
                        if (item.highlightKey != null) {
                            AnnotationsConfigurationBlock.this.fStore.setValue(item.highlightKey, false);
                        }
                        if (item.textKey != null) {
                            AnnotationsConfigurationBlock.this.fStore.setValue(item.textKey, true);
                            if (item.textStyleKey != null) {
                                AnnotationsConfigurationBlock.this.fStore.setValue(item.textStyleKey, decoration[1]);
                            }
                        }
                    }
                }
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)item);
            }
        });
        composite.layout();
        return composite;
    }

    public boolean canPerformOk() {
        return true;
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.fStore.loadDefaults();
        this.fAnnotationTypeViewer.refresh();
        this.handleAnnotationListSelection();
    }

    private void handleAnnotationListSelection() {
        ListItem item = this.getSelectedItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)item.colorKey);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        boolean highlight = item.highlightKey == null ? false : this.fStore.getBoolean(item.highlightKey);
        boolean showInText = item.textKey == null ? false : this.fStore.getBoolean(item.textKey);
        this.fShowInTextCheckBox.setSelection(showInText || highlight);
        this.updateDecorationViewer(item, true);
        this.fShowInOverviewRulerCheckBox.setSelection(this.fStore.getBoolean(item.overviewRulerKey));
        if (item.verticalRulerKey != null) {
            this.fShowInVerticalRulerCheckBox.setSelection(this.fStore.getBoolean(item.verticalRulerKey));
            this.fShowInVerticalRulerCheckBox.setEnabled(true);
        } else {
            this.fShowInVerticalRulerCheckBox.setSelection(true);
            this.fShowInVerticalRulerCheckBox.setEnabled(false);
        }
    }

    public void initialize() {
        this.fAnnotationTypeViewer.setInput((Object)this.fListModel);
        this.fAnnotationTypeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AnnotationsConfigurationBlock.this.fAnnotationTypeViewer != null && !AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.getControl().isDisposed()) {
                    AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.setSelection((ISelection)new StructuredSelection((Object)AnnotationsConfigurationBlock.this.fListModel[0]));
                }
            }
        });
    }

    private ListItem[] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<ListItem> listModelItems = new ArrayList<ListItem>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!info.isIncludeOnPreferencePage()) continue;
            String label = info.getPreferenceLabel();
            if (this.containsMoreThanOne(preferences.getAnnotationPreferences().iterator(), label)) {
                label = String.valueOf(label) + " (" + info.getAnnotationType() + ")";
            }
            Image image = this.getImage(info);
            listModelItems.add(new ListItem(label, image, info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getOverviewRulerPreferenceKey(), info.getHighlightPreferenceKey(), info.getVerticalRulerPreferenceKey(), info.getTextStylePreferenceKey()));
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o2 instanceof ListItem)) {
                    return -1;
                }
                if (!(o1 instanceof ListItem)) {
                    return 1;
                }
                String label1 = ((ListItem)o1).label;
                String label2 = ((ListItem)o2).label;
                return Collator.getInstance().compare(label1, label2);
            }
        };
        Collections.sort(listModelItems, comparator);
        ListItem[] items = new ListItem[listModelItems.size()];
        listModelItems.toArray(items);
        return items;
    }

    private Image getImage(AnnotationPreference preference) {
        Image copy;
        ImageRegistry registry = EditorsPlugin.getDefault().getImageRegistry();
        String annotationType = (String)preference.getAnnotationType();
        if (annotationType == null) {
            return null;
        }
        String customImage = String.valueOf(annotationType) + "__AnnotationsConfigurationBlock_Image";
        Image image = registry.get(customImage);
        if (image != null) {
            return image;
        }
        image = registry.get(annotationType);
        if (image == null) {
            ImageDescriptor descriptor = preference.getImageDescriptor();
            if (descriptor != null) {
                registry.put(annotationType, descriptor);
                image = registry.get(annotationType);
            } else {
                String key = this.translateSymbolicImageName(preference.getSymbolicImageName());
                if (key != null) {
                    ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                    image = sharedImages.getImage(key);
                }
            }
        }
        if (image == null) {
            return image;
        }
        ImageData data = image.getImageData();
        if (data.height > 16 || data.width > 16) {
            copy = new Image((Device)Display.getCurrent(), data.scaledTo(16, 16));
        } else {
            ImageData mask = data.getTransparencyMask();
            ImageData resized = new ImageData(16, 16, data.depth, data.palette);
            ImageData resizedMask = new ImageData(16, 16, mask.depth, mask.palette);
            int xo = Math.max(0, (16 - data.width) / 2);
            int yo = Math.max(0, (16 - data.height) / 2);
            int y = 0;
            while (y < 16) {
                int x = 0;
                while (x < 16) {
                    if (y >= yo && x >= xo && y < yo + data.height && x < xo + data.width) {
                        resized.setPixel(x, y, data.getPixel(x - xo, y - yo));
                        resizedMask.setPixel(x, y, mask.getPixel(x - xo, y - yo));
                    }
                    ++x;
                }
                ++y;
            }
            copy = new Image((Device)Display.getCurrent(), resized, resizedMask);
        }
        this.fImageKeys.add(customImage);
        registry.put(customImage, copy);
        return copy;
    }

    private String translateSymbolicImageName(String symbolicImageName) {
        return (String)MAPPING.get(symbolicImageName);
    }

    private boolean containsMoreThanOne(Iterator annotationPrefernceIterator, String label) {
        if (label == null) {
            return false;
        }
        int count = 0;
        while (annotationPrefernceIterator.hasNext()) {
            if (label.equals(((AnnotationPreference)annotationPrefernceIterator.next()).getPreferenceLabel())) {
                ++count;
            }
            if (count != 2) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        ImageRegistry registry = EditorsPlugin.getDefault().getImageRegistry();
        Iterator it = this.fImageKeys.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            registry.remove(string);
        }
        this.fImageKeys.clear();
    }

    private ListItem getSelectedItem() {
        return (ListItem)((IStructuredSelection)this.fAnnotationTypeViewer.getSelection()).getFirstElement();
    }

    private void updateDecorationViewer(ListItem item, boolean changed) {
        boolean enabled = this.fShowInTextCheckBox.getSelection() && (item.highlightKey != null || item.textStyleKey != null);
        this.fDecorationViewer.getControl().setEnabled(enabled);
        if (changed) {
            String[] selection = null;
            ArrayList<String[]> list = new ArrayList<String[]>();
            if (item.highlightKey != null) {
                list.add(HIGHLIGHT);
                if (this.fStore.getBoolean(item.highlightKey)) {
                    selection = HIGHLIGHT;
                }
            }
            list.add(SQUIGGLES);
            if (item.textStyleKey != null) {
                list.add(UNDERLINE);
                list.add(BOX);
                list.add(IBEAM);
            }
            if (selection == null) {
                String val = item.textStyleKey == null ? SQUIGGLES[1] : this.fStore.getString(item.textStyleKey);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String[] elem = (String[])iter.next();
                    if (!elem[1].equals(val)) continue;
                    selection = elem;
                    break;
                }
            }
            this.fDecorationViewer.setInput((Object)list.toArray(new Object[list.size()]));
            if (selection != null) {
                this.fDecorationViewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
            }
        }
    }

    private static final class ListItem {
        final String label;
        final Image image;
        final String colorKey;
        final String highlightKey;
        final String overviewRulerKey;
        final String textStyleKey;
        final String textKey;
        final String verticalRulerKey;

        ListItem(String label, Image image, String colorKey, String textKey, String overviewRulerKey, String highlightKey, String verticalRulerKey, String textStyleKey) {
            this.label = label;
            this.image = image;
            this.colorKey = colorKey;
            this.highlightKey = highlightKey;
            this.overviewRulerKey = overviewRulerKey;
            this.textKey = textKey;
            this.textStyleKey = textStyleKey;
            this.verticalRulerKey = verticalRulerKey;
        }
    }

    private static final class ItemContentProvider
    implements IStructuredContentProvider {
        ItemContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (ListItem[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ItemLabelProvider
    extends LabelProvider
    implements IColorProvider {
        ItemLabelProvider() {
        }

        public String getText(Object element) {
            return ((ListItem)element).label;
        }

        public Image getImage(Object element) {
            ListItem item = (ListItem)element;
            if (item.verticalRulerKey != null && AnnotationsConfigurationBlock.this.fStore.getBoolean(item.verticalRulerKey)) {
                return item.image;
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            String key = ((ListItem)element).highlightKey;
            if (key != null && AnnotationsConfigurationBlock.this.fStore.getBoolean(key)) {
                RGB color = PreferenceConverter.getColor((IPreferenceStore)AnnotationsConfigurationBlock.this.fStore, (String)((ListItem)element).colorKey);
                color = this.interpolate(color, new RGB(255, 255, 255), 0.6);
                return EditorsPlugin.getDefault().getSharedTextColors().getColor(color);
            }
            return null;
        }

        private RGB interpolate(RGB fg, RGB bg, double scale) {
            return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
        }
    }

    private static class ArrayLabelProvider
    extends LabelProvider {
        ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return ((String[])element)[0].toString();
        }
    }
}

