/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.data.internal.core.common.DataDeserializer;
import org.eclipse.wst.rdb.data.internal.core.common.DataSerializer;
import org.eclipse.wst.rdb.data.internal.core.editor.IRowData;
import org.eclipse.wst.rdb.data.internal.ui.DataUIPlugin;
import org.eclipse.wst.rdb.data.internal.ui.editor.Messages;
import org.eclipse.wst.rdb.data.internal.ui.editor.TableDataEditor;

public class TableDataCellModifier
implements ICellModifier {
    protected TableDataEditor editor;
    protected TableViewer viewer;
    protected boolean canModify = false;

    public TableDataCellModifier(TableDataEditor editor, TableViewer viewer) {
        this.editor = editor;
        this.viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        return this.canModify && !this.editor.isReadonly();
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public Object getValue(Object element, String property) {
        int col = this.getColumnIndex(property);
        if (!(element instanceof IRowData)) {
            return "";
        }
        IRowData row = (IRowData)element;
        try {
            Object o = row.getValue(col);
            String s = DataSerializer.serialize((Object)o, (int)row.getTable().getColumnType(col));
            return s == null ? "" : s;
        }
        catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            return Messages.getString("TableDataCellModifier.error");
        }
    }

    public void modify(Object element, String property, Object value) {
        IRowData row;
        Object oldObject;
        String oldString;
        int column = this.getColumnIndex(property);
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (value.equals(oldString = DataSerializer.serialize((Object)(oldObject = (row = this.editor.getOrCreateRow()).getValue(column)), (int)row.getTable().getColumnType(column)))) {
            return;
        }
        try {
            this.editor.setDirty(true);
            Object o = DataDeserializer.deserialize((String)((String)value), (int)row.getTable().getColumnType(column));
            row.updateValue(column, o);
        }
        catch (Exception ex) {
            Status warning = new Status(4, "org.eclipse.wst.rdb.data.ui", 1, Messages.getString("TableDataCellModifier.dataFormatError"), (Throwable)ex);
            ErrorDialog.openError((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("TableDataCellModifier.ErrorUpdatingData"), null, (IStatus)warning);
        }
        this.viewer.refresh((Object)row);
    }

    protected int getColumnIndex(String property) {
        Object[] properties = this.viewer.getColumnProperties();
        int col = 0;
        while (properties[col] != property && col < properties.length) {
            ++col;
        }
        if (col == properties.length) {
            return -1;
        }
        return col;
    }
}

