/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.sql;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.rdb.sqleditor.internal.sql.ISQLCompletionEngine;
import org.eclipse.wst.rdb.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLCompletionEngine;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    private char[] fProposalAutoActivationSet;
    protected IContextInformationValidator fValidator = new Validator();
    private ISQLCompletionEngine fCompletionEngine;
    private Comparator fComparator;
    private ISQLDBProposalsService fDBProposalsService;

    public SQLCompletionProcessor() {
        char[] completionChars = new char[]{'.'};
        this.setCompletionProposalAutoActivationCharacters(completionChars);
        this.fCompletionEngine = new SQLCompletionEngine();
        this.fComparator = new CompletionProposalComparator();
        this.fDBProposalsService = null;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator = order ? new CompletionProposalComparator() : null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] result = null;
        try {
            IDocument doc = viewer.getDocument();
            ITypedRegion partition = null;
            partition = documentOffset > 0 ? (doc.getChar(documentOffset - 1) == ';' ? viewer.getDocument().getPartition(documentOffset) : viewer.getDocument().getPartition(documentOffset - 1)) : viewer.getDocument().getPartition(documentOffset);
            result = this.fCompletionEngine.computeProposals(doc, partition, documentOffset);
        }
        catch (BadLocationException badLocationException) {}
        if (result != null) {
            result = this.order(result);
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = null;
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public ISQLDBProposalsService getDBProposalService() {
        return this.fDBProposalsService;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setDBProposalsService(ISQLDBProposalsService dbProposalsService) {
        this.fDBProposalsService = dbProposalsService;
        ((SQLCompletionEngine)this.fCompletionEngine).setDBProposalsService(this.fDBProposalsService);
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        if (this.fComparator != null) {
            Arrays.sort(proposals, this.fComparator);
        }
        return proposals;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int position, TextPresentation presentation) {
            return true;
        }
    }

    private static class CompletionProposalComparator
    implements Comparator {
        CompletionProposalComparator() {
        }

        public int compare(Object o1, Object o2) {
            ICompletionProposal c1 = (ICompletionProposal)o1;
            ICompletionProposal c2 = (ICompletionProposal)o2;
            return c1.getDisplayString().compareTo(c2.getDisplayString());
        }
    }
}

