/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentImportDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class J2EEArtifactImportDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEComponentImportDataModelProperties,
IDataModelListener {
    private static final String DEFAULT_COMPONENT_NAME = "J2EEImportDataModel.DEFAULT_PROJECT_NAME";
    protected static final String RUNTIME_TARGET_ID = "IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID";
    private IDataModel componentCreationDM;
    private OpenFailureException cachedOpenFailureException = null;
    private boolean settingFileName = false;

    public String[] getPropertyNames() {
        return new String[]{"IJ2EEArtifactImportDataModelProperties.FILE_NAME", "IJ2EEArtifactImportDataModelProperties.FILE", "IJ2EEArtifactImportDataModelProperties.SAVE_FILTER", "IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER", "IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", "IJ2EEArtifactImportDataModelProperties.COMPONENT", "IJ2EEArtifactImportDataModelProperties.COMPONENT_NAME", "IJ2EEArtifactImportDataModelProperties.PROJECT_NAME", DEFAULT_COMPONENT_NAME, "IJ2EEArtifactImportDataModelProperties.FILE_SELECTION_HISTORY"};
    }

    public void init() {
        super.init();
        this.componentCreationDM = this.createJ2EEComponentCreationDataModel();
        this.componentCreationDM.setBooleanProperty("IComponentCreationDataModelProperties.CREATE_DEFAULT_FILES", false);
        this.componentCreationDM.addListener((IDataModelListener)this);
        this.model.addNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", this.componentCreationDM);
    }

    private IProject getProject() {
        String projName = this.model.getStringProperty("IJ2EEArtifactImportDataModelProperties.COMPONENT_NAME");
        return ProjectUtilities.getProject((String)projName);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.COMPONENT_NAME")) {
            return this.componentCreationDM.getProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
        }
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.PROJECT_NAME")) {
            return this.componentCreationDM.getProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
        }
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.COMPONENT")) {
            return ComponentCore.createComponent((IProject)this.getProject(), (String)this.getStringProperty("IJ2EEArtifactImportDataModelProperties.COMPONENT_NAME"));
        }
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(DEFAULT_COMPONENT_NAME)) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.FILE")) {
            if (!this.settingFileName) {
                this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", null);
            }
            this.updateDefaultComponentName();
            return true;
        }
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.COMPONENT_NAME")) {
            this.componentCreationDM.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", propertyValue);
        } else if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER") && this.getArchiveFile() != null) {
            this.getArchiveFile().setSaveFilter(this.getSaveFilter());
        } else if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName)) {
            try {
                this.cachedOpenFailureException = null;
                this.handleArchiveSetup((String)propertyValue);
            }
            catch (OpenFailureException oe) {
                this.cachedOpenFailureException = oe;
            }
        }
        return true;
    }

    private void updateDefaultComponentName() {
        Archive archive = this.getArchiveFile();
        if (archive != null && this.getBooleanProperty(DEFAULT_COMPONENT_NAME)) {
            Path path = new Path(archive.getURI());
            String defaultProjectName = path.segment(path.segmentCount() - 1);
            if (defaultProjectName.indexOf(46) > 0 && (defaultProjectName = defaultProjectName.substring(0, defaultProjectName.lastIndexOf(46))).indexOf(46) > 0) {
                defaultProjectName = defaultProjectName.replace('.', '_');
            }
            this.componentCreationDM.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)defaultProjectName);
            this.model.notifyPropertyChange("IJ2EEArtifactImportDataModelProperties.COMPONENT_NAME", 2);
            this.setBooleanProperty(DEFAULT_COMPONENT_NAME, true);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleArchiveSetup(String fileName) throws OpenFailureException {
        Archive archive = this.getArchiveFile();
        if (archive != null) {
            archive.close();
            this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", null);
        }
        String uri = this.getStringProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        if (!this.archiveExistsOnFile()) {
            return false;
        }
        archive = this.openArchive(uri);
        if (archive != null) {
            archive.setSaveFilter(this.getSaveFilter());
        }
        try {
            this.settingFileName = true;
            this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", archive);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.settingFileName = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.settingFileName = false;
            return archive != null;
        }
    }

    protected abstract Archive openArchive(String var1) throws OpenFailureException;

    private boolean closeModuleFile() {
        if (this.getArchiveFile() != null) {
            this.getArchiveFile().close();
        }
        return true;
    }

    public IStatus validate(String propertyName) {
        if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName) && !this.isPropertySet("IJ2EEArtifactImportDataModelProperties.FILE")) {
            String fileName = this.getStringProperty(propertyName);
            if (fileName == null || fileName.length() == 0) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"5", (Object[])new Object[]{ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
            if (this.cachedOpenFailureException != null) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)this.cachedOpenFailureException.getMessage()));
            }
            if (fileName != null && !this.archiveExistsOnFile()) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"6", (Object[])new Object[]{ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
        }
        return OK_STATUS;
    }

    protected int getJ2EEVersion() {
        return 0;
    }

    protected abstract IDataModel createJ2EEComponentCreationDataModel();

    protected abstract int getType();

    private boolean archiveExistsOnFile() {
        String jarName = (String)this.getProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        if (jarName != null && jarName.length() > 0) {
            File file = new File(jarName);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    public void dispose() {
        if (this.getBooleanProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            this.closeModuleFile();
        }
        super.dispose();
    }

    protected final void setArchiveFile(Archive archiveFile) {
        this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", archiveFile);
    }

    protected final Archive getArchiveFile() {
        return (Archive)this.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
    }

    protected final ArchiveOptions getArchiveOptions() {
        ArchiveOptions opts = new ArchiveOptions();
        opts.setIsReadOnly(true);
        return opts;
    }

    private SaveFilter getSaveFilter() {
        return (SaveFilter)this.getProperty("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER");
    }

    public void propertyChanged(DataModelEvent event) {
    }
}

