/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class UpdateJavaBuildPathOperation
implements IHeadlessRunnableWithProgress {
    protected IJavaProject javaProject;
    protected ClassPathSelection classPathSelection;
    protected Set allClasspathEntries;
    protected List allUnselectedClasspathEntries;

    public UpdateJavaBuildPathOperation(IJavaProject aJavaProject, ClassPathSelection aClassPathSelection) {
        this.javaProject = aJavaProject;
        this.classPathSelection = aClassPathSelection;
        this.allClasspathEntries = new HashSet();
        this.allClasspathEntries.addAll(Arrays.asList(aClassPathSelection.getClasspathEntriesForSelected()));
    }

    public UpdateJavaBuildPathOperation(IJavaProject aJavaProject, ClassPathSelection selected, ClassPathSelection unselected) {
        this.javaProject = aJavaProject;
        this.classPathSelection = selected;
        this.allClasspathEntries = new HashSet();
        if (selected != null && !selected.getClasspathElements().isEmpty()) {
            this.allClasspathEntries.addAll(Arrays.asList(selected.getClasspathEntriesForSelected()));
        }
        this.allUnselectedClasspathEntries = new ArrayList();
        if (unselected != null && !unselected.getClasspathElements().isEmpty()) {
            this.allUnselectedClasspathEntries.addAll(unselected.getClasspathElements());
        }
    }

    protected void ensureClasspathEntryIsExported(List cp, IClasspathEntry entry) {
        if (entry.isExported()) {
            return;
        }
        int index = this.getIndex(cp, entry);
        IClasspathEntry newEntry = null;
        switch (entry.getEntryKind()) {
            case 2: {
                newEntry = JavaCore.newProjectEntry((IPath)entry.getPath(), (boolean)true);
                break;
            }
            case 1: {
                newEntry = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (boolean)true);
                break;
            }
            case 4: {
                newEntry = JavaCore.newVariableEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath());
            }
        }
        if (entry != null) {
            cp.set(index, newEntry);
        }
    }

    protected IClasspathEntry ensureElementInList(List cp, ClasspathElement element, IClasspathEntry predecessor) {
        IClasspathEntry addedEntry = null;
        IClasspathEntry[] cpEntries = element.newClasspathEntries();
        if (cpEntries == null || cpEntries.length == 0) {
            return null;
        }
        int predecessorPos = predecessor == null ? -1 : this.getIndex(cp, predecessor);
        addedEntry = cpEntries[0];
        int pos = this.getIndex(cp, addedEntry);
        if (pos == -1) {
            if (predecessorPos == -1) {
                cp.add(addedEntry);
            } else {
                cp.add(predecessorPos + 1, addedEntry);
            }
        } else {
            addedEntry = (IClasspathEntry)cp.get(pos);
            if (pos < predecessorPos) {
                cp.remove(addedEntry);
                cp.add(predecessorPos, addedEntry);
            }
        }
        this.ensureClasspathEntryIsExported(cp, addedEntry);
        int i = 1;
        while (i < cpEntries.length) {
            int index = this.getIndex(cp, cpEntries[i]);
            if (index != -1) {
                addedEntry = (IClasspathEntry)cp.get(index);
                cp.remove(index);
            } else {
                addedEntry = cpEntries[i];
            }
            pos = this.getIndex(cp, cpEntries[0]);
            cp.add(pos + 1, addedEntry);
            ++i;
        }
        return addedEntry;
    }

    protected int getIndex(List cp, IClasspathEntry entry) {
        int i = 0;
        while (i < cp.size()) {
            IClasspathEntry elmt = (IClasspathEntry)cp.get(i);
            if (elmt.getPath().equals((Object)entry.getPath())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void ensureElementNotInList(List cp, ClasspathElement element) {
        IClasspathEntry[] cpEntries = element.newClasspathEntries();
        if (cpEntries == null || cpEntries.length == 0) {
            return;
        }
        int i = 0;
        while (i < cpEntries.length) {
            int index;
            if (!this.allClasspathEntries.contains(cpEntries[i]) && (index = this.getIndex(cp, cpEntries[i])) != -1) {
                cp.remove(index);
            }
            ++i;
        }
    }

    protected void ensureRemoveElementInList(List cp, ClasspathElement element) {
        IClasspathEntry[] cpEntries = element.newClasspathEntries();
        if (cpEntries == null || cpEntries.length == 0) {
            return;
        }
        int i = 0;
        while (i < cpEntries.length) {
            int index;
            if (cp.contains(cpEntries[i]) && (index = this.getIndex(cp, cpEntries[i])) != -1) {
                cp.remove(index);
            }
            ++i;
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            String[] prevRequiredProjects = this.javaProject.getRequiredProjectNames();
            ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>(Arrays.asList(this.javaProject.getRawClasspath()));
            List classpathElements = this.classPathSelection.getClasspathElements();
            IClasspathEntry predecessor = null;
            IClasspathEntry result = null;
            int i = 0;
            while (i < classpathElements.size()) {
                ClasspathElement element = (ClasspathElement)classpathElements.get(i);
                if (element.isSelected()) {
                    result = this.ensureElementInList(cp, element, predecessor);
                    if (result != null) {
                        predecessor = result;
                    }
                } else {
                    this.ensureElementNotInList(cp, element);
                }
                ++i;
            }
            this.filterUnselectedEntries(cp);
            IClasspathEntry[] newCp = cp.toArray(new IClasspathEntry[cp.size()]);
            this.javaProject.setRawClasspath(newCp, monitor);
            this.updateRequiredProjects(this.javaProject, prevRequiredProjects, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Exception ex) {
            throw new WFTWrappedException((Throwable)ex);
        }
    }

    private void filterUnselectedEntries(List cp) {
        if (this.allUnselectedClasspathEntries != null) {
            int i = 0;
            while (i < this.allUnselectedClasspathEntries.size()) {
                ClasspathElement element = (ClasspathElement)this.allUnselectedClasspathEntries.get(i);
                this.ensureRemoveElementInList(cp, element);
                ++i;
            }
        }
    }

    protected void updateRequiredProjects(IJavaProject jproject, String[] prevRequiredProjects, IProgressMonitor monitor) throws CoreException {
        String[] newRequiredProjects = jproject.getRequiredProjectNames();
        ArrayList<String> prevEntries = new ArrayList<String>(Arrays.asList(prevRequiredProjects));
        ArrayList<String> newEntries = new ArrayList<String>(Arrays.asList(newRequiredProjects));
        IProject proj = jproject.getProject();
        IProjectDescription projDesc = proj.getDescription();
        ArrayList<IProject> newRefs = new ArrayList<IProject>();
        IProject[] referencedProjects = projDesc.getReferencedProjects();
        int i = 0;
        while (i < referencedProjects.length) {
            String curr = referencedProjects[i].getName();
            if (newEntries.remove(curr) || !prevEntries.contains(curr)) {
                newRefs.add(referencedProjects[i]);
            }
            ++i;
        }
        IWorkspaceRoot root = proj.getWorkspace().getRoot();
        int i2 = 0;
        while (i2 < newEntries.size()) {
            String curr = newEntries.get(i2);
            newRefs.add(root.getProject(curr));
            ++i2;
        }
        projDesc.setReferencedProjects(newRefs.toArray(new IProject[newRefs.size()]));
        proj.setDescription(projDesc, monitor);
    }
}

