/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.reference;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddUtilityProjectToEARDataModel;
import org.eclipse.jst.j2ee.application.internal.operations.JavaUtilityComponentCreationOperation;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.EjbRefType;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.client.impl.ClientFactoryImpl;
import org.eclipse.jst.j2ee.internal.common.CommonPackage;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModel;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyOperation;
import org.eclipse.jst.j2ee.internal.earcreation.AddUtilityJARMapCommand;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.moduleextension.EjbModuleExtension;
import org.eclipse.jst.j2ee.internal.project.J2EEModuleNature;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.reference.EJBReferenceDataModel;
import org.eclipse.wst.common.componentcore.internal.operation.ModelModifierOperation;
import org.eclipse.wst.common.componentcore.internal.operation.ModelModifierOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class EJBReferenceCreationOperation
extends ModelModifierOperation {
    protected IProject ownerProject;
    protected IProject targetProject;
    protected AddUtilityJARMapCommand addUtilityJarMapCommand = null;
    protected JARDependencyOperation jarDependencyOperation = null;
    protected String refName = null;
    protected String refType = null;
    protected String refHome = null;
    protected String refRemote = null;
    protected String des = null;
    protected String refLink = null;
    protected IProject newClientProject;

    public EJBReferenceCreationOperation(EJBReferenceDataModel dataModel) {
        super((ModelModifierOperationDataModel)dataModel);
    }

    protected void doInitialize(IProgressMonitor monitor) {
        super.doInitialize(monitor);
        this.setUpDataForCommand();
    }

    protected void postExecuteCommands(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        super.postExecuteCommands(monitor);
        if (this.jarDependencyOperation != null) {
            this.jarDependencyOperation.run(monitor);
        }
    }

    protected void addHelpers() throws CoreException {
        ModifierHelper baseHelper = null;
        baseHelper = !this.operationDataModel.getBooleanProperty("EJBReferenceDataModel.IS_LOCAL") ? this.createEjbRefHelper() : this.createEJBLocalRefHelper();
        this.modifier.addHelper(baseHelper);
        if (((EJBReferenceDataModel)this.operationDataModel).shouldCreateClientJar()) {
            this.copyClientJarToEAR(this.ownerProject);
        }
        this.updateJARDependencyIfNecessary();
    }

    protected ModifierHelper createEJBLocalRefHelper() {
        ModifierHelper helper = new ModifierHelper();
        EJBLocalRef ref = CommonPackage.eINSTANCE.getCommonFactory().createEJBLocalRef();
        ref.setName(this.refName);
        ref.setType(EjbRefType.get((String)this.refType));
        ref.setLocal(this.refRemote);
        ref.setLocalHome(this.refHome);
        ref.setLink(this.refLink);
        Integer version = (Integer)this.operationDataModel.getProperty("ReferenceDataModel.J2EE_VERSION");
        if (version != null && version <= 13) {
            ref.setDescription(this.des);
        } else {
            Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
            descriptionObj.setValue(this.des);
            ref.getDescriptions().add((Object)descriptionObj);
        }
        helper.setOwner((EObject)this.operationDataModel.getProperty("ReferenceDataModel.OWNER"));
        helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_EjbLocalRefs());
        helper.setValue((Object)ref);
        return helper;
    }

    protected ModifierHelper createEjbRefHelper() {
        ModifierHelper helper = new ModifierHelper();
        EjbRef ref = CommonPackage.eINSTANCE.getCommonFactory().createEjbRef();
        ref.setName(this.refName);
        ref.setType(EjbRefType.get((String)this.refType));
        ref.setHome(this.refHome);
        ref.setRemote(this.refRemote);
        ref.setLink(this.refLink);
        helper.setOwner((EObject)this.operationDataModel.getProperty("ReferenceDataModel.OWNER"));
        Integer version = (Integer)this.operationDataModel.getProperty("ReferenceDataModel.J2EE_VERSION");
        if (version != null && version <= 13) {
            ref.setDescription(this.des);
        } else {
            Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
            descriptionObj.setValue(this.des);
            ref.getDescriptions().add((Object)descriptionObj);
        }
        switch (((EJBReferenceDataModel)this.operationDataModel).getDeploymentDescriptorType()) {
            case 1: {
                helper.setFeature((EStructuralFeature)ClientFactoryImpl.getPackage().getApplicationClient_EjbReferences());
                break;
            }
            case 3: {
                helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_EjbRefs());
                break;
            }
            case 4: {
                helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_EjbRefs());
            }
        }
        helper.setValue((Object)ref);
        return helper;
    }

    private void copyClientJarToEAR(IProject ownerProj) throws CoreException {
        J2EENature ownerNature;
        IProject clientProj = this.newClientProject;
        if (clientProj == null) {
            EjbModuleExtension ejbExt = EarModuleManager.getEJBModuleExtension();
            if (ejbExt == null) {
                return;
            }
            clientProj = ejbExt.getDefinedEJBClientJARProject(this.targetProject);
            if (clientProj == null) {
                JavaUtilityComponentCreationOperation clientOp = ejbExt.createEJBClientJARProject(this.targetProject);
                clientOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
                clientProj = ejbExt.getDefinedEJBClientJARProject(this.targetProject);
            }
            this.setNewClientProject(clientProj);
        }
        if (clientProj != null && (ownerNature = J2EENature.getRegisteredRuntime(ownerProj)) != null && ownerNature instanceof J2EEModuleNature) {
            EARNatureRuntime[] natures = ((J2EEModuleNature)ownerNature).getReferencingEARProjects();
            int i = 0;
            while (i < natures.length) {
                this.addUtilityJarIfNecessary(clientProj, natures[i]);
                ++i;
            }
        }
    }

    private void addUtilityJarIfNecessary(IProject clientProj, EARNatureRuntime nature) {
        if (!J2EEProjectUtilities.hasProjectMapping(nature, clientProj)) {
            IProject earProject = nature.getProject();
            String clientUri = J2EEProjectUtilities.getUtilityJARUriInFirstEAR(clientProj);
            AddUtilityProjectToEARDataModel uDataModel = AddUtilityProjectToEARDataModel.createAddToEARDataModel(earProject.getName(), clientProj);
            uDataModel.setProperty("AddModuleToEARDataModel.URI", clientUri);
            try {
                EJBReferenceCreationOperation.runNestedDefaultOperation((WTPOperationDataModel)uDataModel, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (InterruptedException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    public void updateJARDependencyIfNecessary() {
        if (this.ownerProject != null && J2EEProjectUtilities.getReferencingEARProjects(this.ownerProject) != null) {
            EARNatureRuntime earNature = J2EEProjectUtilities.getFirstReferencingEARProject(this.ownerProject);
            if (earNature == null) {
                return;
            }
            IProject earProject = earNature.getProject();
            JARDependencyDataModel dataModel = new JARDependencyDataModel();
            dataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", this.ownerProject.getName());
            dataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 0);
            dataModel.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", earProject.getName());
            EjbModuleExtension ejbExt = EarModuleManager.getEJBModuleExtension();
            String clientProjectName = null;
            if (ejbExt != null) {
                EJBJar ejbJar = ejbExt.getEJBJar(this.targetProject);
                if (ejbJar != null) {
                    IProject referencedProject = J2EEProjectUtilities.getProject((EObject)ejbJar);
                    clientProjectName = ejbJar.getEjbClientJar();
                    if (clientProjectName != null && !clientProjectName.equals("")) {
                        if (this.newClientProject != null) {
                            referencedProject = this.newClientProject;
                            clientProjectName = referencedProject.getName();
                        } else {
                            clientProjectName = referencedProject.getName();
                        }
                    } else {
                        clientProjectName = referencedProject.getName();
                    }
                }
                dataModel.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", clientProjectName);
            } else {
                dataModel.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", this.targetProject.getName());
            }
            this.jarDependencyOperation = new JARDependencyOperation(dataModel);
        }
    }

    private void setUpDataForCommand() {
        this.ownerProject = ProjectUtilities.getProject((EObject)((EObject)this.operationDataModel.getProperty("ReferenceDataModel.OWNER")));
        this.targetProject = ProjectUtilities.getProject((EObject)((EObject)this.operationDataModel.getProperty("EJBReferenceDataModel.TARGET")));
        this.refName = this.operationDataModel.getStringProperty("ReferenceDataModel.REF_NAME");
        this.refType = this.operationDataModel.getStringProperty("EJBReferenceDataModel.REF_TYPE");
        if (!this.operationDataModel.getBooleanProperty("EJBReferenceDataModel.TARGET_IN_DIFFERENT_EAR")) {
            this.refLink = this.operationDataModel.getStringProperty("EJBReferenceDataModel.LINK");
        }
        this.refHome = this.operationDataModel.getStringProperty("EJBReferenceDataModel.HOME_INTERFACE");
        this.refRemote = this.operationDataModel.getStringProperty("EJBReferenceDataModel.REMOTE_INTERACE");
        this.des = this.operationDataModel.getStringProperty("ReferenceDataModel.DESCRIPTION");
    }

    public void setNewClientProject(IProject project) {
        this.newClientProject = project;
    }
}

