/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.JavaElementChangeListener;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.SourceAttachmentManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class PDECore
extends Plugin
implements IEnvironmentVariables {
    public static final String PLUGIN_ID = "org.eclipse.pde.core";
    public static final String SELFHOSTING_BIN_EXLCUDES = "selfhosting.binExcludes";
    public static final String BINARY_PROJECT_VALUE = "binary";
    public static final String BINARY_REPOSITORY_PROVIDER = "org.eclipse.pde.core.BinaryRepositoryProvider";
    public static final String CLASSPATH_CONTAINER_ID = "org.eclipse.pde.core.requiredPlugins";
    public static final String JAVA_SEARCH_CONTAINER_ID = "org.eclipse.pde.core.externalJavaSearch";
    public static final String ECLIPSE_HOME_VARIABLE = "ECLIPSE_HOME";
    public static final QualifiedName EXTERNAL_PROJECT_PROPERTY = new QualifiedName("org.eclipse.pde.core", "imported");
    public static final String EXTERNAL_PROJECT_VALUE = "external";
    private static PDECore inst;
    public static final String SITEBUILD_LOG = "build.log";
    public static final String SITEBUILD_SCRIPTS = "scripts";
    public static final String SITEBUILD_TEMP_FOLDER = "temp.folder";
    private static boolean isDevLaunchMode;
    private PluginModelManager modelManager;
    private SchemaRegistry schemaRegistry;
    private SourceAttachmentManager sourceAttachmentManager;
    private SourceLocationManager sourceLocationManager;
    private TracingOptionsManager tracingOptionsManager;
    private BundleContext context;
    private ServiceTracker tracker;
    private ExternalModelManager externalModelManager;
    private WorkspaceModelManager workspaceModelManager;
    private JavaElementChangeListener fJavaElementChangeListener;
    private FeatureModelManager fFeatureModelManager;
    static /* synthetic */ Class class$0;

    static {
        isDevLaunchMode = false;
    }

    public static boolean compare(String id1, String version1, String id2, String version2, int match) {
        if (!id1.equals(id2)) {
            return false;
        }
        if (version1 == null) {
            return true;
        }
        if (version2 == null) {
            return false;
        }
        PluginVersionIdentifier pid1 = null;
        PluginVersionIdentifier pid2 = null;
        try {
            pid1 = new PluginVersionIdentifier(version1);
            pid2 = new PluginVersionIdentifier(version2);
        }
        catch (RuntimeException runtimeException) {
            return version2.equals(version1);
        }
        switch (match) {
            case 0: 
            case 2: {
                if (!pid2.isCompatibleWith(pid1)) break;
                return true;
            }
            case 1: {
                if (!pid2.isEquivalentTo(pid1)) break;
                return true;
            }
            case 3: {
                if (!pid2.isPerfect(pid1)) break;
                return true;
            }
            case 4: {
                if (!pid2.isGreaterOrEqualTo(pid1)) break;
                return true;
            }
        }
        return false;
    }

    public static PDECore getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return PDECore.getDefault().getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDECore.getPluginId(), 0, e.getMessage(), e);
        PDECore.log(status);
    }

    public static void logErrorMessage(String message) {
        PDECore.log((IStatus)new Status(4, PDECore.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e) {
        PDECore.logException(e, null);
    }

    public static void logException(Throwable e, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDECore.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static boolean isDevLaunchMode() {
        String[] args = Platform.getApplicationArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-pdelaunch")) {
                isDevLaunchMode = true;
            }
            ++i;
        }
        return isDevLaunchMode;
    }

    public PDECore() {
        inst = this;
    }

    public URL getInstallURL() {
        try {
            return Platform.resolve((URL)PDECore.getDefault().getBundle().getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IPluginExtensionPoint findExtensionPoint(String fullID) {
        if (fullID == null || fullID.length() == 0) {
            return null;
        }
        int lastDot = fullID.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String pluginID = fullID.substring(0, lastDot);
        IPlugin plugin = this.findPlugin(pluginID);
        if (plugin == null) {
            return null;
        }
        String pointID = fullID.substring(lastDot + 1);
        IPluginExtensionPoint[] points = plugin.getExtensionPoints();
        int i = 0;
        while (i < points.length) {
            IPluginExtensionPoint point = points[i];
            if (point.getId().equals(pointID)) {
                return point;
            }
            ++i;
        }
        return null;
    }

    private IFeature findFeature(IFeatureModel[] models, String id, String version, int match) {
        int i = 0;
        while (i < models.length) {
            String pversion;
            IFeatureModel model = models[i];
            IFeature feature = model.getFeature();
            String pid = feature.getId();
            if (PDECore.compare(id, version, pid, pversion = feature.getVersion(), match)) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    public IFeature findFeature(String id) {
        IFeatureModel[] models = this.getFeatureModelManager().findFeatureModels(id);
        if (models.length > 0) {
            return models[0].getFeature();
        }
        return null;
    }

    public IFeature findFeature(String id, String version, int match) {
        IFeatureModel[] models = this.getFeatureModelManager().findFeatureModels(id);
        return this.findFeature(models, id, version, match);
    }

    public IFragment[] findFragmentsFor(String id, String version) {
        IFragmentModel[] models = this.getModelManager().getFragments();
        ArrayList<IFragment> list = new ArrayList<IFragment>();
        int i = 0;
        while (i < models.length) {
            IFragment fragment;
            if (models[i].isEnabled() && PDECore.compare((fragment = models[i].getFragment()).getPluginId(), fragment.getPluginVersion(), id, version, fragment.getRule())) {
                list.add(fragment);
            }
            ++i;
        }
        return list.toArray(new IFragment[list.size()]);
    }

    public IPlugin findPlugin(String id) {
        return this.findPlugin(id, null, 0);
    }

    public IPlugin findPlugin(String id, String version, int match) {
        IPluginModel model = this.getModelManager().findPluginModel(id);
        return model != null && model.isEnabled() ? model.getPlugin() : null;
    }

    public ExternalModelManager getExternalModelManager() {
        this.initializeModels();
        return this.externalModelManager;
    }

    public PluginModelManager getModelManager() {
        this.initializeModels();
        return this.modelManager;
    }

    public FeatureModelManager getFeatureModelManager() {
        this.initializeModels();
        return this.fFeatureModelManager;
    }

    public JavaElementChangeListener getJavaElementChangeListener() {
        if (this.fJavaElementChangeListener == null) {
            this.fJavaElementChangeListener = new JavaElementChangeListener();
        }
        return this.fJavaElementChangeListener;
    }

    public SchemaRegistry getSchemaRegistry() {
        if (this.schemaRegistry == null) {
            this.schemaRegistry = new SchemaRegistry();
        }
        return this.schemaRegistry;
    }

    public SourceAttachmentManager getSourceAttachmentManager() {
        if (this.sourceAttachmentManager == null) {
            this.sourceAttachmentManager = new SourceAttachmentManager();
        }
        return this.sourceAttachmentManager;
    }

    public SourceLocationManager getSourceLocationManager() {
        if (this.sourceLocationManager == null) {
            this.sourceLocationManager = new SourceLocationManager();
        }
        return this.sourceLocationManager;
    }

    public TracingOptionsManager getTracingOptionsManager() {
        if (this.tracingOptionsManager == null) {
            this.tracingOptionsManager = new TracingOptionsManager();
        }
        return this.tracingOptionsManager;
    }

    public WorkspaceModelManager getWorkspaceModelManager() {
        this.initializeModels();
        return this.workspaceModelManager;
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences preferences = this.getPluginPreferences();
        preferences.setDefault("target_mode", "useThis");
        preferences.setDefault("checkedPlugins", "[savedAll]");
        if (preferences.getString("target_mode").equals("useThis")) {
            preferences.setValue("platform_path", ExternalModelManager.computeDefaultPlatformPath());
        } else {
            preferences.setDefault("platform_path", ExternalModelManager.computeDefaultPlatformPath());
        }
        preferences.setDefault("org.eclipse.pde.ui.os", Platform.getOS());
        preferences.setDefault("org.eclipse.pde.ui.ws", Platform.getWS());
        preferences.setDefault("org.eclipse.pde.ui.nl", Locale.getDefault().toString());
        preferences.setDefault("org.eclipse.pde.ui.arch", Platform.getOSArch());
    }

    private synchronized void initializeModels() {
        if (this.modelManager != null && this.externalModelManager != null && this.workspaceModelManager != null) {
            return;
        }
        this.externalModelManager = new ExternalModelManager();
        this.workspaceModelManager = new WorkspaceModelManager();
        this.modelManager = new PluginModelManager(this.workspaceModelManager, this.externalModelManager);
        this.fFeatureModelManager = new FeatureModelManager(this.workspaceModelManager);
    }

    public void releasePlatform() {
        if (this.tracker == null) {
            return;
        }
        this.tracker.close();
        this.tracker = null;
    }

    public PlatformAdmin acquirePlatform() {
        if (this.tracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.tracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.tracker.open();
        }
        PlatformAdmin result = (PlatformAdmin)this.tracker.getService();
        while (result == null) {
            try {
                this.tracker.waitForService(1000L);
                result = (PlatformAdmin)this.tracker.getService();
            }
            catch (InterruptedException interruptedException) {}
        }
        return result;
    }

    public String getTargetVersion() {
        return this.getModelManager().getTargetVersion();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        this.fJavaElementChangeListener = new JavaElementChangeListener();
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void stop(BundleContext context) throws CoreException {
        PDECore.getDefault().savePluginPreferences();
        if (this.fJavaElementChangeListener != null) {
            this.fJavaElementChangeListener.shutdown();
            this.fJavaElementChangeListener = null;
        }
        if (this.schemaRegistry != null) {
            this.schemaRegistry.shutdown();
            this.schemaRegistry = null;
        }
        if (this.modelManager != null) {
            this.modelManager.shutdown();
            this.modelManager = null;
        }
        if (this.fFeatureModelManager != null) {
            this.fFeatureModelManager.shutdown();
            this.fFeatureModelManager = null;
        }
        if (this.externalModelManager != null) {
            this.externalModelManager.shutdown();
            this.externalModelManager = null;
        }
        if (this.workspaceModelManager != null) {
            this.workspaceModelManager.shutdown();
            this.workspaceModelManager = null;
        }
    }
}

