/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.launcher.Main;

public class WebStartMain
extends Main {
    private static final String PROP_WEBSTART_AUTOMATIC_INSTALLATION = "eclipse.webstart.automaticInstallation";
    private static final String DEFAULT_OSGI_BUNDLES = "org.eclipse.core.runtime@2:start";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private String[] allJars = null;
    private Set onTheBundleList = new HashSet();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        System.setSecurityManager(null);
        int result = new WebStartMain().run(args);
        System.exit(result);
    }

    private void setDefaultBundles() {
        if (System.getProperty(PROP_OSGI_BUNDLES) != null) {
            return;
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, DEFAULT_OSGI_BUNDLES);
    }

    protected void basicRun(String[] args) throws Exception {
        String fwkURL = this.searchFor(this.framework, null);
        System.setProperty("osgi.framework", fwkURL);
        this.onTheBundleList.add(fwkURL);
        super.basicRun(args);
    }

    protected URL[] getBootPath(String base) throws IOException {
        URL[] result = super.getBootPath(base);
        this.setDefaultBundles();
        this.convertBundleList();
        this.addAllBundlesToBundleList();
        this.cleanup();
        return result;
    }

    private void cleanup() {
        this.allJars = null;
        this.onTheBundleList = null;
    }

    protected String searchFor(String target, String start) {
        String[] jars = this.getAllJars();
        ArrayList<String> selected = new ArrayList<String>(3);
        int i = 0;
        while (i < jars.length) {
            if (jars[i].indexOf(target) != -1) {
                selected.add(jars[i]);
            }
            ++i;
        }
        if (selected.size() == 0) {
            return null;
        }
        String[] selectedJars = new String[selected.size()];
        int i2 = 0;
        while (i2 < selected.size()) {
            selectedJars[i2] = this.extractFileName((String)selected.get(i2));
            ++i2;
        }
        if (this.debug) {
            System.out.println(this.extractInnerURL((String)selected.get(this.findMax(selectedJars))));
        }
        return this.extractInnerURL((String)selected.get(this.findMax(selectedJars)));
    }

    private String extractFileName(String url) {
        String innerURL = this.extractInnerURL(url);
        return innerURL.substring(innerURL.lastIndexOf("/") + 1);
    }

    private String[] getAllJars() {
        if (this.allJars != null) {
            return this.allJars;
        }
        ArrayList<String> collector = new ArrayList<String>();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.launcher.WebStartMain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Enumeration<URL> resources = clazz.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                collector.add(resources.nextElement().toExternalForm());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.allJars = new String[collector.size()];
        collector.toArray(this.allJars);
        if (this.debug) {
            this.printArray("Jars found on the webstart path:\n", this.allJars);
        }
        return this.allJars;
    }

    private String extractInnerURL(String url) {
        int lastBang;
        if (url.startsWith("jar:")) {
            url = url.substring(url.indexOf("jar:") + 4);
        }
        if ((lastBang = url.lastIndexOf(33)) != -1) {
            url = url.substring(0, lastBang);
        }
        return this.decode(url);
    }

    private void convertBundleList() {
        if (this.debug) {
            System.out.println("Osgi bundles before conversion:\n" + System.getProperty(PROP_OSGI_BUNDLES));
        }
        String[] bundles = this.getArrayFromList(System.getProperty(PROP_OSGI_BUNDLES));
        String result = "";
        int i = 0;
        while (i < bundles.length) {
            String bundle = bundles[i];
            int positionExtraInfo = bundle.indexOf(64);
            String bundleName = null;
            bundleName = positionExtraInfo == -1 ? bundle : bundle.substring(0, positionExtraInfo);
            String bundleURL = this.searchFor(bundleName, null);
            if (bundleURL == null) {
                if (this.debug) {
                    System.out.println("Could not find " + bundleName);
                }
            } else {
                this.onTheBundleList.add(bundleURL);
                bundleURL = "reference:" + bundleURL;
                result = String.valueOf(result) + bundleURL;
                if (positionExtraInfo != -1) {
                    result = String.valueOf(result) + bundle.substring(positionExtraInfo);
                }
                result = String.valueOf(result) + ',';
            }
            ++i;
        }
        System.setProperty(PROP_OSGI_BUNDLES, result);
    }

    private void addAllBundlesToBundleList() {
        if ("false".equalsIgnoreCase(System.getProperties().getProperty(PROP_WEBSTART_AUTOMATIC_INSTALLATION))) {
            return;
        }
        String[] jarsOnClasspath = this.getAllJars();
        String[] result = new String[jarsOnClasspath.length];
        int i = 0;
        while (i < jarsOnClasspath.length) {
            this.onTheBundleList.contains(jarsOnClasspath[i]);
            result[i] = "reference:" + this.extractInnerURL(jarsOnClasspath[i]);
            ++i;
        }
        System.setProperty(PROP_OSGI_BUNDLES, String.valueOf(System.getProperty(PROP_OSGI_BUNDLES)) + this.arrayToString(result, ','));
        if (this.debug) {
            this.printArray("Bundles list:\n", result);
        }
    }

    private void printArray(String header, String[] values) {
        System.out.println(header);
        int i = 0;
        while (i < values.length) {
            System.out.println("\t" + values[i]);
            ++i;
        }
    }

    private String arrayToString(String[] array, char separator) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < array.length - 1) {
            result.append(array[i]).append(separator);
            ++i;
        }
        result.append(array[array.length - 1]);
        return new String(result);
    }
}

