/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.command;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.j2ee.internal.command.J2EEClipboard;
import org.eclipse.jst.j2ee.internal.command.J2EECopyFromClipboardCommand;
import org.eclipse.jst.j2ee.internal.common.util.IDUtility;
import org.eclipse.jst.j2ee.internal.provider.J2EEUIEditingDomain;

public class J2EEPasteFromClipboardOverrideCommand
extends PasteFromClipboardCommand {
    private J2EECopyFromClipboardCommand copyCommand;
    private Command addBindingsCommand;
    private Command addExtensionsCommand;

    public J2EEPasteFromClipboardOverrideCommand(PasteFromClipboardCommand p) {
        super(p.getDomain(), p.getOwner(), p.getFeature(), p.getIndex(), false);
    }

    public void doExecute() {
        super.doExecute();
        this.executeAddBindings();
        this.executeAddExtensions();
        J2EEClipboard result = (J2EEClipboard)this.doGetResult();
        int i = 0;
        while (i < result.size()) {
            EObject o = (EObject)result.get(i);
            if (result.getBinding(o) != null || result.getExtension(o) != null) {
                IDUtility.setDefaultID((EObject)o, (boolean)true);
            }
            ++i;
        }
    }

    public Collection doGetAffectedObjects() {
        return this.copyCommand.getAffectedObjects();
    }

    public Collection doGetResult() {
        return this.copyCommand.getResult();
    }

    public void doRedo() {
        super.doRedo();
        if (this.addBindingsCommand != null) {
            this.addBindingsCommand.redo();
        }
        if (this.addExtensionsCommand != null) {
            this.addExtensionsCommand.redo();
        }
    }

    public void doUndo() {
        super.doUndo();
        if (this.addBindingsCommand != null) {
            this.addBindingsCommand.undo();
        }
        if (this.addExtensionsCommand != null) {
            this.addExtensionsCommand.undo();
        }
    }

    protected void executeAddBindings() {
        if (this.addBindingsCommand != null && this.addBindingsCommand.canExecute()) {
            this.addBindingsCommand.execute();
        }
    }

    protected void executeAddExtensions() {
        if (this.addExtensionsCommand != null && this.addExtensionsCommand.canExecute()) {
            this.addExtensionsCommand.execute();
        }
    }

    public J2EEClipboard getCopiedClipoard() {
        return (J2EEClipboard)this.copyCommand.getResult();
    }

    protected J2EEClipboard getJ2EEClipboard() {
        return (J2EEClipboard)this.domain.getClipboard();
    }

    protected boolean prepare() {
        if (this.getJ2EEClipboard() == null) {
            return false;
        }
        this.command = new StrictCompoundCommand();
        this.copyCommand = new J2EECopyFromClipboardCommand((J2EEUIEditingDomain)this.domain);
        this.command.append((Command)this.copyCommand);
        this.command.append((Command)new CommandWrapper(){

            protected Command createCommand() {
                Command addCommand = AddCommand.create((EditingDomain)J2EEPasteFromClipboardOverrideCommand.this.getDomain(), (Object)J2EEPasteFromClipboardOverrideCommand.this.getOwner(), (Object)J2EEPasteFromClipboardOverrideCommand.this.getFeature(), (Collection)J2EEPasteFromClipboardOverrideCommand.this.copyCommand.getResult(), (int)J2EEPasteFromClipboardOverrideCommand.this.getIndex());
                return addCommand;
            }
        });
        this.prepareBindingCommand(this.copyCommand);
        this.prepareExtensionCommand(this.copyCommand);
        boolean result = this.optimize ? this.optimizedCanExecute() : this.command.canExecute();
        return result;
    }

    protected void prepareBindingCommand(J2EECopyFromClipboardCommand cmd) {
        if (!this.getJ2EEClipboard().hasBindings()) {
            return;
        }
    }

    protected void prepareExtensionCommand(J2EECopyFromClipboardCommand cmd) {
        if (!this.getJ2EEClipboard().hasExtensions()) {
            return;
        }
    }
}

