/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.parser;

import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParser;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.CoreNodeList;
import org.eclipse.wst.xml.core.internal.parser.XMLStructuredDocumentReParser;

public class JSPReParser
extends XMLStructuredDocumentReParser {
    protected StructuredDocumentEvent checkForCrossStructuredDocumentRegionSyntax() {
        StructuredDocumentEvent result = super.checkForCrossStructuredDocumentRegionSyntax();
        if (result == null) {
            result = this.checkForJSP();
        }
        return result;
    }

    private StructuredDocumentEvent checkForJSP() {
        StructuredDocumentEvent result = null;
        result = this.checkForCriticalKey("<%");
        if (result == null) {
            result = this.checkForCriticalKey("<%=");
        }
        if (result == null) {
            result = this.checkForCriticalKey("<%!");
        }
        if (result == null) {
            result = this.checkForCriticalKey("%>");
        }
        return result;
    }

    protected StructuredDocumentEvent checkForComments() {
        StructuredDocumentEvent result = super.checkForComments();
        if (result == null) {
            result = this.checkForCriticalKey("<%--");
        }
        if (result == null) {
            result = this.checkForCriticalKey("--%>");
        }
        if (result == null) {
            result = this.checkForCriticalKey("<%---%>");
        }
        return result;
    }

    protected StructuredDocumentEvent reparse(IStructuredDocumentRegion dirtyStart, IStructuredDocumentRegion dirtyEnd) {
        StructuredDocumentEvent result = null;
        int rescanStart = -1;
        int rescanEnd = -1;
        boolean firstTime = false;
        boolean detectedBreakingChange = false;
        CoreNodeList oldNodes = this.formOldNodes(dirtyStart, dirtyEnd);
        if (this.containsBreakingChange((IStructuredDocumentRegionList)oldNodes) || this.isBreakingWithNestedTag(dirtyStart, dirtyEnd)) {
            detectedBreakingChange = true;
            rescanStart = 0;
            rescanEnd = this.fStructuredDocument.getLength() + this.fLengthDifference;
            oldNodes = this.formOldNodes(this.fStructuredDocument.getFirstStructuredDocumentRegion(), this.fStructuredDocument.getLastStructuredDocumentRegion());
            this.clearTaglibInfo();
        } else if (dirtyStart == null || dirtyEnd == null) {
            rescanStart = 0;
            rescanEnd = this.fChanges.length();
            firstTime = true;
        } else {
            rescanStart = dirtyStart.getStart();
            rescanEnd = dirtyEnd.getEnd() + this.fLengthDifference;
        }
        this.fStructuredDocument.updateDocumentData(this.fStart, this.fLengthToReplace, this.fChanges);
        result = this.core_reparse(rescanStart, rescanEnd, oldNodes, firstTime);
        if (!detectedBreakingChange && this.containsBreakingChange((IStructuredDocumentRegionList)oldNodes)) {
            this.clearTaglibInfo();
            oldNodes = this.formOldNodes(this.fStructuredDocument.getFirstStructuredDocumentRegion(), this.fStructuredDocument.getLastStructuredDocumentRegion());
            result = this.core_reparse(0, this.fStructuredDocument.getLength(), oldNodes, firstTime);
        }
        return result;
    }

    private boolean isBreakingChange(IStructuredDocumentRegion node, ITextRegionList regions) {
        return this.isTaglibOrInclude(node, regions) || this.isJspRoot(regions);
    }

    private boolean isBreakingWithNestedTag(boolean changesIncludeA_lt, boolean delsIncludeA_gt, IStructuredDocumentRegion parent, ITextRegion region) {
        boolean result = false;
        IStructuredDocumentRegion previous = parent.getPrevious();
        if (!(parent.getRegions().size() != 1 || region.getType() != "XML_TAG_OPEN" || previous != null && previous.isEnded() && previous.getType() != "XML_CONTENT")) {
            result = true;
        }
        if (region instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)region;
            ITextRegion internal = container.getRegions().get(container.getRegions().size() - 1);
            if (internal.getType() == "WHITE_SPACE" && container.getRegions().size() >= 2) {
                internal = container.getRegions().get(container.getRegions().size() - 2);
            }
            if (internal.getType() == "XML_EMPTY_TAG_CLOSE") {
                result = true;
            }
        }
        if (changesIncludeA_lt && (region.getType() == "XML_TAG_ATTRIBUTE_NAME" || region.getType() == "XML_TAG_ATTRIBUTE_VALUE")) {
            result = true;
        }
        if (delsIncludeA_gt && region.getType() == "XML_TAG_CLOSE") {
            result = true;
        }
        return result;
    }

    private boolean isJspRoot(ITextRegionList regions) {
        return regions.size() > 1 && regions.get(0).getType() == "XML_TAG_OPEN" && regions.get(1).getType() == "JSP_ROOT_TAG_NAME";
    }

    private boolean isTaglibOrInclude(IStructuredDocumentRegion node, ITextRegionList regions) {
        boolean sizeAndTypesMatch;
        boolean bl = sizeAndTypesMatch = regions.size() > 1 && regions.get(1).getType() == "JSP_DIRECTIVE_NAME" && (regions.get(0).getType() == "JSP_DIRECTIVE_OPEN" || regions.get(0).getType() == "XML_TAG_OPEN");
        if (!sizeAndTypesMatch) {
            return false;
        }
        ITextRegion region = regions.get(1);
        String directiveName = node.getText(region);
        return sizeAndTypesMatch && (directiveName.equals("taglib") || directiveName.equals("include") || directiveName.equals("jsp:directive.taglib") || directiveName.equals("jsp:directive.include"));
    }

    private void clearTaglibInfo() {
        RegionParser parser = this.fStructuredDocument.getParser();
        if (parser instanceof StructuredDocumentRegionParser) {
            ((StructuredDocumentRegionParser)parser).resetHandlers();
        }
    }

    private boolean containsBreakingChange(IStructuredDocumentRegionList list) {
        boolean contains = false;
        int i = 0;
        while (i < list.getLength()) {
            IStructuredDocumentRegion node = list.item(i);
            if (this.isBreakingChange(node, node.getRegions())) {
                contains = true;
                break;
            }
            ++i;
        }
        return contains;
    }

    protected IStructuredDocumentRegion findDirtyEnd(int end) {
        IStructuredDocumentRegion result = super.findDirtyEnd(end);
        if (this.isJSPEmbeddedStartOrEnd(result)) {
            result = this.fStructuredDocument.getLastStructuredDocumentRegion();
        } else if (result != this.dirtyStart) {
            IStructuredDocumentRegion searchNode = this.dirtyStart;
            do {
                if (!this.isJSPEmbeddedStartOrEnd(searchNode)) continue;
                result = this.fStructuredDocument.getLastStructuredDocumentRegion();
                break;
            } while ((searchNode = searchNode.getNext()) != result && searchNode != null);
        }
        if (result != null) {
            this.fStructuredDocument.setCachedDocumentRegion(result);
        }
        this.dirtyEnd = result;
        return this.dirtyEnd;
    }

    private boolean isBreakingWithNestedTag(IStructuredDocumentRegion start, IStructuredDocumentRegion end) {
        boolean result = false;
        boolean changesIncludeA_lt = this.fChanges != null && this.fChanges.indexOf(60) >= 0;
        boolean delsIncludeA_gt = this.fDeletedText != null && this.fDeletedText.indexOf(62) >= 0;
        IStructuredDocumentRegion node = start;
        int endReplace = this.fStart + this.fLengthToReplace;
        while (end != null && node != end.getNext()) {
            Iterator i = node.getRegions().iterator();
            while (i.hasNext()) {
                ITextRegion region = (ITextRegion)i.next();
                if (this.intersects(node, region, this.fStart, endReplace) && (result = this.isBreakingWithNestedTag(changesIncludeA_lt, delsIncludeA_gt, node, region))) break;
            }
            node = node.getNext();
            if (result) break;
        }
        return result;
    }

    private boolean intersects(IStructuredDocumentRegion node, ITextRegion region, int low, int high) {
        int start = node.getStartOffset(region);
        int end = node.getEndOffset(region);
        return end >= low && start <= high || start <= low && end >= low || start <= high && end >= high;
    }

    private boolean isJSPEmbeddedStartOrEnd(IStructuredDocumentRegion flatNode) {
        boolean result = false;
        String type = flatNode.getType();
        result = type == "JSP_SCRIPTLET_OPEN" || type == "JSP_EXPRESSION_OPEN" || type == "JSP_DECLARATION_OPEN";
        return result;
    }

    protected boolean isPartOfBlockRegion(IStructuredDocumentRegion flatNode) {
        boolean result = false;
        String type = flatNode.getType();
        result = type == "JSP_CLOSE" || type == "JSP_CONTENT" || super.isPartOfBlockRegion(flatNode);
        return result;
    }

    public IStructuredTextReParser newInstance() {
        return new JSPReParser();
    }

    public StructuredDocumentEvent quickCheck() {
        if (this.containsBreakingChange((IStructuredDocumentRegionList)new CoreNodeList(this.dirtyStart, this.dirtyEnd))) {
            return null;
        }
        return super.quickCheck();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SourceEditingRuntimeException((Throwable)e);
        }
    }
}

