/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.util.URIResolver;

public class ProjectResolver
implements URIResolver {
    private String fFileBaseLocation = null;
    private IProject fProject = null;

    public ProjectResolver(IProject project) {
        this.fProject = project;
    }

    public String getFileBaseLocation() {
        return this.fFileBaseLocation;
    }

    public String getLocationByURI(String uri) {
        return this.getLocationByURI(uri, this.getFileBaseLocation());
    }

    public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
        return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
    }

    public String getLocationByURI(String uri, String baseReference) {
        if (uri == null) {
            return null;
        }
        if (this.isFileURL(uri)) {
            try {
                URL url = new URL(uri);
                return this.getPath(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        String location = uri;
        if (uri.startsWith("/")) {
            IProject p = this.getProject();
            if (p != null && p.exists()) {
                location = String.valueOf(p.getLocation().toString()) + uri;
            }
        } else {
            location = URIHelper.normalize((String)uri, (String)baseReference, (String)this.getRootLocationString());
        }
        return location;
    }

    public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
        return this.getLocationByURI(uri, baseReference);
    }

    private String getPath(IPath path, String host) {
        IPath newPath = path;
        String device = path.getDevice();
        if (device != null && device.length() > 0 && device.charAt(0) == '/') {
            String newDevice = device.substring(1);
            newPath = path.setDevice(newDevice);
        }
        if (path != null && host != null && host.length() != 0) {
            Path uncPath = new Path(host);
            uncPath = uncPath.append(path);
            newPath = uncPath.makeUNC(true);
        }
        return newPath.toString();
    }

    private String getPath(URL url) {
        Path path;
        String ref = url.getRef() == null ? "" : "#" + url.getRef();
        String strPath = String.valueOf(url.getFile()) + ref;
        if (strPath.length() == 0) {
            path = Path.ROOT;
        } else {
            path = new Path(strPath);
            String query = null;
            StringTokenizer parser = new StringTokenizer(strPath, "?");
            int tokenCount = parser.countTokens();
            if (tokenCount == 2) {
                path = new Path((String)parser.nextElement());
                query = (String)parser.nextElement();
            }
            if (query == null && (tokenCount = (parser = new StringTokenizer(path.toString(), "#")).countTokens()) == 2) {
                path = new Path((String)parser.nextElement());
            }
        }
        return this.getPath((IPath)path, url.getHost());
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IContainer getRootLocation() {
        return this.fProject;
    }

    protected String getRootLocationString() {
        return this.fProject.getLocation().toString();
    }

    public InputStream getURIStream(String uri) {
        return null;
    }

    private boolean isFileURL(String passedSpec) {
        if (passedSpec == null) {
            return false;
        }
        String spec = passedSpec.trim();
        if (spec.length() == 0) {
            return false;
        }
        int limit = spec.length();
        String newProtocol = null;
        int index = 0;
        while (index < limit) {
            char p = spec.charAt(index);
            if (p == '/') break;
            if (p == ':') {
                newProtocol = spec.substring(0, index);
                break;
            }
            ++index;
        }
        return newProtocol != null && newProtocol.compareToIgnoreCase("file") == 0;
    }

    public void setFileBaseLocation(String newFileBaseLocation) {
        this.fFileBaseLocation = newFileBaseLocation;
    }

    public void setProject(IProject newProject) {
        this.fProject = newProject;
    }
}

