/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class MarqueeSelectionTool
extends AbstractTool {
    public static final Object PROPERTY_MARQUEE_BEHAVIOR = "marqueeBehavior";
    public static final int BEHAVIOR_NODES_CONTAINED = new Integer(1);
    public static final int BEHAVIOR_CONNECTIONS_TOUCHED = new Integer(2);
    public static final int BEHAVIOR_NODES_AND_CONNECTIONS = new Integer(3);
    static final int DEFAULT_MODE = 0;
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private Figure marqueeRectangleFigure;
    private Set allChildren = new HashSet();
    private Collection selectedEditParts;
    private Request targetRequest;
    private int marqueeBehavior = BEHAVIOR_NODES_CONTAINED;
    private int mode;
    private static final Request MARQUEE_REQUEST = new Request("selection");

    public MarqueeSelectionTool() {
        this.setDefaultCursor(SharedCursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_MARQUEE_BEHAVIOR.equals(key)) {
            if (value instanceof Integer) {
                this.setMarqueeBehavior((Integer)value);
            }
            return;
        }
        super.applyProperty(key, value);
    }

    private void calculateConnections(Collection newSelections, Collection deselections) {
        ConnectionEditPart targetConn;
        ConnectionEditPart sourceConn;
        Iterator itr;
        GraphicalEditPart node;
        HashSet<EditPart> currentNodes = new HashSet<EditPart>();
        if (this.getSelectionMode() != 0) {
            Iterator iter = this.getCurrentViewer().getSelectedEditParts().iterator();
            while (iter.hasNext()) {
                EditPart selected = (EditPart)iter.next();
                if (selected instanceof ConnectionEditPart || deselections.contains(selected)) continue;
                currentNodes.add(selected);
            }
        }
        AbstractCollection connections = new ArrayList();
        Iterator nodes = newSelections.iterator();
        while (nodes.hasNext()) {
            node = (GraphicalEditPart)nodes.next();
            itr = node.getSourceConnections().iterator();
            while (itr.hasNext()) {
                sourceConn = (ConnectionEditPart)itr.next();
                if (sourceConn.getSelected() != 0 || !newSelections.contains(sourceConn.getTarget()) && !currentNodes.contains(sourceConn.getTarget())) continue;
                connections.add(sourceConn);
            }
            itr = node.getTargetConnections().iterator();
            while (itr.hasNext()) {
                targetConn = (ConnectionEditPart)itr.next();
                if (targetConn.getSelected() != 0 || !newSelections.contains(targetConn.getSource()) && !currentNodes.contains(targetConn.getSource())) continue;
                connections.add(targetConn);
            }
        }
        newSelections.addAll(connections);
        connections = new HashSet();
        nodes = deselections.iterator();
        while (nodes.hasNext()) {
            node = (GraphicalEditPart)nodes.next();
            itr = node.getSourceConnections().iterator();
            while (itr.hasNext()) {
                sourceConn = (ConnectionEditPart)itr.next();
                if (sourceConn.getSelected() == 0) continue;
                connections.add(sourceConn);
            }
            itr = node.getTargetConnections().iterator();
            while (itr.hasNext()) {
                targetConn = (ConnectionEditPart)itr.next();
                if (targetConn.getSelected() == 0) continue;
                connections.add(targetConn);
            }
        }
        deselections.addAll(connections);
    }

    private void calculateNewSelection(Collection newSelections, Collection deselections) {
        Rectangle marqueeRect = this.getMarqueeSelectionRectangle();
        Iterator itr = this.getAllChildren().iterator();
        while (itr.hasNext()) {
            GraphicalEditPart child = (GraphicalEditPart)itr.next();
            IFigure figure = child.getFigure();
            if (!child.isSelectable() || child.getTargetEditPart(MARQUEE_REQUEST) != child || !this.isFigureVisible(figure) || !figure.isShowing()) continue;
            Rectangle r = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            boolean included = false;
            if (child instanceof ConnectionEditPart && marqueeRect.intersects(r)) {
                Rectangle relMarqueeRect = Rectangle.SINGLETON;
                figure.translateToRelative((Translatable)relMarqueeRect.setBounds(marqueeRect));
                included = ((PolylineConnection)figure).getPoints().intersects(relMarqueeRect);
            } else {
                included = marqueeRect.contains(r);
            }
            if (!included) continue;
            if (child.getSelected() == 0 || this.getSelectionMode() != 1) {
                newSelections.add(child);
                continue;
            }
            deselections.add(child);
        }
        if (this.marqueeBehavior == BEHAVIOR_NODES_AND_CONNECTIONS) {
            this.calculateConnections(newSelections, deselections);
        }
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren.clear();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        Iterator oldEditParts = this.selectedEditParts.iterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private Set getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.getAllChildren(this.getCurrentViewer().getRootEditPart(), this.allChildren);
        }
        return this.allChildren;
    }

    private void getAllChildren(EditPart editPart, Set allChildren) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            if (this.marqueeBehavior == BEHAVIOR_NODES_CONTAINED || this.marqueeBehavior == BEHAVIOR_NODES_AND_CONNECTIONS) {
                allChildren.add(child);
            }
            if (this.marqueeBehavior == BEHAVIOR_CONNECTIONS_TOUCHED) {
                allChildren.addAll(child.getSourceConnections());
                allChildren.addAll(child.getTargetConnections());
            }
            this.getAllChildren(child, allChildren);
            ++i;
        }
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Marquee Tool: " + this.marqueeBehavior;
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private int getSelectionMode() {
        return this.mode;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            } else {
                this.setSelectionMode(0);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = new ArrayList();
            this.calculateNewSelection(this.selectedEditParts, new ArrayList());
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        return this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyPressed(e);
    }

    private boolean isFigureVisible(IFigure fig) {
        Rectangle figBounds = fig.getBounds().getCopy();
        IFigure walker = fig.getParent();
        while (!figBounds.isEmpty() && walker != null) {
            walker.translateToParent((Translatable)figBounds);
            figBounds.intersect(walker.getBounds());
            walker = walker.getParent();
        }
        return !figBounds.isEmpty();
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return viewer instanceof GraphicalViewer;
    }

    private void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        LinkedHashSet newSelections = new LinkedHashSet();
        HashSet deselections = new HashSet();
        this.calculateNewSelection(newSelections, deselections);
        if (this.getSelectionMode() != 0) {
            newSelections.addAll(viewer.getSelectedEditParts());
            newSelections.removeAll(deselections);
        }
        viewer.setSelection((ISelection)new StructuredSelection(newSelections.toArray()));
    }

    public void setMarqueeBehavior(int type) {
        if (type != BEHAVIOR_CONNECTIONS_TOUCHED && type != BEHAVIOR_NODES_CONTAINED && type != BEHAVIOR_NODES_AND_CONNECTIONS) {
            throw new IllegalArgumentException("Invalid marquee behaviour specified.");
        }
        this.marqueeBehavior = type;
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        this.getMarqueeFeedbackFigure().setBounds(rect);
    }

    private void showTargetFeedback() {
        Iterator itr = this.selectedEditParts.iterator();
        while (itr.hasNext()) {
            EditPart editPart = (EditPart)itr.next();
            editPart.showTargetFeedback(this.getTargetRequest());
        }
    }

    class MarqueeRectangleFigure
    extends Figure {
        private static final int DELAY = 110;
        private int offset = 0;
        private boolean schedulePaint = true;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(this){
                    final /* synthetic */ MarqueeRectangleFigure this$1;
                    {
                        this.this$1 = marqueeRectangleFigure;
                    }

                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = this.this$1;
                        MarqueeRectangleFigure.access$1(marqueeRectangleFigure, MarqueeRectangleFigure.access$0(marqueeRectangleFigure) + 1);
                        if (MarqueeRectangleFigure.access$0(this.this$1) > 5) {
                            MarqueeRectangleFigure.access$1(this.this$1, 0);
                        }
                        MarqueeRectangleFigure.access$2(this.this$1, true);
                        this.this$1.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }

        static /* synthetic */ int access$0(MarqueeRectangleFigure marqueeRectangleFigure) {
            return marqueeRectangleFigure.offset;
        }

        static /* synthetic */ void access$1(MarqueeRectangleFigure marqueeRectangleFigure, int n) {
            marqueeRectangleFigure.offset = n;
        }

        static /* synthetic */ void access$2(MarqueeRectangleFigure marqueeRectangleFigure, boolean bl) {
            marqueeRectangleFigure.schedulePaint = bl;
        }
    }
}

