/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizationAction;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.SnippetsPluginImageHelper;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.palette.ModelFactoryForUser;
import org.eclipse.wst.common.snippets.internal.palette.UserModelDumper;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsCustomizer;

public class SnippetCustomizerDialog
extends PaletteCustomizerDialog {
    private TreeViewer fTreeviewer = null;

    public SnippetCustomizerDialog(Shell shell, PaletteCustomizer customizer, PaletteRoot root) {
        super(shell, customizer, root);
    }

    protected List createOutlineActions() {
        List actions = super.createOutlineActions();
        actions.add(new ImportAction());
        actions.add(new ExportAction());
        return actions;
    }

    protected TreeViewer createOutlineTreeViewer(Composite composite) {
        this.fTreeviewer = super.createOutlineTreeViewer(composite);
        return this.fTreeviewer;
    }

    public int open() {
        this.save();
        return super.open();
    }

    private class ExportAction
    extends PaletteCustomizationAction {
        public ExportAction() {
            this.setEnabled(false);
            this.setText(SnippetsMessages.SnippetCustomizerDialog_1);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/export.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/export.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/export.gif"));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void handleExport() {
            block11: {
                exportCategory = (PaletteDrawer)SnippetCustomizerDialog.access$0(SnippetCustomizerDialog.this);
                fileDialog = new FileDialog(SnippetCustomizerDialog.this.getShell());
                fileDialog.setFileName("snippets.xml");
                filterExtensions = new String[]{"*.xml", "*.*"};
                fileDialog.setFilterExtensions(filterExtensions);
                filename = fileDialog.open();
                if (filename == null) return;
                definitions = ModelFactoryForUser.getInstance().load(filename);
                existingCategory = definitions.getCategory(exportCategory.getId());
                if (existingCategory == null) {
                    definitions.getCategories().add(exportCategory);
                } else {
                    title = SnippetsMessages.SnippetCustomizerDialog_2;
                    message = NLS.bind((String)SnippetsMessages.SnippetCustomizerDialog_4, (Object[])new String[]{existingCategory.getLabel()});
                    answer = MessageDialog.openConfirm((Shell)SnippetCustomizerDialog.this.getShell(), (String)title, (String)message);
                    if (answer) {
                        definitions.getCategories().remove(existingCategory);
                        definitions.getCategories().add(exportCategory);
                    }
                }
                outputStream = null;
                try {
                    try {
                        outputStream = new FileOutputStream(filename);
                        new UserModelDumper().write(definitions, outputStream);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable var10_13) {
                    var9_11 = null;
                    if (outputStream == null) throw var10_13;
                    try {
                        outputStream.close();
                        throw var10_13;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw var10_13;
                }
                {
                    var9_12 = null;
                    if (outputStream == null) break block11;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 233->241)] { 
lbl44:
                // 1 sources

                outputStream.close();
                break block11;
lbl46:
                // 1 sources

                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SnippetCustomizerDialog.access$1(SnippetCustomizerDialog.this);
        }

        public void run() {
            this.handleExport();
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = SnippetCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry != null && SnippetCustomizerDialog.this.getCustomizer() instanceof SnippetsCustomizer) {
                enabled = ((SnippetsCustomizer)SnippetCustomizerDialog.this.getCustomizer()).canExport(entry);
            }
            this.setEnabled(enabled);
        }
    }

    private class ImportAction
    extends PaletteCustomizationAction {
        public ImportAction() {
            this.setEnabled(false);
            this.setText(SnippetsMessages.SnippetCustomizerDialog_0);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/import.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/import.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/import.gif"));
        }

        protected PaletteContainer determineContainerForNewEntry(PaletteEntry selected) {
            if (selected instanceof PaletteContainer) {
                return (PaletteContainer)selected;
            }
            return selected.getParent();
        }

        protected void handleImport() {
            FileDialog fileDialog = new FileDialog(SnippetCustomizerDialog.this.getShell());
            fileDialog.setFileName("snippets.xml");
            String[] filterExtensions = new String[]{"*.xml", "*.*"};
            fileDialog.setFilterExtensions(filterExtensions);
            String filename = fileDialog.open();
            if (filename != null) {
                SnippetDefinitions definitions = ModelFactoryForUser.getInstance().load(filename);
                List importCategories = definitions.getCategories();
                List currentCategories = SnippetManager.getInstance().getDefinitions().getCategories();
                PaletteEntry lastImportEntry = null;
                int i = 0;
                while (i < importCategories.size()) {
                    boolean found = false;
                    int j = 0;
                    while (j < currentCategories.size()) {
                        if (((PaletteEntry)currentCategories.get(j)).getId().compareToIgnoreCase(((PaletteEntry)importCategories.get(i)).getId()) == 0) {
                            String title = SnippetsMessages.SnippetCustomizerDialog_2;
                            String message = NLS.bind((String)SnippetsMessages.SnippetCustomizerDialog_3, (Object[])new String[]{((PaletteEntry)currentCategories.get(j)).getLabel()});
                            boolean answer = MessageDialog.openConfirm((Shell)SnippetCustomizerDialog.this.getShell(), (String)title, (String)message);
                            if (answer) {
                                SnippetManager.getInstance().getPaletteRoot().remove((PaletteEntry)currentCategories.get(j));
                                SnippetManager.getInstance().getPaletteRoot().add((PaletteEntry)importCategories.get(i));
                                lastImportEntry = (PaletteEntry)importCategories.get(i);
                            }
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        SnippetManager.getInstance().getPaletteRoot().add((PaletteEntry)importCategories.get(i));
                        lastImportEntry = (PaletteEntry)importCategories.get(i);
                    }
                    ++i;
                }
                if (lastImportEntry != null) {
                    SnippetCustomizerDialog.this.fTreeviewer.setSelection((ISelection)new StructuredSelection(lastImportEntry), true);
                }
                SnippetCustomizerDialog.this.updateActions();
            }
        }

        public void run() {
            this.handleImport();
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = SnippetCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry != null && SnippetCustomizerDialog.this.getCustomizer() instanceof SnippetsCustomizer) {
                enabled = ((SnippetsCustomizer)SnippetCustomizerDialog.this.getCustomizer()).canImport(entry);
            }
            this.setEnabled(enabled);
        }
    }
}

