/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.wst.common.snippets.internal.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserModelDumper {
    private static UserModelDumper dumper = null;

    public static synchronized UserModelDumper getInstance() {
        if (dumper == null) {
            dumper = new UserModelDumper();
        }
        return dumper;
    }

    protected UserModelDumper() {
    }

    protected void assignEntryProperties(ISnippetsEntry entry, Element owningElement) {
        owningElement.setAttribute("id", entry.getId());
        if (entry.getIconName() != null) {
            owningElement.setAttribute("icon", entry.getIconName());
        }
        owningElement.appendChild(this.createDescription(owningElement.getOwnerDocument(), entry.getDescription()));
        if (entry.getLabel() != null) {
            owningElement.setAttribute("label", entry.getLabel());
        }
        if (entry.getLargeIconName() != null) {
            owningElement.setAttribute("largeicon", entry.getLargeIconName());
        }
    }

    protected void assignSourceFor(ISnippetsEntry entry, Element owningElement) {
        if (entry.getSourceType() == "PLUGINS") {
            PluginRecord record = (PluginRecord)entry.getSourceDescriptor();
            owningElement.setAttribute("plugin", record.getPluginName());
            owningElement.setAttribute("version", record.getPluginVersion());
        } else if (entry.getSourceType() == "WORKSPACE") {
            owningElement.setAttribute("shared", "shared");
        }
    }

    protected Element createCategory(Document doc, ISnippetCategory category) {
        String[] filters;
        Element element = doc.createElement("category");
        this.assignSourceFor(category, element);
        element.setAttribute("id", category.getId());
        if (category instanceof PaletteDrawer) {
            element.setAttribute("initial_state", Integer.toString(((PaletteDrawer)category).getInitialState()));
        }
        if ((filters = category.getFilters()).length > 0) {
            String filtersAttr = filters[0];
            if (filters.length > 1) {
                int i = 1;
                while (i < filters.length) {
                    filtersAttr = String.valueOf(filtersAttr) + " " + filters[i];
                    ++i;
                }
            }
            element.setAttribute("filters", filtersAttr);
        }
        if (category.getSourceType() == "USER") {
            this.assignEntryProperties(category, element);
            int i = 0;
            while (i < category.getChildren().size()) {
                ISnippetItem item = (ISnippetItem)category.getChildren().get(i);
                Element child = this.createItem(doc, item);
                element.appendChild(child);
                ++i;
            }
        }
        return element;
    }

    protected Element createContent(Document doc, ISnippetItem item) {
        Element element = doc.createElement("content");
        String contents = item.getContentString();
        if (contents != null && contents.length() > 0) {
            contents = StringUtils.replace(contents, "\r\n", "\n");
            contents = StringUtils.replace(contents, "\r", "\n");
            element.appendChild(doc.createCDATASection(contents));
        }
        return element;
    }

    protected Element createDescription(Document doc, String description) {
        Element element = doc.createElement("description");
        if (description != null && description.length() > 0) {
            element.appendChild(doc.createCDATASection(description));
        }
        return element;
    }

    protected Document createDocument(SnippetDefinitions defs) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        Element root = document.getDocumentElement();
        int i = 0;
        while (i < defs.getCategories().size()) {
            ISnippetCategory category = (ISnippetCategory)defs.getCategories().get(i);
            Element categoryElement = this.createCategory(document, category);
            root.appendChild(categoryElement);
            ++i;
        }
        return document;
    }

    protected Element createItem(Document doc, ISnippetItem item) {
        Element element = doc.createElement("item");
        this.assignEntryProperties(item, element);
        this.assignSourceFor(item, element);
        element.setAttribute("category", item.getCategory().getId());
        if (item.getClassName() != null) {
            element.setAttribute("class", item.getClassName());
        }
        if (item.getEditorClassName() != null) {
            element.setAttribute("editorclass", item.getEditorClassName());
        }
        element.appendChild(this.createContent(doc, item));
        ISnippetVariable[] variables = item.getVariables();
        int i = 0;
        while (i < variables.length) {
            Element variable = this.createVariable(doc, variables[i]);
            element.appendChild(variable);
            ++i;
        }
        return element;
    }

    protected Element createPluginRecord(Document doc, PluginRecord record) {
        Element element = doc.createElement("plugin");
        element.setAttribute("name", record.getPluginName());
        element.setAttribute("version", record.getPluginVersion());
        return element;
    }

    protected Element createVariable(Document doc, ISnippetVariable variable) {
        Element element = doc.createElement("variable");
        element.setAttribute("id", variable.getId());
        if (variable.getName() != null) {
            element.setAttribute("name", variable.getName());
        }
        if (variable.getDefaultValue() != null) {
            element.setAttribute("default", variable.getDefaultValue());
        }
        element.appendChild(this.createDescription(doc, variable.getDescription()));
        return element;
    }

    protected String getFilename() {
        String name = null;
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.snippets");
            name = String.valueOf(Platform.getStateLocation((Bundle)bundle).toString()) + "/user.xml";
        }
        catch (Exception exception) {
            name = "/user.xml";
        }
        return name;
    }

    public String toXML(ISnippetsEntry entry) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (entry instanceof ISnippetItem) {
            ISnippetItem item = (ISnippetItem)entry;
            Element itemElement = this.createItem(document, item);
            document.getDocumentElement().appendChild(itemElement);
        } else {
            ISnippetCategory category = (ISnippetCategory)entry;
            Element categoryElement = this.createCategory(document, category);
            document.getDocumentElement().appendChild(categoryElement);
        }
        try {
            CommonXML.serialize(document, output);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        String retVal = null;
        try {
            retVal = new String(output.toByteArray(), "utf16");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            retVal = new String(output.toByteArray());
        }
        return retVal;
    }

    public void write(SnippetDefinitions definitions) {
        try {
            FileOutputStream ostream = new FileOutputStream(this.getFilename());
            this.write(definitions, ostream);
        }
        catch (IOException e) {
            Logger.logException("could not save " + this.getFilename(), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(SnippetDefinitions definitions, OutputStream stream) {
        Document document = this.createDocument(definitions);
        try {
            try {
                CommonXML.serialize(document, stream);
                stream.flush();
            }
            catch (IOException e) {
                Logger.log(4, "could not save " + stream, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                stream.close();
                document = null;
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        stream.close();
    }
}

