/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.snippets.internal.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkspaceModelDumper {
    private static WorkspaceModelDumper dumper = null;

    public static synchronized WorkspaceModelDumper getInstance() {
        if (dumper == null) {
            dumper = new WorkspaceModelDumper();
        }
        return dumper;
    }

    protected WorkspaceModelDumper() {
    }

    protected void assignEntryProperties(ISnippetsEntry entry, Element owningElement) {
        owningElement.setAttribute("id", entry.getId());
        owningElement.setAttribute("icon", entry.getIconName());
        owningElement.appendChild(this.createDescription(owningElement.getOwnerDocument(), entry.getDescription()));
        owningElement.setAttribute("label", entry.getLabel());
        owningElement.setAttribute("largeicon", entry.getLargeIconName());
    }

    protected void assignSourceFor(ISnippetsEntry entry, Element owningElement) {
        if (entry.getSourceType() == "WORKSPACE") {
            owningElement.setAttribute("shared", "shared");
        }
    }

    protected Element createCategory(Document doc, ISnippetCategory category) {
        Element element = doc.createElement("category");
        this.assignSourceFor(category, element);
        element.setAttribute("id", category.getId());
        String[] filters = category.getFilters();
        if (filters.length > 0) {
            String filtersAttr = filters[0];
            if (filters.length > 1) {
                int i = 1;
                while (i < filters.length) {
                    filtersAttr = String.valueOf(filtersAttr) + " " + filters[i];
                    ++i;
                }
            }
            element.setAttribute("filters", filtersAttr);
        }
        if (category.getSourceType() == "WORKSPACE") {
            this.assignEntryProperties(category, element);
            int i = 0;
            while (i < category.getChildren().size()) {
                ISnippetItem item = (ISnippetItem)category.getChildren().get(i);
                Element child = this.createItem(doc, item);
                element.appendChild(child);
                ++i;
            }
        }
        return element;
    }

    protected Element createContent(Document doc, ISnippetItem item) {
        Element element = doc.createElement("content");
        element.appendChild(doc.createCDATASection(item.getContentString()));
        return element;
    }

    protected Element createDescription(Document doc, String description) {
        Element element = doc.createElement("description");
        if (description != null) {
            element.appendChild(doc.createCDATASection(description));
        } else {
            element.appendChild(doc.createCDATASection(""));
        }
        return element;
    }

    protected Document createDocument(ISnippetCategory category) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        Element root = document.getDocumentElement();
        Element categoryElement = this.createCategory(document, category);
        root.appendChild(categoryElement);
        return document;
    }

    protected Element createItem(Document doc, ISnippetItem item) {
        Element element = doc.createElement("item");
        this.assignEntryProperties(item, element);
        this.assignSourceFor(item, element);
        element.setAttribute("category", item.getCategory().getId());
        element.setAttribute("class", item.getClassName());
        element.setAttribute("editorclass", item.getEditorClassName());
        element.appendChild(this.createContent(doc, item));
        ISnippetVariable[] variables = item.getVariables();
        int i = 0;
        while (i < variables.length) {
            Element variable = this.createVariable(doc, variables[i]);
            element.appendChild(variable);
            ++i;
        }
        return element;
    }

    protected Element createPluginRecord(Document doc, PluginRecord record) {
        Element element = doc.createElement("plugin");
        element.setAttribute("name", record.getPluginName());
        element.setAttribute("version", record.getPluginVersion());
        return element;
    }

    protected Element createVariable(Document doc, ISnippetVariable variable) {
        Element element = doc.createElement("variable");
        element.setAttribute("id", variable.getId());
        element.setAttribute("name", variable.getName());
        element.setAttribute("default", variable.getDefaultValue());
        element.appendChild(this.createDescription(doc, variable.getDescription()));
        return element;
    }

    public String toXML(ISnippetsEntry entry) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (entry instanceof ISnippetItem) {
            ISnippetItem item = (ISnippetItem)entry;
            Element itemElement = this.createItem(document, item);
            document.getDocumentElement().appendChild(itemElement);
        } else {
            ISnippetCategory category = (ISnippetCategory)entry;
            Element categoryElement = this.createCategory(document, category);
            document.getDocumentElement().appendChild(categoryElement);
        }
        try {
            CommonXML.serialize(document, output);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        String retVal = null;
        try {
            retVal = new String(output.toByteArray(), "utf16");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            retVal = new String(output.toByteArray());
        }
        return retVal;
    }

    public void write(ISnippetCategory category, IFile file) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.write(category, output);
        byte[] array = output.toByteArray();
        try {
            file.setContents((InputStream)new ByteArrayInputStream(array), false, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ISnippetCategory category, OutputStream ostream) {
        Document document = this.createDocument(category);
        try {
            try {
                CommonXML.serialize(document, ostream);
                ostream.flush();
            }
            catch (IOException e) {
                Logger.log(4, "could not save " + ostream, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                ostream.close();
                document = null;
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ostream.close();
    }
}

