/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentProvider {
    protected Document document = null;
    protected ErrorHandler errorHandler = null;
    protected String fileName = null;
    protected boolean fValidating = true;
    protected InputStream inputStream = null;
    protected EntityResolver resolver = null;
    protected Node rootElement = null;
    protected String rootElementName = null;

    public static void main(String[] args) {
        if (args.length < 2) {
            return;
        }
        DocumentProvider p = new DocumentProvider();
        p.setFileName(args[0]);
        p.setRootElementName(args[1]);
        p.getDocument();
    }

    /*
     * Exception decompiling
     */
    protected Document _getParsedDocumentDOM2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 97->100)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Document getDocument() {
        if (this.document == null) {
            this.load();
        }
        return this.document;
    }

    protected DocumentBuilder getDocumentBuilder() {
        return CommonXML.getDocumentBuilder(this.isValidating());
    }

    protected DOMImplementation getDomImplementation() {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            Logger.logException(e1);
        }
        catch (FactoryConfigurationError e1) {
            Logger.logException(e1);
        }
        DOMImplementation impl = builder.getDOMImplementation();
        return impl;
    }

    public Element getElement(String name) {
        if (this.document == null) {
            this.load();
        }
        Element element = null;
        if (this.document != null) {
            element = (Element)this.getNode(this.getRootElement(), name);
        }
        return element;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return new FileInputStream(this.getFileName());
    }

    protected Node getNamedChild(Node parent, String childName) {
        if (parent == null) {
            return null;
        }
        NodeList childList = parent.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            if (childList.item(i).getNodeName().equals(childName)) {
                return childList.item(i);
            }
            ++i;
        }
        return null;
    }

    protected Document getNewDocument() {
        Document result = null;
        try {
            result = this.getDomImplementation().createDocument("", this.getRootElementName(), null);
            NodeList children = result.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                result.removeChild(children.item(i));
                ++i;
            }
            Element settings = result.createElement(this.getRootElementName());
            result.appendChild(settings);
            return result;
        }
        catch (DOMException e) {
            Logger.logException(e);
            return null;
        }
    }

    protected Node getNode(Node node, String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (this.getNamedChild(node, token) == null) {
                node.appendChild(this.document.createElement(token));
            }
            node = this.getNamedChild(node, token);
        }
        return node;
    }

    private EntityResolver getNullEntityResolver() {
        if (this.resolver == null) {
            this.resolver = new EntityResolver(){

                public InputSource resolveEntity(String param1, String param2) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            };
        }
        return this.resolver;
    }

    private ErrorHandler getNullErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new ErrorHandler(){

                public void error(SAXParseException exception) {
                    Logger.logException(exception);
                }

                public void fatalError(SAXParseException exception) {
                    Logger.logException(exception);
                }

                public void warning(SAXParseException exception) {
                    Logger.logException(exception);
                }
            };
        }
        return this.errorHandler;
    }

    protected Document getParsedDocument() {
        File existenceTester;
        Document result = null;
        if (this.inputStream == null && !(existenceTester = new File(this.getFileName())).exists()) {
            return null;
        }
        result = this._getParsedDocumentDOM2();
        return result;
    }

    public Node getRootElement() {
        return this.getRootElement(this.getDocument());
    }

    protected Node getRootElement(Document doc) {
        if (doc == null) {
            return null;
        }
        if (doc.getDocumentElement() != null) {
            return doc.getDocumentElement();
        }
        try {
            Element newRootElement = doc.createElement(this.getRootElementName());
            doc.appendChild(newRootElement);
            return newRootElement;
        }
        catch (DOMException e) {
            Logger.logException(e);
            return null;
        }
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public boolean isValidating() {
        return this.fValidating;
    }

    public void load() {
        this.document = this.getParsedDocument();
        if (this.document != null) {
            this.rootElement = this.getRootElement(this.document);
        }
        if (this.document == null || this.rootElement == null) {
            this.document = this.getNewDocument();
            if (this.document != null) {
                NodeList children = this.document.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    if (children.item(i).getNodeType() == 1 && children.item(i).getNodeName().equals(this.getRootElementName())) {
                        this.rootElement = (Element)children.item(i);
                    }
                    ++i;
                }
                if (this.rootElement == null) {
                    i = 0;
                    while (i < children.getLength()) {
                        if (children.item(i).getNodeType() == 1) {
                            this.rootElement = (Element)children.item(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected void saveDocument(Document odocument, OutputStream stream) throws IOException {
        CommonXML.serialize(odocument, stream);
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public void setInputStream(InputStream newInputStream) {
        this.inputStream = newInputStream;
    }

    public void setRootElementName(String newRootElementName) {
        this.rootElementName = newRootElementName;
    }

    public void setValidating(boolean b) {
        this.fValidating = b;
    }

    public void store() {
        if (this.rootElement == null) {
            this.document = this.getNewDocument();
            this.rootElement = this.document.getDocumentElement();
        }
        try {
            FileOutputStream ostream = new FileOutputStream(this.getFileName());
            this.storeDocument(this.document, ostream);
            ostream.flush();
            ((OutputStream)ostream).close();
        }
        catch (IOException e) {
            Logger.logException("Exception saving document " + this.getFileName(), e);
        }
    }

    protected void storeDocument(Document odocument, OutputStream ostream) {
        try {
            this.saveDocument(odocument, ostream);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }
}

