/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.componentcore.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddFactory;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WSDDArtifactEdit
extends EnterpriseArtifactEdit {
    public static final Class ADAPTER_TYPE;
    public static final String WSIL_FILE_EXT = "wsil";
    public static final String WSDL_FILE_EXT = "wsdl";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_TYPE = clazz;
    }

    public WSDDArtifactEdit(ComponentHandle aHandle, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aHandle, toAccessAsReadOnly);
    }

    public WSDDArtifactEdit(ArtifactEditModel model) {
        super(model);
    }

    public WSDDArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        super(aNature, aModule, toAccessAsReadOnly);
    }

    public WsddResource getWsddXmiResource() {
        return (WsddResource)this.getDeploymentDescriptorResource();
    }

    public int getJ2EEVersion() {
        return this.getWsddXmiResource().getJ2EEVersionID();
    }

    public Resource getDeploymentDescriptorResource() {
        return this.getArtifactEditModel().getResource(this.getWebServicesXmlResourceURI());
    }

    public URI getWebServicesXmlResourceURI() {
        URI resourceURI = J2EEConstants.WEB_SERVICES_WEB_INF_DD_URI_OBJ;
        if (WSDDArtifactEdit.isValidAppClientModule(this.getComponent())) {
            resourceURI = J2EEConstants.WEB_SERVICES_META_INF_DD_URI_OBJ;
        } else if (WSDDArtifactEdit.isValidEJBModule(this.getComponent())) {
            resourceURI = J2EEConstants.WEB_SERVICES_META_INF_DD_URI_OBJ;
        }
        return resourceURI;
    }

    public WebServices getWebServices() {
        if (!this.getComponentHandle().getProject().isAccessible()) {
            return null;
        }
        if (this.getWsddXmiResource().getContents().isEmpty()) {
            return null;
        }
        return (WebServices)this.getDeploymentDescriptorRoot();
    }

    public EObject getDeploymentDescriptorRoot() {
        EList contents = this.getDeploymentDescriptorResource().getContents();
        if (contents.size() > 0) {
            return (EObject)contents.get(0);
        }
        this.addWebServicesIfNecessary(this.getWsddXmiResource());
        if (contents.isEmpty()) {
            return null;
        }
        return (EObject)contents.get(0);
    }

    protected void addWebServicesIfNecessary(WsddResource aResource) {
        if (aResource != null) {
            if (aResource.getContents() == null || aResource.getContents().isEmpty()) {
                WebServices ws = WsddFactory.eINSTANCE.createWebServices();
                aResource.getContents().add((Object)ws);
            }
            aResource.getContents().get(0);
            this.getArtifactEditModel().getModuleURI();
            try {
                aResource.saveIfNecessary();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForRead(ComponentHandle aHandle) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new WSDDArtifactEdit(aHandle, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForWrite(ComponentHandle aHandle) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new WSDDArtifactEdit(aHandle, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForRead(IVirtualComponent aModule) {
        IProject project = aModule.getProject();
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
        return new WSDDArtifactEdit(nature, aModule, true);
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForWrite(IVirtualComponent aModule) {
        IProject project = aModule.getProject();
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
        return new WSDDArtifactEdit(nature, aModule, false);
    }

    public static boolean isValidEJBModule(IVirtualComponent aComponent) {
        return "jst.ejb".equals(aComponent.getComponentTypeId());
    }

    public static boolean isValidWebModule(IVirtualComponent aComponent) {
        return "jst.web".equals(aComponent.getComponentTypeId());
    }

    public static boolean isValidAppClientModule(IVirtualComponent aComponent) {
        return "jst.appclient".equals(aComponent.getComponentTypeId());
    }

    public EObject createModelRoot() {
        return this.createModelRoot(this.getJ2EEVersion());
    }

    public EObject createModelRoot(int version) {
        WsddResource res = (WsddResource)this.getDeploymentDescriptorResource();
        res.setModuleVersionID(version);
        this.addWebServicesIfNecessary(res);
        return this.getWebServices();
    }

    public EObject getContentModelRoot() {
        return this.getWebServices();
    }

    public List getWSILResources() {
        return this.getResources(WSIL_FILE_EXT);
    }

    public List getWSDLResources() {
        return this.getResources(WSDL_FILE_EXT);
    }

    private List getResources(String ext) {
        List resources = this.getArtifactEditModel().getResources();
        ArrayList<Resource> result = new ArrayList<Resource>();
        int i = 0;
        while (i < resources.size()) {
            Resource res = (Resource)resources.get(i);
            if (res != null && res.getURI().fileExtension() != null && res.getURI().fileExtension().equals(ext)) {
                result.add(res);
            }
            ++i;
        }
        return result;
    }

    public Resource getWsdlResource(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        Resource res = null;
        try {
            res = this.getArtifactEditModel().getResource(URI.createURI((String)path));
        }
        catch (Exception exception) {}
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (res != null && res.isLoaded() && serviceHelper.isWSDLResource((Object)res)) {
            return res;
        }
        return null;
    }
}

