/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private static final List EMPTY_LIST = new ArrayList(0);
    static /* synthetic */ Class class$0;

    public ResourceTransferDragAdapter(ISelectionProvider provider) {
        this.fProvider = provider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.convertSelection().size() > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        List resources = this.convertSelection();
        event.data = resources.toArray(new IResource[resources.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail == 2) {
            this.handleFinishedDropMove(event);
        }
    }

    private List convertSelection() {
        ISelection s = this.fProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return EMPTY_LIST;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IResource resource;
            Object element = iter.next();
            if (!(element instanceof IAdaptable)) continue;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) == null) continue;
            result.add(resource);
        }
        return result;
    }

    private void handleFinishedDropMove(DragSourceEvent event) {
        List resources = this.convertSelection();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            try {
                resource.delete(true, null);
            }
            catch (CoreException coreException) {}
        }
    }
}

