/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.mysql.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.SchemaImpl;
import org.eclipse.wst.rdb.internal.mysql.MysqlPlugin;
import org.eclipse.wst.rdb.internal.mysql.catalog.MySqlCatalogDatabase;
import org.eclipse.wst.rdb.internal.mysql.catalog.MySqlCatalogTable;

public class MySqlCatalogSchema
extends SchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257567317125903160L;
    private boolean tablesLoaded = false;

    public synchronized void refresh() {
        this.tablesLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((MySqlCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getTables();
        } else if (id == 13) {
            this.getRoutines();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadTables() {
        if (this.tablesLoaded) {
            return;
        }
        EList tableList = super.getTables();
        tableList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        String query = "SHOW TABLE STATUS FROM " + this.getDatabase().getName();
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                MySqlCatalogTable table = new MySqlCatalogTable();
                table.setName(r.getString("Name"));
                table.setTableType(r.getString("Type"));
                table.setAutoInc(r.getBoolean("Auto_increment"));
                tableList.add((Object)table);
            }
            this.tablesLoaded = true;
            r.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the tables for database " + this.getDatabase().getName(), (Throwable)e));
        }
        this.eSetDeliver(deliver);
    }
}

