/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.editor;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.javascript.ui.internal.common.ContentElement;
import org.eclipse.wst.javascript.ui.internal.editor.ViewerSelectionManagerSelectionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.CaretMediator;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.view.events.CaretEvent;
import org.eclipse.wst.sse.ui.internal.view.events.ICaretListener;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.ITextSelectionListener;

public class SimpleViewerSelectionManagerImpl
implements ViewerSelectionManager {
    ISourceViewer fSourceViewer = null;
    TreeViewer fTreeViewer = null;
    private CaretMediator caretMeditator = null;

    public SimpleViewerSelectionManagerImpl(ISourceViewer sourceViewer, TreeViewer treeViewer) {
        this.fSourceViewer = sourceViewer;
        this.fTreeViewer = treeViewer;
        StyledText textWidget = sourceViewer.getTextWidget();
        textWidget.addSelectionListener((SelectionListener)this);
        this.caretMeditator = new CaretMediator(textWidget);
        this.caretMeditator.addCaretListener((ICaretListener)this);
        int caretPosition = this.fSourceViewer.getTextWidget().getCaretOffset();
        IStructuredSelection structuredSelection = this.setTreeViewerSelection(caretPosition);
        this.setSourceViewerRangeIndication(structuredSelection, false);
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        ContentElement contentElement = (ContentElement)selection.getFirstElement();
        this.fSourceViewer.setSelectedRange(contentElement.getOffset(), contentElement.getLength());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (event instanceof ViewerSelectionManagerSelectionChangedEvent) {
            this.setSourceViewerRangeIndication(selection, false);
        } else {
            this.setSourceViewerRangeIndication(selection, true);
            this.setSourceViewerSelectedRange(selection);
        }
    }

    protected void setSourceViewerRangeIndication(IStructuredSelection selection, boolean moveCursor) {
        if (selection.size() == 1) {
            ContentElement contentElement = (ContentElement)selection.getFirstElement();
            this.fSourceViewer.setRangeIndication(contentElement.getOffset(), contentElement.getLength(), moveCursor);
        } else {
            this.fSourceViewer.removeRangeIndication();
        }
    }

    protected void setSourceViewerSelectedRange(IStructuredSelection selection) {
        if (selection.size() == 1) {
            ContentElement contentElement = (ContentElement)selection.getFirstElement();
            this.fSourceViewer.setSelectedRange(contentElement.getNameOffset(), contentElement.getName().length());
        }
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void caretMoved(CaretEvent event) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
        int caretPosition = event.getPosition();
        this.setTreeViewerSelection(caretPosition);
    }

    protected ContentElement getContentElementAt(ContentElement contentElement, int caretPosition) {
        ContentElement result = null;
        Vector children = contentElement.getChildren();
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                ContentElement eachContentElement = (ContentElement)iter.next();
                result = this.getContentElementAt(eachContentElement, caretPosition);
                if (result == null) continue;
                return result;
            }
        }
        int offset = contentElement.getOffset();
        int length = contentElement.getLength();
        if (caretPosition >= offset && caretPosition <= offset + length) {
            result = contentElement;
        }
        return result;
    }

    protected IStructuredSelection setTreeViewerSelection(int caretPosition) {
        StructuredSelection structuredSelection = null;
        if (this.fTreeViewer != null) {
            ContentElement selection = null;
            TreeItem[] treeItems = this.fTreeViewer.getTree().getItems();
            int i = 0;
            while (i < treeItems.length) {
                ContentElement eachContentElement = (ContentElement)treeItems[i].getData();
                selection = this.getContentElementAt(eachContentElement, caretPosition);
                if (selection != null) break;
                ++i;
            }
            structuredSelection = selection == null ? new StructuredSelection() : new StructuredSelection(selection);
            this.fTreeViewer.setSelection((ISelection)structuredSelection, true);
        }
        return structuredSelection;
    }

    public void disconnectCaretListeners() {
        this.fTreeViewer = null;
        this.fSourceViewer.removeRangeIndication();
        this.caretMeditator.release();
    }

    public void addNodeDoubleClickListener(IDoubleClickListener listener) {
    }

    public void addNodeSelectionListener(INodeSelectionListener listener) {
    }

    public void addTextSelectionListener(ITextSelectionListener listener) {
    }

    public int getCaretPosition() {
        return 0;
    }

    public List getSelectedNodes() {
        return null;
    }

    public void release() {
    }

    public void removeNodeDoubleClickListener(IDoubleClickListener listener) {
    }

    public void removeNodeSelectionListener(INodeSelectionListener listener) {
    }

    public void removeTextSelectionListener(ITextSelectionListener listener) {
    }

    public void setModel(IStructuredModel newModel) {
    }

    public void setTextViewer(ITextViewer newTextViewer) {
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }
}

