/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.server.extensions.internal.editorlaunch.LaunchEditor;
import org.eclipse.wst.rdb.server.extensions.internal.templates.TemplateRegistry;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public abstract class Action
implements IViewActionDelegate {
    protected IStructuredSelection selection = null;
    protected Connection connection = null;
    protected Database database = null;
    protected Schema schema = null;
    protected Table table = null;
    protected DatabaseDefinition dbDef = null;
    protected TemplateRegistry templates = null;
    protected LaunchEditor editLaunch = null;

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void init(IViewPart view) {
    }

    public void launchSQLEditor(String templateName, String title) {
        String ddl = this.getTemplateRegistry().getDefaultDDL(templateName, Utility.getVendorType(this.database));
        if (this.schema != null) {
            ddl = ddl.replaceAll("<schema>", this.schema.getName());
        }
        if (this.table != null) {
            ddl = ddl.replaceAll("<table>", this.table.getName());
        }
        this.getEditorLaunch().launchSQLEditor(ddl, Utility.getConnectionInfo(this.database), title);
    }

    private TemplateRegistry getTemplateRegistry() {
        if (this.templates == null) {
            this.templates = TemplateRegistry.getTemplateRegistry();
        }
        return this.templates;
    }

    protected LaunchEditor getEditorLaunch() {
        if (this.editLaunch == null) {
            this.editLaunch = new LaunchEditor();
        }
        return this.editLaunch;
    }

    protected void init() {
        if (!this.selection.isEmpty()) {
            this.database = null;
            Iterator iter = this.selection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof IVirtualNode) {
                    Object parent = ((IVirtualNode)obj).getParent();
                    ICatalogObject catalogObject = null;
                    while (parent != null && catalogObject == null) {
                        if (parent instanceof IVirtualNode) {
                            parent = ((IVirtualNode)parent).getParent();
                            continue;
                        }
                        if (parent instanceof ICatalogObject) {
                            catalogObject = (ICatalogObject)parent;
                            break;
                        }
                        if (!(parent instanceof Schema)) break;
                        this.database = ((Schema)parent).getDatabase();
                        this.schema = (Schema)parent;
                        this.connection = Utility.getConnectionInfo(this.database).getSharedConnection();
                        this.dbDef = Utility.getDBDef(this.database);
                        break;
                    }
                    if (this.database != null || catalogObject == null) continue;
                    if (catalogObject instanceof Schema) {
                        this.schema = (Schema)catalogObject;
                    } else if (catalogObject instanceof Table) {
                        this.table = (Table)catalogObject;
                        this.schema = this.table.getSchema();
                    }
                    this.database = catalogObject.getCatalogDatabase();
                    this.connection = catalogObject.getConnection();
                    this.dbDef = Utility.getDBDef(this.database);
                    continue;
                }
                if (obj instanceof ICatalogObject) {
                    this.database = ((ICatalogObject)obj).getCatalogDatabase();
                    this.connection = ((ICatalogObject)obj).getConnection();
                    this.dbDef = Utility.getDBDef(this.database);
                    continue;
                }
                if (!(obj instanceof Schema)) continue;
                this.database = ((Schema)obj).getDatabase();
                this.connection = Utility.getConnectionInfo(this.database).getSharedConnection();
                this.dbDef = Utility.getDBDef(this.database);
            }
        }
    }
}

