/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.templates;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public class TemplateRegistry {
    private static final String TEMPLATE_DIR_NAME = "templates";
    private static final String DB2_PATH = "DB2";
    private static final String SQL99_PATH = "SQL99";
    private static final String ORACLE_PATH = "ORACLE";
    private static final String SQLSERVER_PATH = "SQLSERVER";
    private static final String SYBASE_PATH = "SYBASE";
    private static final String INFORMIX_PATH = "INFORMIX";
    private static final String DERBY_PATH = "DERBY";
    private String templateDir = null;
    private static TemplateRegistry registry = null;
    private int databaseType;
    private String sep = System.getProperty("file.separator");

    public static TemplateRegistry getTemplateRegistry() {
        if (registry == null) {
            registry = new TemplateRegistry();
        }
        return registry;
    }

    protected TemplateRegistry() {
    }

    public String getDefaultDDL(String templateFileName, int databaseType) {
        String templateURI;
        this.databaseType = databaseType;
        String bundleURL = String.valueOf(this.getTemplatesDir()) + templateFileName;
        try {
            URL templateUrl = ServerExtensionsPlugin.getDefault().getBundle().getEntry(bundleURL);
            templateURI = new Path(Platform.asLocalURL((URL)templateUrl).getPath()).toString();
        }
        catch (IOException e) {
            ServerExtensionsPlugin.getDefault().writeLog(4, 0, "Error getting template URL: " + bundleURL, e);
            return null;
        }
        catch (NullPointerException e) {
            ServerExtensionsPlugin.getDefault().writeLog(4, 0, "Error getting template URL: " + bundleURL, e);
            return null;
        }
        return this.getDDL(templateURI);
    }

    public String getTemplatesDir() {
        this.templateDir = String.valueOf(this.sep) + TEMPLATE_DIR_NAME + this.sep + this.getVendorPath(this.databaseType) + this.sep;
        return this.templateDir;
    }

    public String getVendorPath(int databaseType) {
        String path = null;
        switch (databaseType) {
            case 2: {
                path = ORACLE_PATH;
                break;
            }
            case 1: {
                path = SQLSERVER_PATH;
                break;
            }
            case 3: {
                path = DB2_PATH;
                break;
            }
            case 4: {
                path = SYBASE_PATH;
                break;
            }
            case 6: {
                path = INFORMIX_PATH;
                break;
            }
            case 7: {
                path = DERBY_PATH;
                break;
            }
            default: {
                path = SQL99_PATH;
            }
        }
        if (path == null || path.length() == 0) {
            path = SQL99_PATH;
        }
        return path;
    }

    public String getDDL(String dir) {
        String ddl = "";
        try {
            File templateFile = new File(dir);
            if (templateFile != null && templateFile.exists()) {
                ddl = Utility.getSourceFromFile(templateFile);
            }
        }
        catch (Exception exception) {
            ddl = "";
        }
        return ddl;
    }
}

