/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;

public class NavigatorContentServiceLabelProvider
implements ILabelProvider {
    private static final String BLANK = "";
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;
    private ListenerList listeners = new ListenerList(1);

    public NavigatorContentServiceLabelProvider(String aViewerId) {
        this.contentService = new NavigatorContentService(aViewerId);
        this.isContentServiceSelfManaged = true;
    }

    public NavigatorContentServiceLabelProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public Image getImage(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        Image image = null;
        int i = 0;
        while (i < labelProviders.length && image == null) {
            image = labelProviders[i].getImage(anElement);
            ++i;
        }
        return image;
    }

    public String getText(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        String text = null;
        int i = 0;
        while (i < labelProviders.length && text == null) {
            text = labelProviders[i].getText(anElement);
            ++i;
        }
        return text == null ? BLANK : text;
    }

    public boolean isLabelProperty(Object anElement, String aProperty) {
        boolean result = false;
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length && !result) {
            result = labelProviders[i].isLabelProperty(anElement, aProperty);
            ++i;
        }
        return result;
    }

    public void addListener(ILabelProviderListener aListener) {
        this.listeners.add((Object)aListener);
    }

    public void removeListener(ILabelProviderListener aListener) {
        this.listeners.remove((Object)aListener);
    }

    public void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }
}

