/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.dnd;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.DropHandlerDescriptor;

public class NavigatorDropSelectionDialog
extends Dialog {
    public static final String SKIP_ON_SINGLE_SELECTION = NavigatorMessages.getString("NavigatorDropSelectionDialog.0");
    private DropHandlerDescriptor[] descriptors;
    private Button[] radios;
    private Button skipDialogOnSingleSelection;
    private Text descriptionText;
    private DropHandlerDescriptor selectedDescriptor;
    private boolean checkedDefault = false;

    public NavigatorDropSelectionDialog(Shell parentShell, DropHandlerDescriptor[] descriptors) {
        super(parentShell);
        this.descriptors = descriptors;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(NavigatorMessages.getString("NavigatorDropSelectionDialog.1"));
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(superComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.radios = new Button[this.descriptors.length];
        Group radioGroup = new Group(composite, 32);
        radioGroup.setLayoutData((Object)new GridData(768));
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginHeight = 0;
        groupLayout.marginWidth = 0;
        groupLayout.verticalSpacing = 0;
        groupLayout.horizontalSpacing = 0;
        groupLayout.numColumns = 1;
        radioGroup.setLayout((Layout)groupLayout);
        final int arrayLength = this.descriptors.length;
        int i = 0;
        while (i < arrayLength) {
            this.radios[i] = new Button((Composite)radioGroup, 16);
            this.radios[i].setText(this.descriptors[i].getName());
            this.radios[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object source = e.getSource();
                    int j = 0;
                    while (j < arrayLength) {
                        if (source == NavigatorDropSelectionDialog.this.radios[j]) {
                            NavigatorDropSelectionDialog.this.selectedDescriptor = NavigatorDropSelectionDialog.this.descriptors[j];
                            NavigatorDropSelectionDialog.this.descriptionText.setText(NavigatorDropSelectionDialog.this.selectedDescriptor.getDescription());
                            return;
                        }
                        ++j;
                    }
                    NavigatorDropSelectionDialog.this.selectedDescriptor = null;
                    NavigatorDropSelectionDialog.this.descriptionText.setText("");
                }
            });
            ++i;
        }
        this.descriptionText = new Text(composite, 2112);
        GridData descriptionTextGridData = new GridData(768);
        descriptionTextGridData.heightHint = this.convertHeightInCharsToPixels(3);
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
        this.descriptionText.setBackground(superComposite.getBackground());
        this.skipDialogOnSingleSelection = new Button(composite, 32);
        this.skipDialogOnSingleSelection.setText(NavigatorMessages.getString("NavigatorDropSelectionDialog.3"));
        this.skipDialogOnSingleSelection.setLayoutData((Object)new GridData(768));
        this.checkedDefault = NavigatorPlugin.getDefault().getDialogSettings().getBoolean(SKIP_ON_SINGLE_SELECTION);
        this.skipDialogOnSingleSelection.setSelection(this.checkedDefault);
        this.setDefaultSelection();
        return composite;
    }

    protected void okPressed() {
        if (this.checkedDefault != this.skipDialogOnSingleSelection.getSelection()) {
            NavigatorPlugin.getDefault().getDialogSettings().put(SKIP_ON_SINGLE_SELECTION, this.skipDialogOnSingleSelection.getSelection());
        }
        super.okPressed();
    }

    private void setDefaultSelection() {
        this.radios[0].setSelection(true);
        this.selectedDescriptor = this.descriptors[0];
        this.descriptionText.setText(this.selectedDescriptor.getDescription());
    }

    public DropHandlerDescriptor getSelectedDescriptor() {
        return this.selectedDescriptor;
    }
}

