/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonOpenListener;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.DelegateCommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.DelegateCommonOpenListener;
import org.eclipse.wst.common.navigator.internal.views.extensions.IdentityComparator;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonActionProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonLabelProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonOpenListener;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonTreeContentProvider;

public class NavigatorContentExtension
implements INavigatorContentExtension {
    private NavigatorContentDescriptor descriptor;
    private INavigatorContentProvider contentProvider;
    private ICommonLabelProvider labelProvider;
    private ICommonActionProvider actionProvider;
    private NavigatorContentService contentService;
    private ICommonOpenListener openListener;
    private Comparator comparator;
    private boolean labelProviderInitializationFailed = false;
    private boolean contentProviderInitializationFailed = false;
    private boolean actionProviderInitializationFailed = false;
    private boolean openServiceInitializationFailed = false;
    private boolean comparatorInitializationFailed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INavigatorContentProvider getContentProvider() {
        if (this.contentProvider != null || this.contentProviderInitializationFailed) {
            return this.contentProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.contentProvider == null) {
                    ITreeContentProvider treeContentProvider = (ITreeContentProvider)this.descriptor.getConfigurationElement().createExecutableExtension("contentProvider");
                    this.contentProvider = treeContentProvider != null ? new NavigatorContentProvider(treeContentProvider) : new NavigatorContentProvider(SkeletonTreeContentProvider.INSTANCE);
                }
            }
            catch (CoreException e) {
                this.contentProviderInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.contentProviderInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.contentProviderInitializationFailed) {
                this.contentProvider = new NavigatorContentProvider(SkeletonTreeContentProvider.INSTANCE);
            }
        }
        return this.contentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonLabelProvider getLabelProvider() {
        if (this.labelProvider != null || this.labelProviderInitializationFailed) {
            return this.labelProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.labelProvider == null) {
                    ILabelProvider tempLabelProvider = (ILabelProvider)this.descriptor.getConfigurationElement().createExecutableExtension("labelProvider");
                    if (tempLabelProvider instanceof ICommonLabelProvider) {
                        this.labelProvider = (ICommonLabelProvider)tempLabelProvider;
                        this.labelProvider.initialize(this.contentService.getViewerId());
                    } else {
                        this.labelProvider = new DelegateCommonLabelProvider(tempLabelProvider);
                    }
                }
            }
            catch (CoreException e) {
                this.labelProviderInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.labelProviderInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.labelProviderInitializationFailed) {
                this.labelProvider = SkeletonLabelProvider.INSTANCE;
            }
        }
        return this.labelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonActionProvider getActionProvider() {
        if (this.actionProvider != null || this.actionProviderInitializationFailed) {
            return this.actionProvider;
        }
        if (this.descriptor.getConfigurationElement().getAttribute("actionProvider") == null) {
            this.actionProvider = SkeletonActionProvider.INSTANCE;
            return this.actionProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.actionProvider == null) {
                    this.actionProvider = (ICommonActionProvider)this.descriptor.getConfigurationElement().createExecutableExtension("actionProvider");
                    if (this.actionProvider == null) {
                        this.actionProvider = SkeletonActionProvider.INSTANCE;
                    }
                }
            }
            catch (CoreException e) {
                this.actionProviderInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.actionProviderInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.actionProviderInitializationFailed) {
                this.actionProvider = SkeletonActionProvider.INSTANCE;
            }
        }
        return this.actionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonOpenListener getOpenListener() {
        if (this.openListener != null || this.openServiceInitializationFailed) {
            return this.openListener;
        }
        if (this.descriptor.getConfigurationElement().getAttribute("openListener") == null) {
            this.openListener = SkeletonOpenListener.INSTANCE;
            return this.openListener;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.openListener == null) {
                    IOpenListener tempOpenListener = (IOpenListener)this.descriptor.getConfigurationElement().createExecutableExtension("openListener");
                    this.openListener = tempOpenListener instanceof ICommonOpenListener ? (ICommonOpenListener)tempOpenListener : new DelegateCommonOpenListener(tempOpenListener);
                }
            }
            catch (CoreException e) {
                this.openServiceInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.openServiceInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.openServiceInitializationFailed) {
                this.openListener = SkeletonOpenListener.INSTANCE;
            }
        }
        return this.openListener;
    }

    public void init(NavigatorContentDescriptor aContentDescriptor, NavigatorContentService aContentService) {
        this.descriptor = aContentDescriptor;
        this.contentService = aContentService;
    }

    public void dispose() {
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.actionProvider != null) {
            this.actionProvider.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator getComparator() {
        if (this.comparator != null || this.comparatorInitializationFailed) {
            return this.comparator;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                String sorterClassName;
                if (this.comparator == null && (sorterClassName = this.descriptor.getConfigurationElement().getAttribute("sorter")) != null && sorterClassName.length() > 0) {
                    this.comparator = (Comparator)this.descriptor.getConfigurationElement().createExecutableExtension("sorter");
                }
            }
            catch (CoreException e) {
                this.comparatorInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.comparatorInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.comparatorInitializationFailed || this.comparator == null) {
                this.comparator = IdentityComparator.INSTANCE;
            }
        }
        return this.comparator;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean hasContentProviderInitializationFailed() {
        return this.contentProviderInitializationFailed;
    }

    public boolean hasLabelProviderInitializationFailed() {
        return this.labelProviderInitializationFailed;
    }
}

