/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.io.OutputStream;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeader;
import org.eclipse.wst.wsdl.internal.impl.ExtensibilityElementImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.wst.wsdl.util.ExtensibilityElementFactory;
import org.eclipse.wst.wsdl.util.ExtensibilityElementFactoryRegistry;
import org.eclipse.wst.wsdl.util.WSDLConstants;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UtilTest
extends TestCase {
    private String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    private static Definition definition = null;

    public UtilTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UtilTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new UtilTest("WSDLConstants"){

            protected void runTest() {
                this.testConstants();
            }
        });
        suite.addTest((Test)new UtilTest("WSDLResourceFactoryImpl"){

            protected void runTest() {
                this.testWSDLResourceFactoryImpl();
            }
        });
        suite.addTest((Test)new UtilTest("WSDLResourceImpl"){

            protected void runTest() {
                this.testWSDLResourceImpl();
            }
        });
        suite.addTest((Test)new UtilTest("ExtensibilityElementFactory"){

            protected void runTest() {
                this.testExtensibilityElementFactory();
            }
        });
        suite.addTest((Test)new UtilTest("ExtensibilityElementFactoryRegistry"){

            protected void runTest() {
                this.testExtensibilityElementFactoryRegistry();
            }
        });
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testConstants() {
        try {
            new WSDLConstants();
            int type = WSDLConstants.nodeType((String)"port");
            Assert.assertTrue((String)"Node type is not that of port", (type == 10 ? 1 : 0) != 0);
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/LoadAndPrintTest.wsdl");
            Assert.assertTrue((boolean)(definition.eResource() instanceof WSDLResourceImpl));
            int definitionNodeType = WSDLConstants.nodeType((Node)definition.getElement());
            Assert.assertTrue((String)"Node type is not that of definition", (definitionNodeType == 1 ? 1 : 0) != 0);
            boolean isWSDLNamespace = WSDLConstants.isWSDLNamespace((String)definition.getTargetNamespace());
            Assert.assertFalse((String)"This should not be the WSDL Namespace", (boolean)isWSDLNamespace);
            boolean isMatching = WSDLConstants.isMatchingNamespace((String)"http://www.example.org", (String)"http://www.example.org");
            Assert.assertTrue((String)"isMatchingNamespace is incorrect", (boolean)isMatching);
            String attr = WSDLConstants.getAttribute((Element)definition.getElement(), (String)"name");
            Assert.assertTrue((String)"getAttribute is incorrect", (boolean)attr.equals("LoadAndPrintTest"));
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testWSDLResourceFactoryImpl() {
        try {
            WSDLResourceFactoryImpl factoryImpl = new WSDLResourceFactoryImpl();
            Resource resource = factoryImpl.createResource(URI.createFileURI((String)"./samples/createResourceTest.wsdl"));
            Assert.assertTrue((String)"Resource is not of type WSDLResourceImpl", (boolean)(resource instanceof WSDLResourceImpl));
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testWSDLResourceImpl() {
        try {
            WSDLResourceImpl resourceImpl = new WSDLResourceImpl(URI.createFileURI((String)"./samples/createResourceTest.wsdl"));
            Assert.assertTrue((String)"Resource is not of type WSDLResourceImpl", (boolean)(resourceImpl instanceof WSDLResourceImpl));
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/LoadAndPrintTest.wsdl");
            Assert.assertTrue((boolean)(definition.eResource() instanceof WSDLResourceImpl));
            Element element = definition.getElement();
            Document document = definition.getDocument();
            if (element != null) {
                WSDLResourceImpl.serialize((OutputStream)System.out, (Element)element, null);
            }
            if (document != null) {
                WSDLResourceImpl.serialize((OutputStream)System.out, (Document)document, null);
            }
            try {
                resourceImpl.attached((EObject)definition);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testExtensibilityElementFactory() {
        try {
            ExtensibilityElementFactory factory = WSDLPlugin.INSTANCE.getExtensibilityElementFactory("http://schemas.xmlsoap.org/wsdl/soap/");
            if (factory != null) {
                ExtensibilityElement ee = factory.createExtensibilityElement("http://schemas.xmlsoap.org/wsdl/soap/", "header");
                Assert.assertTrue((String)"Problem creating SOAP extensibility element", (boolean)(ee instanceof SOAPHeader));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testExtensibilityElementFactoryRegistry() {
        try {
            ExtensibilityElementFactoryRegistry factoryRegistry = WSDLPlugin.INSTANCE.getExtensibilityElementFactoryRegistry();
            factoryRegistry.registerFactory("http://org.eclipse.wst.wsdl.tests", (ExtensibilityElementFactory)new WSDLTestFactory());
            ExtensibilityElementFactory factory = WSDLPlugin.INSTANCE.getExtensibilityElementFactory("http://org.eclipse.wst.wsdl.tests");
            ExtensibilityElement ee = factory.createExtensibilityElement("http://org.eclipse.wst.wsdl.tests", "TestElement");
            Assert.assertTrue((String)"1. Problem creating custom Test extensibility element", (boolean)(ee instanceof TestExtensibilityElement));
            Assert.assertTrue((String)"2. Problem creating custom Test extensibility element", (boolean)ee.getElementType().getLocalPart().equals("TestElement"));
            Assert.assertTrue((String)"3. Problem creating custom Test extensibility element", (boolean)ee.getElementType().getNamespaceURI().equals("http://org.eclipse.wst.wsdl.tests"));
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    class TestExtensibilityElement
    extends ExtensibilityElementImpl
    implements ExtensibilityElement {
        String ns;
        String name;

        public TestExtensibilityElement(String ns, String name) {
            this.ns = ns;
            this.name = name;
        }

        public QName getElementType() {
            if (this.elementType == null) {
                this.elementType = new QName(this.ns, this.name);
            }
            return this.elementType;
        }
    }

    class WSDLTestFactory
    implements ExtensibilityElementFactory {
        public ExtensibilityElement createExtensibilityElement(String namespace, String localName) {
            return new TestExtensibilityElement(namespace, localName);
        }
    }
}

