/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.util.Iterator;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Namespace;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.UnknownExtensibilityElement;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPBinding;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPFault;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeader;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeaderBase;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeaderFault;
import org.eclipse.wst.wsdl.binding.soap.SOAPOperation;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.wst.wsdl.tests.util.DefinitionVisitor;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Element;

public class WSDLEMFAPITest
extends DefinitionVisitor {
    private String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    private WSDLFactory factory = WSDLFactory.eINSTANCE;
    Definition newDefinition;
    private Message currentMessage;
    private Service currentService;
    private PortType currentPortType;
    private Operation currentOperation;
    private Binding currentBinding;
    private BindingOperation currentBindingOperation;
    private ExtensibleElement currentExtensibleElement;
    private boolean soapOperationVisited;
    private boolean soapBodyVisited;
    private boolean soapBindingVisited;
    private boolean soapAddressVisited;

    public WSDLEMFAPITest(String name) {
        super(name);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.soapOperationVisited = false;
        this.soapBodyVisited = false;
        this.soapBindingVisited = false;
        this.soapAddressVisited = false;
    }

    public WSDLEMFAPITest(Definition definition) {
        super(definition);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.soapOperationVisited = false;
        this.soapBodyVisited = false;
        this.soapBindingVisited = false;
        this.soapAddressVisited = false;
    }

    private void visitDocumentation(Element docElement) {
        if (docElement == null) {
            return;
        }
        this.println("documentation: " + docElement);
    }

    private void println(String s) {
        System.out.println(s);
    }

    protected void visitDefinition(Definition def) {
        Definition root;
        this.newDefinition = root = this.factory.createDefinition();
        root.setDocumentationElement(def.getDocumentationElement());
        root.getDocumentationElement();
        root.setEnclosingDefinition(this.newDefinition);
        root.getEnclosingDefinition();
        root.getContainer();
        this.newDefinition.setQName(def.getQName());
        this.newDefinition.setTargetNamespace(def.getTargetNamespace());
        this.newDefinition.setDocumentBaseURI(def.getDocumentBaseURI());
        this.newDefinition.setLocation(def.getLocation());
        this.newDefinition.setEncoding(def.getEncoding());
        Iterator iterator = def.getENamespaces().iterator();
        Namespace ns = null;
        String prefix = null;
        String uri = null;
        while (iterator.hasNext()) {
            ns = this.factory.createNamespace();
            prefix = ((Namespace)iterator.next()).getPrefix();
            uri = ((Namespace)iterator.next()).getURI();
            ns.setURI(uri);
            ns.setPrefix(prefix);
            this.newDefinition.getENamespaces().add((Object)ns);
        }
        iterator = def.getNamespaces().keySet().iterator();
        prefix = null;
        String namespace = null;
        while (iterator.hasNext()) {
            prefix = (String)iterator.next();
            namespace = def.getNamespace(prefix);
            this.newDefinition.addNamespace(prefix, namespace);
        }
        this.currentExtensibleElement = def;
        super.visitDefinition(def);
        root.setElement(null);
        root.updateElement(true);
        root.getElement();
        root.setElement(null);
        root.updateElement();
    }

    protected void visitImport(Import wsdlImport) {
        Import myImport = this.factory.createImport();
        this.newDefinition.getEImports().add((Object)myImport);
        myImport.setNamespaceURI(wsdlImport.getNamespaceURI());
        myImport.setLocationURI(wsdlImport.getLocationURI());
        myImport.setDocumentationElement(wsdlImport.getDocumentationElement());
        myImport.setEDefinition(this.newDefinition);
        myImport.setESchema(wsdlImport.getESchema());
        myImport.setSchema(wsdlImport.getSchema());
        myImport.setEnclosingDefinition(this.newDefinition);
    }

    protected void visitTypes(Types types) {
        Types myTypes = this.factory.createTypes();
        myTypes.setDocumentationElement(types.getDocumentationElement());
        Iterator iterator = types.getEExtensibilityElements().iterator();
        ExtensibilityElement ee = null;
        types.getSchemas("http://tempuri.org/LoadAndPrintTest/");
        this.currentExtensibleElement = myTypes;
        while (iterator.hasNext()) {
            ee = (ExtensibilityElement)iterator.next();
            this.visitExtensibilityElement(ee);
        }
        myTypes.setEnclosingDefinition(this.newDefinition);
        this.newDefinition.getETypes();
        this.newDefinition.setETypes(myTypes);
    }

    protected void visitPart(Part part) {
        Part myPart = this.factory.createPart();
        myPart.setDocumentationElement(part.getDocumentationElement());
        myPart.setName(part.getName());
        myPart.setElementName(part.getElementName());
        myPart.setTypeName(part.getTypeName());
        myPart.setEMessage(part.getEMessage());
        myPart.setElementDeclaration(part.getElementDeclaration());
        myPart.setTypeDefinition(part.getTypeDefinition());
        Iterator iterator = part.getExtensionAttributes().keySet().iterator();
        QName key = null;
        QName value = null;
        while (iterator.hasNext()) {
            key = (QName)iterator.next();
            value = part.getExtensionAttribute(key);
            myPart.setExtensionAttribute(key, value);
        }
        this.currentMessage.setEnclosingDefinition(this.newDefinition);
        this.currentMessage.addPart((javax.wsdl.Part)myPart);
    }

    protected void visitPortType(PortType portType) {
        this.currentPortType = this.factory.createPortType();
        this.currentPortType.setDocumentationElement(portType.getDocumentationElement());
        this.currentPortType.setQName(portType.getQName());
        this.currentPortType.setUndefined(portType.isUndefined());
        this.currentPortType.setEnclosingDefinition(this.newDefinition);
        this.newDefinition.getEPortTypes().add((Object)this.currentPortType);
        super.visitPortType(portType);
    }

    protected void visitOperation(Operation operation) {
        this.currentOperation = this.factory.createOperation();
        this.currentOperation.setDocumentationElement(operation.getDocumentationElement());
        this.currentOperation.setName(operation.getName());
        this.currentOperation.setStyle(operation.getStyle());
        this.currentOperation.setUndefined(operation.isUndefined());
        operation.getEParameterOrdering();
        this.currentOperation.setEnclosingDefinition(this.newDefinition);
        this.currentPortType.getEOperations().add((Object)this.currentOperation);
        super.visitOperation(operation);
    }

    protected void visitMessage(Message message) {
        this.currentMessage = this.factory.createMessage();
        this.currentMessage.setQName(message.getQName());
        this.currentMessage.setUndefined(message.isUndefined());
        this.newDefinition.addMessage((javax.wsdl.Message)this.currentMessage);
        super.visitMessage(message);
    }

    protected void visitInput(Input input) {
        Input myInput = this.factory.createInput();
        myInput.setDocumentationElement(input.getDocumentationElement());
        myInput.setName(input.getName());
        myInput.getName();
        myInput.setEMessage(input.getEMessage());
        myInput.setEnclosingDefinition(this.newDefinition);
        this.currentOperation.setEInput(myInput);
    }

    protected void visitOutput(Output output) {
        Output myOutput = this.factory.createOutput();
        myOutput.setDocumentationElement(output.getDocumentationElement());
        myOutput.setName(output.getName());
        myOutput.setEMessage(output.getEMessage());
        myOutput.setEnclosingDefinition(this.newDefinition);
        this.currentOperation.setEOutput(myOutput);
    }

    protected void visitFault(Fault fault) {
        Fault myFault = this.factory.createFault();
        myFault.setDocumentationElement(fault.getDocumentationElement());
        myFault.setName(fault.getName());
        myFault.setEMessage(fault.getEMessage());
        myFault.setEnclosingDefinition(this.newDefinition);
        this.currentOperation.getEFaults().add((Object)myFault);
    }

    protected void visitBinding(Binding binding) {
        this.currentBinding = this.factory.createBinding();
        this.newDefinition.getEBindings().add((Object)this.currentBinding);
        this.currentBinding.setDocumentationElement(binding.getDocumentationElement());
        this.currentBinding.setQName(binding.getQName());
        this.currentBinding.setEPortType(binding.getEPortType());
        this.currentBinding.setUndefined(binding.isUndefined());
        this.currentExtensibleElement = this.currentBinding;
        super.visitBinding(binding);
    }

    protected void visitBindingOperation(BindingOperation bindingOperation) {
        this.currentBindingOperation = this.factory.createBindingOperation();
        this.currentBindingOperation.setDocumentationElement(bindingOperation.getDocumentationElement());
        this.currentBindingOperation.setEOperation(bindingOperation.getEOperation());
        this.currentBindingOperation.setName(bindingOperation.getName());
        this.currentBinding.getBindingOperations().add(this.currentBindingOperation);
        this.currentExtensibleElement = this.currentBindingOperation;
        super.visitBindingOperation(bindingOperation);
    }

    protected void visitBindingInput(BindingInput input) {
        BindingInput myInput = this.factory.createBindingInput();
        myInput.setDocumentationElement(input.getDocumentationElement());
        myInput.setName(input.getName());
        myInput.setInput(input.getInput());
        myInput.setEInput(input.getEInput());
        this.currentBindingOperation.setEBindingInput(myInput);
        this.currentExtensibleElement = myInput;
        super.visitBindingInput(input);
    }

    protected void visitBindingOutput(BindingOutput output) {
        BindingOutput myOutput = this.factory.createBindingOutput();
        myOutput.setDocumentationElement(output.getDocumentationElement());
        myOutput.setName(output.getName());
        myOutput.setOutput(output.getOutput());
        myOutput.setEOutput(output.getEOutput());
        this.currentBindingOperation.setEBindingOutput(myOutput);
        this.currentExtensibleElement = myOutput;
        super.visitBindingOutput(output);
    }

    protected void visitBindingFault(BindingFault fault) {
        BindingFault myFault = this.factory.createBindingFault();
        myFault.setDocumentationElement(fault.getDocumentationElement());
        myFault.setName(fault.getName());
        myFault.setEFault(fault.getEFault());
        myFault.setFault(fault.getFault());
        this.currentBindingOperation.getEBindingFaults().add((Object)myFault);
        this.currentExtensibleElement = myFault;
        super.visitBindingFault(fault);
    }

    protected void visitService(Service service) {
        this.currentService = this.factory.createService();
        this.currentService.setDocumentationElement(service.getDocumentationElement());
        this.currentService.setQName(service.getQName());
        this.currentService.setUndefined(service.isUndefined());
        this.newDefinition.getEServices().add((Object)this.currentService);
        super.visitService(service);
    }

    protected void visitPort(Port port) {
        Port myPort = this.factory.createPort();
        myPort.setDocumentationElement(port.getDocumentationElement());
        myPort.setName(port.getName());
        myPort.setEBinding(port.getEBinding());
        this.currentService.getEPorts().add((Object)myPort);
        this.currentExtensibleElement = myPort;
        super.visitPort(port);
    }

    protected void visitExtensibilityElement(ExtensibleElement owner, ExtensibilityElement extensibilityElement) {
        owner.getEExtensibilityElements();
        owner.getExtensibilityElements();
        this.factory.createExtensibilityElement();
        WSDLPlugin.getPlugin();
        WSDLPlugin.INSTANCE.getPluginResourceLocator();
        this.visitExtensibilityElement(extensibilityElement);
    }

    private void visitExtensibilityElement(ExtensibilityElement extensibilityElement) {
        XSDSchemaExtensibilityElement xsee = null;
        UnknownExtensibilityElement uee = null;
        XSDSchemaExtensibilityElement myEE = null;
        if (extensibilityElement instanceof XSDSchemaExtensibilityElement) {
            xsee = myEE = this.factory.createXSDSchemaExtensibilityElement();
            xsee.setSchema(((XSDSchemaExtensibilityElement)extensibilityElement).getSchema());
        } else {
            myEE = this.factory.createUnknownExtensibilityElement();
            uee = (UnknownExtensibilityElement)myEE;
            uee.getChildren();
        }
        myEE.setElementType(extensibilityElement.getElementType());
        myEE.setRequired(extensibilityElement.getRequired());
        myEE.setRequired(extensibilityElement.isRequired());
        if (this.currentExtensibleElement != null) {
            this.currentExtensibleElement.addExtensibilityElement((javax.wsdl.extensions.ExtensibilityElement)myEE);
        }
        if (extensibilityElement instanceof SOAPBody) {
            this.visitSOAPBody((SOAPBody)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPBinding) {
            this.visitSOAPBinding((SOAPBinding)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPAddress) {
            this.visitSOAPAddress((SOAPAddress)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPOperation) {
            this.visitSOAPOperation((SOAPOperation)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPFault) {
            this.visitSOAPFault((SOAPFault)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPHeader) {
            this.visitSOAPHeader((SOAPHeader)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPHeaderFault) {
            this.visitSOAPHeaderFault((SOAPHeaderFault)extensibilityElement);
        }
    }

    private void visitSOAPFault(SOAPFault soapFault) {
        SOAPFault mySoapFault = SOAPFactory.eINSTANCE.createSOAPFault();
        mySoapFault.setEncodingStyles(soapFault.getEncodingStyles());
        mySoapFault.setName(soapFault.getName());
        mySoapFault.setNamespaceURI(soapFault.getNamespaceURI());
        mySoapFault.setUse(soapFault.getUse());
    }

    private void visitSOAPHeader(SOAPHeader soapHeader) {
        SOAPHeaderBase yourSoapHeader = SOAPFactory.eINSTANCE.createSOAPHeaderBase();
        yourSoapHeader.getEncodingStyles();
        SOAPHeader mySoapHeader = SOAPFactory.eINSTANCE.createSOAPHeader();
        mySoapHeader.setMessage(soapHeader.getMessage());
        mySoapHeader.getMessage();
        mySoapHeader.setPart(soapHeader.getPart());
        mySoapHeader.getPart();
        mySoapHeader.setNamespaceURI(soapHeader.getNamespaceURI());
        mySoapHeader.getNamespaceURI();
        mySoapHeader.setUse(soapHeader.getUse());
        mySoapHeader.getUse();
        soapHeader.getHeaderFaults();
    }

    private void visitSOAPHeaderFault(SOAPHeaderFault soapHeaderFault) {
        SOAPHeaderFault mySoapHeaderFault = SOAPFactory.eINSTANCE.createSOAPHeaderFault();
        mySoapHeaderFault.setMessage(soapHeaderFault.getMessage());
        mySoapHeaderFault.setPart(soapHeaderFault.getPart());
        mySoapHeaderFault.setNamespaceURI(soapHeaderFault.getNamespaceURI());
        mySoapHeaderFault.setUse(soapHeaderFault.getUse());
    }

    private void visitSOAPOperation(SOAPOperation soapOperation) {
        this.soapOperationVisited = true;
        SOAPOperation mySoapOperation = SOAPFactory.eINSTANCE.createSOAPOperation();
        mySoapOperation.setSoapActionURI(soapOperation.getSoapActionURI());
        mySoapOperation.setStyle(soapOperation.getStyle());
    }

    private void visitSOAPBody(SOAPBody soapBody) {
        this.soapBodyVisited = true;
        SOAPBody mySoapBody = SOAPFactory.eINSTANCE.createSOAPBody();
        mySoapBody.setEncodingStyles(soapBody.getEncodingStyles());
        mySoapBody.setNamespaceURI(soapBody.getNamespaceURI());
        mySoapBody.setParts(soapBody.getParts());
        mySoapBody.setUse(soapBody.getUse());
    }

    private void visitSOAPBinding(SOAPBinding soapBinding) {
        this.soapBindingVisited = true;
        SOAPBinding mySoapBinding = SOAPFactory.eINSTANCE.createSOAPBinding();
        mySoapBinding.setStyle(soapBinding.getStyle());
        mySoapBinding.setTransportURI(soapBinding.getTransportURI());
    }

    private void visitSOAPAddress(SOAPAddress soapAddress) {
        this.soapAddressVisited = true;
        SOAPAddress mySoapAddress = SOAPFactory.eINSTANCE.createSOAPAddress();
        mySoapAddress.setLocationURI(soapAddress.getLocationURI());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new WSDLEMFAPITest("ModelSemanticTest"){

            protected void runTest() {
                this.testModelSemantic();
            }
        });
        return suite;
    }

    public void testModelSemantic() {
        try {
            Definition def = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/LoadAndPrintTest.wsdl", true);
            WSDLEMFAPITest test = new WSDLEMFAPITest(def);
            test.visit();
            this.serialize(test.newDefinition);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    private void serialize(Definition def) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        WSDLResourceImpl wsdlMainResource = (WSDLResourceImpl)resourceSet.createResource(URI.createURI((String)"*.wsdl"));
        wsdlMainResource.getContents().add((Object)def);
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject myWebProject = myWorkspaceRoot.getProject("org.eclipse.wst.wsdl.tests");
        if (!myWebProject.exists()) {
            myWebProject.create(null);
        }
        String baseDir = myWebProject.getLocation().toString();
        DefinitionLoader.store(def, String.valueOf(baseDir) + "/ClonedLoadAndPrintTest.wsdl");
    }

    public static void main(String[] args) {
        TestRunner.run((Test)WSDLEMFAPITest.suite());
    }
}

