/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.filesystem;

import org.eclipse.jst.validation.sample.filesystem.FilesystemLoader;
import org.eclipse.jst.validation.sample.filesystem.FilesystemManager;
import org.eclipse.jst.validation.sample.filesystem.FullReporter;
import org.eclipse.jst.validation.sample.filesystem.IncrementalReporter;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class FilesystemApplication {
    public static void main(String[] argv) {
        IFileDelta[] files = FilesystemManager.getManager().getFileDeltas(argv);
        boolean fullBuild = files == null || files.length == 0;
        Object reporter = null;
        reporter = fullBuild ? new FullReporter() : new IncrementalReporter();
        FilesystemLoader[] loaders = FilesystemManager.getManager().getLoaders(files);
        int i = 0;
        while (i < loaders.length) {
            Message message;
            FilesystemLoader loader = loaders[i];
            try {
                ValidatorLauncher.getLauncher().start((IValidationContext)loader.getHelper(), loader.getValidator(), (IReporter)reporter);
                if (!fullBuild) {
                    ((IncrementalReporter)reporter).report();
                }
            }
            catch (ValidationException exc) {
                message = new Message("filesystem", 1, "VFFS0000", new String[]{loader.getValidator().getClass().getName()});
                reporter.displaySubtask(loader.getValidator(), (IMessage)message);
                if (exc.getAssociatedMessage() != null) {
                    System.out.println(exc.getAssociatedMessage());
                }
                exc.printStackTrace();
                if (exc.getAssociatedException() != null) {
                    exc.getAssociatedException().printStackTrace();
                }
            }
            catch (Exception exc) {
                message = new Message("filesystem", 1, "VFFS0000", new String[]{loader.getValidator().getClass().getName()});
                reporter.displaySubtask(loader.getValidator(), (IMessage)message);
                exc.printStackTrace();
            }
            ++i;
        }
    }
}

