/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.validation.sample.parser.MessageMetaData;
import org.eclipse.jst.validation.sample.parser.PropertyFile;
import org.eclipse.jst.validation.sample.parser.PropertyLine;
import org.eclipse.jst.validation.sample.parser.PropertyLineComparator;

public abstract class APropertyFile {
    private static final String EQUALS = "=";
    private List _propertyLines = new ArrayList();
    private List _parseWarnings = new ArrayList();
    private boolean _debug = false;

    public abstract String getQualifiedFileName();

    public abstract void report(String var1);

    public abstract void report(MessageMetaData var1);

    protected APropertyFile() {
    }

    public void addParseWarnings(List list) {
        this._parseWarnings.addAll(list);
    }

    public void addParseWarning(MessageMetaData mmd) {
        this._parseWarnings.add(mmd);
    }

    public List getParseWarnings() {
        return this._parseWarnings;
    }

    public String toString() {
        return this.getQualifiedFileName();
    }

    public boolean debug() {
        return this._debug;
    }

    protected void setDebug(boolean d) {
        this._debug = d;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PropertyFile)) {
            return false;
        }
        PropertyFile file = (PropertyFile)o;
        return this.getQualifiedFileName().equals(file.getQualifiedFileName());
    }

    public int hashCode() {
        return this.getQualifiedFileName().hashCode();
    }

    public int getNumProperties() {
        return this._propertyLines.size();
    }

    public int getNumWords() {
        Iterator iterator = this._propertyLines.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            count += line.getNumWords();
        }
        return count;
    }

    public int getNumUniquePrefixes() {
        HashSet<String> uniqueIds = new HashSet<String>();
        Iterator iterator = this.getPropertyLines().iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            if (!line.hasMessagePrefix()) continue;
            uniqueIds.add(line.getMessagePrefix());
        }
        return uniqueIds.size();
    }

    public int getNumPrefixes() {
        int count = 0;
        Iterator iterator = this.getPropertyLines().iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            if (!line.hasMessagePrefix()) continue;
            ++count;
        }
        return count;
    }

    public int getNumWithoutPrefixes() {
        int count = 0;
        Iterator iterator = this.getPropertyLines().iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            if (line.hasMessagePrefix()) continue;
            ++count;
        }
        return count;
    }

    public List getPropertyLines() {
        return this._propertyLines;
    }

    public PropertyLine getPropertyLine(String messageId) {
        Collections.sort(this._propertyLines, PropertyLineComparator.getMessageIdComparator());
        int index = Collections.binarySearch(this._propertyLines, messageId, PropertyLineComparator.getMessageIdComparator());
        if (index < 0) {
            return null;
        }
        PropertyLine result = (PropertyLine)this._propertyLines.get(index);
        return result;
    }

    protected void parseFile(File propertyFile) {
        FileReader input = null;
        LineNumberReader lineInput = null;
        try {
            input = new FileReader(propertyFile);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        lineInput = new LineNumberReader(input);
        this.parseFile(lineInput);
        try {
            lineInput.close();
        }
        catch (IOException iOException) {}
        input = null;
        lineInput = null;
    }

    /*
     * Exception decompiling
     */
    protected void parseFile(LineNumberReader lineInput) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [10 : 385->392)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void printAllMessagePrefixes() {
        this.report("Line Number\tMessage prefix\tMessage id");
        Collections.sort(this._propertyLines, PropertyLineComparator.getMessagePrefixComparator());
        Iterator iterator = this._propertyLines.iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            if (line.getMessagePrefix() == null || line.getMessagePrefix().equals("")) continue;
            StringBuffer buffer = new StringBuffer(String.valueOf(line.getLineNumber()));
            buffer.append("\t");
            buffer.append(line.getMessagePrefix());
            buffer.append("\t");
            buffer.append(line.getMessageId());
            this.report(buffer.toString());
        }
    }

    public void printAllMissingMessagePrefixes() {
        int lastNumber = -1;
        Collections.sort(this._propertyLines, PropertyLineComparator.getMessagePrefixComparator());
        Iterator iterator = this._propertyLines.iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            String prefix = line.getMessagePrefix();
            int prefixNumber = 0;
            if (prefix == null || prefix.equals("")) continue;
            String prefixLetters = prefix.substring(0, 4);
            try {
                prefixNumber = Integer.parseInt(prefix.substring(4, 8));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (lastNumber != -1 && prefixNumber != lastNumber + 1) {
                int i = lastNumber + 1;
                while (i < prefixNumber) {
                    this.report(String.valueOf(prefixLetters) + i);
                    ++i;
                }
            }
            lastNumber = prefixNumber;
        }
    }

    public void printAllMessagesWithAMessagePrefix() {
        this.report("MESSAGES WITH PREFIXES");
        Collections.sort(this._propertyLines, PropertyLineComparator.getLineNoComparator());
        Iterator iterator = this._propertyLines.iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            if (!line.hasMessagePrefix()) continue;
            this.report(line.toString());
        }
    }

    public void printAllMessagesWithoutAMessagePrefix() {
        this.report("BLANK MESSAGE PREFIX");
        Collections.sort(this._propertyLines, PropertyLineComparator.getLineNoComparator());
        Iterator iterator = this._propertyLines.iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            if (line.hasMessagePrefix()) continue;
            this.report(line.toString());
        }
    }

    public void printAllMessagesWhichAreBlank() {
        this.report("BLANK MESSAGES");
        Collections.sort(this._propertyLines, PropertyLineComparator.getLineNoComparator());
        Iterator iterator = this._propertyLines.iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            if (!line.getMessage().equals("")) continue;
            StringBuffer buffer = new StringBuffer("line number ");
            buffer.append(line.getLineNumber());
            buffer.append(", message id ");
            buffer.append(line.getMessageId());
            this.report(buffer.toString());
        }
    }

    public void printSyntaxWarnings() {
        List parseWarnings = this.getParseWarnings();
        Iterator iterator = parseWarnings.iterator();
        while (iterator.hasNext()) {
            this.report((MessageMetaData)iterator.next());
        }
    }

    public void printDuplicateMessageId() {
        this.printDuplicateMessageId(true);
    }

    public void printDuplicateMessageId(boolean printTitle) {
        MessageMetaData mmd;
        if (printTitle) {
            this.report("DUPLICATE MESSAGE IDS");
        }
        Comparator c = PropertyLineComparator.getMessageIdComparator();
        String messageId = "ABCD0060";
        Collections.sort(this._propertyLines, c);
        Iterator iterator = this._propertyLines.iterator();
        PropertyLine lastLine = null;
        PropertyLine line = null;
        boolean needToPrintLast = false;
        while (iterator.hasNext()) {
            lastLine = line;
            if (c.compare(lastLine, line = (PropertyLine)iterator.next()) == 0) {
                needToPrintLast = true;
                mmd = new MessageMetaData("propertiesValidator", 2, messageId, new String[]{lastLine.getMessageId()}, lastLine, lastLine.getLineNumber());
                this.report(mmd);
                continue;
            }
            if (!needToPrintLast) continue;
            needToPrintLast = false;
            mmd = new MessageMetaData("propertiesValidator", 2, messageId, new String[]{lastLine.getMessageId()}, lastLine, lastLine.getLineNumber());
            this.report(mmd);
        }
        if (needToPrintLast) {
            mmd = new MessageMetaData("propertiesValidator", 2, messageId, new String[]{line.getMessageId()}, line, line.getLineNumber());
            this.report(mmd);
        }
    }

    public void printDuplicateMessagePrefix() {
        this.printDuplicateMessagePrefix(true);
    }

    public void printDuplicateMessagePrefix(boolean printTitle) {
        MessageMetaData mmd;
        if (printTitle) {
            this.report("DUPLICATE MESSAGE PREFIXES");
        }
        Comparator c = PropertyLineComparator.getMessagePrefixComparator();
        Collections.sort(this._propertyLines, c);
        String messageId = "ABCD0070";
        Iterator iterator = this._propertyLines.iterator();
        PropertyLine lastLine = null;
        PropertyLine line = null;
        boolean needToPrintLast = false;
        while (iterator.hasNext()) {
            lastLine = line;
            line = (PropertyLine)iterator.next();
            if (lastLine == null || lastLine.getMessageId().startsWith(lastLine.getShortMessagePrefix())) continue;
            if (c.compare(lastLine, line) == 0) {
                needToPrintLast = true;
                mmd = new MessageMetaData("propertiesValidator", 2, messageId, new String[]{lastLine.getMessagePrefix()}, lastLine, lastLine.getLineNumber());
                this.report(mmd);
                continue;
            }
            if (!needToPrintLast) continue;
            needToPrintLast = false;
            mmd = new MessageMetaData("propertiesValidator", 2, messageId, new String[]{lastLine.getMessagePrefix()}, lastLine, lastLine.getLineNumber());
            this.report(mmd);
        }
        if (lastLine != null && !lastLine.getMessageId().startsWith(lastLine.getShortMessagePrefix()) && needToPrintLast) {
            mmd = new MessageMetaData("propertiesValidator", 2, messageId, new String[]{line.getMessagePrefix()}, line, line.getLineNumber());
            this.report(mmd);
        }
    }

    public void printMessagePrefixStartingWith(String prefix) {
        this.report("Find all error prefixes starting with " + prefix);
        Comparator c = PropertyLineComparator.getMessagePrefixComparator();
        Collections.sort(this._propertyLines, c);
        Iterator iterator = this._propertyLines.iterator();
        PropertyLine line = null;
        while (iterator.hasNext()) {
            line = (PropertyLine)iterator.next();
            if (!line.getMessagePrefix().startsWith(prefix)) continue;
            StringBuffer buffer = new StringBuffer(String.valueOf(line.getLineNumber()));
            buffer.append("\t");
            buffer.append(line.getMessagePrefix());
            buffer.append("\t");
            buffer.append(line.getMessageId());
            this.report(buffer.toString());
        }
    }

    public void printLastMessagePrefixStartingWith(String prefix) {
        this.report("Find last error prefix starting with " + prefix);
        Comparator c = PropertyLineComparator.getMessagePrefixComparator();
        Collections.sort(this._propertyLines, c);
        PropertyLine[] lines = new PropertyLine[this._propertyLines.size()];
        this._propertyLines.toArray(lines);
        boolean found = false;
        int i = lines.length;
        while (i > -1) {
            PropertyLine line = lines[i];
            if (line.getMessagePrefix().startsWith(prefix)) {
                this.report(line.toString());
                found = true;
                break;
            }
            --i;
        }
        if (!found) {
            this.report("No error ids were found that started with " + prefix);
        }
    }

    public void printExpectedStringLength(int length) {
        this.report("EXPECTED LENGTH OF MESSAGE WITH PARAMETERS " + length + " LONG");
        Comparator c = PropertyLineComparator.getStringLengthComparator(length);
        Collections.sort(this._propertyLines, c);
        Iterator iterator = this._propertyLines.iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            StringBuffer buffer = new StringBuffer("Length: ");
            buffer.append(line.getExpectedLength(length));
            buffer.append("\t");
            buffer.append(line.toStringWithExpectedLength(length));
            this.report(buffer.toString());
        }
    }

    public void printStringLength() {
        this.printExpectedStringLength(0);
    }

    public void printContents() {
        this.report("CONTENTS OF .properties FILE, SORTED BY MESSAGE ID");
        Comparator c = PropertyLineComparator.getMessageIdComparator();
        Collections.sort(this._propertyLines, c);
        Iterator iterator = this._propertyLines.iterator();
        while (iterator.hasNext()) {
            PropertyLine line = (PropertyLine)iterator.next();
            this.report(line.toString());
        }
    }
}

