/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jst.validation.sample.parser.PropertyFile;
import org.eclipse.jst.validation.sample.parser.PropertyLine;
import org.eclipse.jst.validation.sample.parser.PropertyLineComparator;

public class CompareProperties {
    public static final String lineSeparator = System.getProperty("line.separator");
    private TreeSet _deleted = new TreeSet();
    private TreeMap _changed = new TreeMap();
    private TreeSet _added = new TreeSet();
    private PropertyFile _oldFile = null;
    private PropertyFile _newFile = null;

    public CompareProperties(PropertyFile oldFile, PropertyFile newFile) {
        this._oldFile = oldFile;
        this._newFile = newFile;
        this.compare(oldFile, newFile);
    }

    private void addChanged(PropertyLine oldLine, PropertyLine newLine) {
        CompareLine cl = (CompareLine)this._changed.get(oldLine.getMessageId());
        if (cl == null) {
            cl = new CompareLine(oldLine.getMessageId());
        }
        cl.add(oldLine, newLine);
        this._changed.put(oldLine.getMessageId(), cl);
    }

    public void compare(PropertyFile oldFile, PropertyFile newFile) {
        this._added.clear();
        this._deleted.clear();
        this._changed.clear();
        ArrayList oldKeys = new ArrayList(oldFile.getPropertyLines());
        ArrayList newKeys = new ArrayList(newFile.getPropertyLines());
        Collections.sort(oldKeys, PropertyLineComparator.getMessageIdComparator());
        Collections.sort(newKeys, PropertyLineComparator.getMessageIdComparator());
        Iterator oldIterator = oldKeys.iterator();
        Iterator newIterator = newKeys.iterator();
        PropertyLine oldLine = oldIterator.hasNext() ? (PropertyLine)oldIterator.next() : null;
        PropertyLine newLine = newIterator.hasNext() ? (PropertyLine)newIterator.next() : null;
        while (oldLine != null && newLine != null) {
            int compare = oldLine.getMessageId().compareTo(newLine.getMessageId());
            if (compare < 0) {
                this._deleted.add(oldLine);
                if (oldIterator.hasNext()) {
                    oldLine = (PropertyLine)oldIterator.next();
                    continue;
                }
                oldLine = null;
                continue;
            }
            if (compare == 0) {
                if (!oldLine.getMessage().equals(newLine.getMessage())) {
                    this.addChanged(oldLine, newLine);
                }
                if (oldIterator.hasNext() && newIterator.hasNext()) {
                    oldLine = (PropertyLine)oldIterator.next();
                    newLine = (PropertyLine)newIterator.next();
                    continue;
                }
                oldLine = null;
                newLine = null;
                continue;
            }
            this._added.add(newLine);
            newLine = newIterator.hasNext() ? (PropertyLine)newIterator.next() : null;
        }
        if (oldLine != null) {
            this._deleted.add(oldLine);
        }
        if (newLine != null) {
            this._added.add(newLine);
        }
        while (oldIterator.hasNext()) {
            this._deleted.add(oldIterator.next());
        }
        while (newIterator.hasNext()) {
            this._added.add(newIterator.next());
        }
    }

    public Set getAdded() {
        return this._added;
    }

    public Collection getChanged() {
        return this._changed.values();
    }

    public Set getDeleted() {
        return this._deleted;
    }

    public void printResults() {
        int numNew = this.printStrings("NEW PROPERTIES", this._added);
        int numWordsDeleted = this.printStrings("DELETED PROPERTIES", this._deleted);
        int numWordsChanged = this.printStrings("CHANGED PROPERTIES", this._changed.values());
        float totalChange = numNew + numWordsDeleted + numWordsChanged;
        float numWords = this._newFile.getNumWords();
        float percent = totalChange / numWords * 100.0f;
        System.out.println();
        System.out.println("Number of new words: " + numNew);
        System.out.println("Number of words in deleted messages: " + numWordsDeleted);
        System.out.println("Number of changed words in modified messages: " + numWordsChanged);
        System.out.println("Number of words in file " + this._newFile.getQualifiedFileName() + ": " + numWords);
        System.out.println("Total change of words: " + totalChange + ", which is a " + percent + "% change.");
    }

    public void printResultsForTranslation() {
        this.printStringsForTranslation("DELETED PROPERTIES", this._deleted);
        this.printStringsForTranslation("NEW PROPERTIES", this._added);
        this.printStringsForTranslation("CHANGED PROPERTIES", this._changed.values());
    }

    private int printStrings(String header, Collection lines) {
        System.out.println();
        System.out.println(header);
        int count = 0;
        int numWords = 0;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            Object line = iterator.next();
            numWords = line instanceof PropertyLine ? (numWords += ((PropertyLine)line).getNumWords()) : (numWords += ((CompareLine)line).getNumWords());
            ++count;
            System.out.println(line);
        }
        System.out.println("Number of properties: " + count);
        System.out.println();
        return numWords;
    }

    private void printStringsForTranslation(String header, Collection lines) {
        System.out.println();
        System.out.println(header);
        int count = 0;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            Comparable propline;
            ++count;
            Object line = iterator.next();
            if (line instanceof PropertyLine) {
                propline = (PropertyLine)line;
                System.out.println(((PropertyLine)propline).getMessageId());
                continue;
            }
            if (line instanceof CompareLine) {
                propline = (CompareLine)line;
                System.out.println(((CompareLine)propline).getMessageId());
                continue;
            }
            System.out.println("instance of " + line.getClass().getName());
        }
        System.out.println("Total: " + count);
        System.out.println();
    }

    class CompareLine
    implements Comparable {
        private ArrayList _lines;
        private final String _messageId;

        public CompareLine(String messageId) {
            this._messageId = messageId;
            this._lines = new ArrayList();
        }

        public void add(PropertyLine oldLine, PropertyLine newLine) {
            this._lines.add(new PropertyLine[]{oldLine, newLine});
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = this._lines.iterator();
            while (iterator.hasNext()) {
                buffer.append(lineSeparator);
                buffer.append("\t");
                PropertyLine[] lines = (PropertyLine[])iterator.next();
                buffer.append(lines[0]);
                buffer.append("\n");
                buffer.append(lines[1]);
            }
            return buffer.toString();
        }

        public int getNumWords() {
            int numWords = 0;
            Iterator iterator = this._lines.iterator();
            while (iterator.hasNext()) {
                PropertyLine[] lines = (PropertyLine[])iterator.next();
                numWords += this.compare(lines[0], lines[1]);
            }
            return numWords;
        }

        private int compare(PropertyLine oldLine, PropertyLine newLine) {
            int numChangedWords = 0;
            StringTokenizer oldTokenizer = new StringTokenizer(oldLine.getMessage());
            StringTokenizer newTokenizer = new StringTokenizer(newLine.getMessage());
            ArrayList<String> newWords = new ArrayList<String>();
            while (newTokenizer.hasMoreTokens()) {
                newWords.add(newTokenizer.nextToken());
            }
            while (oldTokenizer.hasMoreTokens()) {
                String oldWord = oldTokenizer.nextToken();
                if (newWords.contains(oldWord)) {
                    newWords.remove(oldWord);
                    continue;
                }
                ++numChangedWords;
            }
            return numChangedWords += newWords.size();
        }

        public String getMessageId() {
            return this._messageId;
        }

        public int compareTo(Object o) {
            if (!(o instanceof CompareLine)) {
                return 1;
            }
            return this.getMessageId().compareTo(((CompareLine)o).getMessageId());
        }
    }
}

