/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageMetaData {
    public static final int INT_UNSET = -1;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    private String _bundleName = null;
    private int _severity = -1;
    private String _messageId = null;
    private String[] _parms = null;
    private Object _targetObject = null;
    private int _lineNumber = -1;
    private int _offset = -1;
    private int _length = -1;
    private String _text = null;

    public MessageMetaData(String messageText) {
        this._text = messageText;
    }

    public MessageMetaData(String bundleName, int severity, String messageId, String[] parms, Object targetObject, int lineNumber) {
        this(bundleName, severity, messageId, parms, targetObject, lineNumber, -1, -1);
    }

    public MessageMetaData(String bundleName, int severity, String messageId, String[] parms, Object targetObject, int lineNumber, int offset, int length) {
        this._bundleName = bundleName;
        this._severity = severity;
        this._messageId = messageId;
        this._parms = parms;
        this._targetObject = targetObject;
        this._lineNumber = lineNumber;
        this._offset = offset;
        this._length = length;
    }

    public String getBundleName() {
        return this._bundleName;
    }

    public int getSeverity() {
        return this._severity;
    }

    public String getId() {
        return this._messageId;
    }

    public String[] getParams() {
        return this._parms;
    }

    public Object getTargetObject() {
        return this._targetObject;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLength() {
        return this._length;
    }

    public String getText(ClassLoader classLoader) {
        if (this._text == null) {
            return this.getText(Locale.getDefault(), classLoader);
        }
        return this._text;
    }

    public String getText(Locale locale, ClassLoader classLoader) {
        if (this._text == null) {
            return MessageMetaData.getText(this.getBundleName(), locale, classLoader, this.getId(), this.getParams());
        }
        return this._text;
    }

    public static String getText(String bundleName, Locale locale, ClassLoader classLoader, String messageId, String[] parms) {
        String message = "";
        if (locale == null) {
            return message;
        }
        ResourceBundle bundle = MessageMetaData.getBundle(bundleName, locale, classLoader);
        if (bundle == null) {
            return message;
        }
        try {
            message = bundle.getString(messageId);
            if (parms != null) {
                message = MessageFormat.format(message, parms);
            }
        }
        catch (MissingResourceException exc) {
            System.err.println(exc.getMessage());
            System.err.println(messageId);
        }
        catch (NullPointerException exc) {
            System.err.println(exc.getMessage());
            System.err.println(messageId);
        }
        return message;
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader classLoader) {
        ResourceBundle bundle = null;
        try {
            bundle = classLoader == null ? ResourceBundle.getBundle(bundleName, locale) : ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        return bundle;
    }
}

